/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Pooling2D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Pooling2D.class);
    protected Pooling2DConfig config;

    public Pooling2D() {
    }

    public Pooling2D(SameDiff sameDiff, SDVariable[] inputs, INDArray[] arrayInputs, INDArray[] arrayOutputs, Pooling2DConfig config) {
        super(null, sameDiff, inputs, false);
        if (arrayInputs != null) {
            this.addInputArgument(arrayInputs);
        }
        if (arrayOutputs != null) {
            this.addOutputArgument(arrayOutputs);
        }
        this.config = config;
        this.addArgs();
    }

    @Override
    public void setValueFor(Field target, Object value) {
        this.config.setValueFor(target, value);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKh());
        this.addIArgument(this.config.getKw());
        this.addIArgument(this.config.getSy());
        this.addIArgument(this.config.getSx());
        this.addIArgument(this.config.getPh());
        this.addIArgument(this.config.getPw());
        this.addIArgument(this.config.getDh());
        this.addIArgument(this.config.getDw());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isSameMode()));
        this.addIArgument(this.config.getType() == Pooling2DType.AVG ? this.config.getDivisor().ordinal() : (int)this.config.getExtra());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.config.isNHWC()));
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public String opName() {
        return this.getPoolingPrefix() + "pool2d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        Pooling2DDerivative pooling2DDerivative = Pooling2DDerivative.derivativeBuilder().inputs(inputs.toArray(new SDVariable[inputs.size()])).sameDiff(this.sameDiff).config(this.config).build();
        ret.addAll(Arrays.asList(pooling2DDerivative.outputVariables()));
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        Pooling2DConfig pooling2DConfig;
        AttrValue aStrides = nodeDef.getAttrOrThrow("strides");
        List<Long> tfStrides = aStrides.getList().getIList();
        Long sY = tfStrides.get(1);
        Long sX = tfStrides.get(2);
        AttrValue aKernels = nodeDef.getAttrOrThrow("ksize");
        List<Long> tfKernels = aKernels.getList().getIList();
        Long kY = tfKernels.get(1);
        Long kX = tfKernels.get(2);
        AttrValue aPadding = nodeDef.getAttrOrThrow("padding");
        List<Long> padding = aPadding.getList().getIList();
        String paddingMode = aPadding.getS().toStringUtf8().replaceAll("\"", "");
        boolean isSameMode = paddingMode.equalsIgnoreCase("SAME");
        if (!isSameMode) {
            log.debug("Mode: {}", (Object)paddingMode);
        }
        this.config = pooling2DConfig = Pooling2DConfig.builder().sy(sY.intValue()).sx(sX.intValue()).type(null).isSameMode(isSameMode).kh(kY.intValue()).kw(kX.intValue()).ph(padding.get(0).intValue()).pw(padding.get(1).intValue()).virtualWidth(1).virtualHeight(1).build();
        this.addArgs();
        log.debug("Pooling: k: [{},{}]; s: [{}, {}], padding: {}", new Object[]{kY, kX, sY, sX, aPadding});
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        Pooling2DConfig pooling2DConfig;
        boolean isSameNode = attributesForNode.get("auto_pad").getS().equals((Object)"SAME");
        List<Long> kernelShape = attributesForNode.get("kernel_shape").getIntsList();
        List<Long> padding = attributesForNode.get("pads").getIntsList();
        List<Long> strides = attributesForNode.get("strides").getIntsList();
        this.config = pooling2DConfig = Pooling2DConfig.builder().sy(strides.get(0).intValue()).sx(strides.get(1).intValue()).type(null).isSameMode(isSameNode).kh(kernelShape.get(0).intValue()).kw(kernelShape.get(1).intValue()).ph(padding.get(0).intValue()).pw(padding.get(1).intValue()).virtualWidth(1).virtualHeight(1).build();
        this.addArgs();
    }

    public String getPoolingPrefix() {
        if (this.config == null) {
            return "somepooling";
        }
        switch (this.config.getType()) {
            case AVG: {
                return "avg";
            }
            case MAX: {
                return "max";
            }
            case PNORM: {
                return "pnorm";
            }
        }
        throw new IllegalStateException("No pooling type found.");
    }

    @Override
    public String onnxName() {
        return "Pooling";
    }

    @Override
    public String tensorflowName() {
        return "Pooling2D";
    }

    public static Pooling2DBuilder builder() {
        return new Pooling2DBuilder();
    }

    public Pooling2DConfig getConfig() {
        return this.config;
    }

    public static class Pooling2DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private INDArray[] arrayInputs;
        private INDArray[] arrayOutputs;
        private Pooling2DConfig config;

        Pooling2DBuilder() {
        }

        public Pooling2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Pooling2DBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public Pooling2DBuilder arrayInputs(INDArray[] arrayInputs) {
            this.arrayInputs = arrayInputs;
            return this;
        }

        public Pooling2DBuilder arrayOutputs(INDArray[] arrayOutputs) {
            this.arrayOutputs = arrayOutputs;
            return this;
        }

        public Pooling2DBuilder config(Pooling2DConfig config) {
            this.config = config;
            return this;
        }

        public Pooling2D build() {
            return new Pooling2D(this.sameDiff, this.inputs, this.arrayInputs, this.arrayOutputs, this.config);
        }

        public String toString() {
            return "Pooling2D.Pooling2DBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", arrayInputs=" + Arrays.deepToString(this.arrayInputs) + ", arrayOutputs=" + Arrays.deepToString(this.arrayOutputs) + ", config=" + this.config + ")";
        }
    }

    public static enum Divisor {
        EXCLUDE_PADDING,
        INCLUDE_PADDING;

    }

    public static enum Pooling2DType {
        MAX,
        AVG,
        PNORM;

    }
}

