/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.util.ArrayUtil;

public class Col2Im
extends DynamicCustomOp {
    protected Conv2DConfig conv2DConfig;

    public Col2Im(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputs, Conv2DConfig conv2DConfig) {
        super(null, inputArrays, outputs);
        if (sameDiff != null) {
            this.sameDiff = sameDiff;
        }
        this.conv2DConfig = conv2DConfig;
        this.addArgs();
    }

    public Col2Im() {
    }

    protected void addArgs() {
        this.addIArgument(this.conv2DConfig.getSy());
        this.addIArgument(this.conv2DConfig.getSx());
        this.addIArgument(this.conv2DConfig.getPh());
        this.addIArgument(this.conv2DConfig.getPw());
        this.addIArgument(this.conv2DConfig.getKh());
        this.addIArgument(this.conv2DConfig.getKw());
        this.addIArgument(this.conv2DConfig.getDh());
        this.addIArgument(this.conv2DConfig.getDw());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.conv2DConfig.isSameMode()));
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.conv2DConfig.toProperties();
    }

    @Override
    public String opName() {
        return "col2im";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Unable to run derivative op on col2im");
    }

    public static Col2ImBuilder builder() {
        return new Col2ImBuilder();
    }

    public Conv2DConfig getConv2DConfig() {
        return this.conv2DConfig;
    }

    public static class Col2ImBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private Conv2DConfig conv2DConfig;

        Col2ImBuilder() {
        }

        public Col2ImBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Col2ImBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Col2ImBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public Col2ImBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Col2ImBuilder conv2DConfig(Conv2DConfig conv2DConfig) {
            this.conv2DConfig = conv2DConfig;
            return this;
        }

        public Col2Im build() {
            return new Col2Im(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputs, this.conv2DConfig);
        }

        public String toString() {
            return "Col2Im.Col2ImBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", conv2DConfig=" + this.conv2DConfig + ")";
        }
    }
}

