/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sum
extends BaseAccumulation {
    private static final Logger log = LoggerFactory.getLogger(Sum.class);

    public Sum(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public Sum(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public Sum() {
    }

    public Sum(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Sum(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Sum(INDArray x) {
        super(x);
    }

    public Sum(INDArray x, INDArray y) {
        super(x, y);
    }

    public Sum(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    @Override
    public int opNum() {
        return 1;
    }

    @Override
    public String opName() {
        return "sum";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        int origRank = Shape.rankFromShape(this.arg().getShape());
        SDVariable broadcastable = this.sameDiff.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, i_v1.get(0));
        SDVariable ret = this.sameDiff.onesLike(this.arg()).mul(broadcastable);
        return Arrays.asList(ret);
    }

    @Override
    public String onnxName() {
        return "Sum";
    }

    @Override
    public String tensorflowName() {
        return "Sum";
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE;
    }
}

