/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.Shape;

public class Prod
extends BaseAccumulation {
    public Prod(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public Prod(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public Prod() {
    }

    public Prod(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Prod(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Prod(INDArray x) {
        super(x);
    }

    public Prod(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public int opNum() {
        return 8;
    }

    @Override
    public String opName() {
        return "prod";
    }

    @Override
    public double zeroDouble() {
        return 1.0;
    }

    @Override
    public float zeroFloat() {
        return 1.0f;
    }

    @Override
    public float zeroHalf() {
        return this.zeroFloat();
    }

    @Override
    public String onnxName() {
        return "ReduceProd";
    }

    @Override
    public String tensorflowName() {
        return "Prod";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        SDVariable prod = this.outputVariables()[0];
        int origRank = Shape.rankFromShape(this.arg().getShape());
        SDVariable broadcastableGrad = this.sameDiff.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, i_v1.get(0));
        SDVariable broadcastableProd = this.sameDiff.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, prod);
        SDVariable mul = broadcastableGrad.div(this.arg());
        SDVariable ret = broadcastableProd.mul(mul);
        return Arrays.asList(ret);
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE;
    }
}

