/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.Shape;

public class Min
extends BaseAccumulation {
    public Min(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public Min(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public Min() {
    }

    public Min(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Min(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Min(INDArray x) {
        super(x);
    }

    public Min(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public int opNum() {
        return 4;
    }

    @Override
    public String opName() {
        return "min";
    }

    @Override
    public double zeroDouble() {
        return Double.MAX_VALUE;
    }

    @Override
    public float zeroFloat() {
        return Float.MAX_VALUE;
    }

    @Override
    public float zeroHalf() {
        return 65503.0f;
    }

    @Override
    public String onnxName() {
        return "ReduceMin";
    }

    @Override
    public String tensorflowName() {
        return "ReduceMin";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        SDVariable out = this.outputVariables()[0];
        int origRank = Shape.rankFromShape(this.arg().getShape());
        SDVariable expandedOut = this.sameDiff.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, out);
        expandedOut = this.sameDiff.onesLike("temp0", this.arg()).mul("tempmul", expandedOut);
        SDVariable expandedGrad = this.sameDiff.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, i_v1.get(0));
        SDVariable eq = this.sameDiff.eq(this.arg(), expandedOut);
        SDVariable ret = eq.mul(expandedGrad);
        return Arrays.asList(ret);
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE;
    }
}

