/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape;

import java.util.Arrays;

public class ShapeDescriptor {
    private char order;
    private long offset;
    private int ews;
    private long hashShape = 0L;
    private long hashStride = 0L;
    private int[] shape;
    private int[] stride;
    private long extras;

    public ShapeDescriptor(int[] shape, int[] stride, long offset, int ews, char order, long extras) {
        this.shape = Arrays.copyOf(shape, shape.length);
        this.stride = Arrays.copyOf(stride, stride.length);
        this.offset = offset;
        this.ews = ews;
        this.order = order;
        this.extras = extras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeDescriptor that = (ShapeDescriptor)o;
        if (this.extras != that.extras) {
            return false;
        }
        if (this.order != that.order) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.ews != that.ews) {
            return false;
        }
        if (!Arrays.equals(this.shape, that.shape)) {
            return false;
        }
        return Arrays.equals(this.stride, that.stride);
    }

    public int hashCode() {
        int result = this.order;
        result = 31 * result + this.longHashCode(this.offset);
        result = 31 * result + this.longHashCode(this.extras);
        result = 31 * result + this.ews;
        result = 31 * result + Arrays.hashCode(this.shape);
        result = 31 * result + Arrays.hashCode(this.stride);
        return result;
    }

    private int longHashCode(long v) {
        return (int)(v ^ v >>> 32);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.shape.length).append(",").append(Arrays.toString(this.shape)).append(",").append(Arrays.toString(this.stride)).append(",").append(this.offset).append(",").append(this.ews).append(",").append(this.order);
        String result = builder.toString().replaceAll("\\]", "").replaceAll("\\[", "");
        result = "[" + result + "]";
        return result;
    }

    public char getOrder() {
        return this.order;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getEws() {
        return this.ews;
    }

    public int[] getShape() {
        return this.shape;
    }

    public int[] getStride() {
        return this.stride;
    }

    public long getExtras() {
        return this.extras;
    }
}

