/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.common.util.ArrayUtil;

public class LSTMCellConfiguration {
    private boolean peepHole;
    private boolean projection;
    private double clippingCellValue;
    private double clippingProjValue;
    private double forgetBias;
    private SDVariable xt;
    private SDVariable ht_1;
    private SDVariable ct_1;
    private SDVariable Wx;
    private SDVariable Wh;
    private SDVariable Wc;
    private SDVariable Wp;
    private SDVariable b;

    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("peepHole", this.peepHole);
        ret.put("projection", this.projection);
        ret.put("clippingCellValue", this.clippingCellValue);
        ret.put("clippingProjValue", this.clippingProjValue);
        ret.put("forgetBias", this.forgetBias);
        return ret;
    }

    public SDVariable[] args() {
        return new SDVariable[]{this.xt, this.ht_1, this.ct_1, this.Wx, this.Wh, this.Wc, this.Wp, this.b};
    }

    public int[] iArgs() {
        return new int[]{ArrayUtil.fromBoolean((boolean)this.peepHole), ArrayUtil.fromBoolean((boolean)this.projection)};
    }

    public double[] tArgs() {
        return new double[]{this.clippingCellValue, this.clippingProjValue, this.forgetBias};
    }

    LSTMCellConfiguration(boolean peepHole, boolean projection, double clippingCellValue, double clippingProjValue, double forgetBias, SDVariable xt, SDVariable ht_1, SDVariable ct_1, SDVariable Wx, SDVariable Wh, SDVariable Wc, SDVariable Wp, SDVariable b) {
        this.peepHole = peepHole;
        this.projection = projection;
        this.clippingCellValue = clippingCellValue;
        this.clippingProjValue = clippingProjValue;
        this.forgetBias = forgetBias;
        this.xt = xt;
        this.ht_1 = ht_1;
        this.ct_1 = ct_1;
        this.Wx = Wx;
        this.Wh = Wh;
        this.Wc = Wc;
        this.Wp = Wp;
        this.b = b;
    }

    public static LSTMCellConfigurationBuilder builder() {
        return new LSTMCellConfigurationBuilder();
    }

    public boolean isPeepHole() {
        return this.peepHole;
    }

    public boolean isProjection() {
        return this.projection;
    }

    public double getClippingCellValue() {
        return this.clippingCellValue;
    }

    public double getClippingProjValue() {
        return this.clippingProjValue;
    }

    public double getForgetBias() {
        return this.forgetBias;
    }

    public SDVariable getXt() {
        return this.xt;
    }

    public SDVariable getHt_1() {
        return this.ht_1;
    }

    public SDVariable getCt_1() {
        return this.ct_1;
    }

    public SDVariable getWx() {
        return this.Wx;
    }

    public SDVariable getWh() {
        return this.Wh;
    }

    public SDVariable getWc() {
        return this.Wc;
    }

    public SDVariable getWp() {
        return this.Wp;
    }

    public SDVariable getB() {
        return this.b;
    }

    public void setPeepHole(boolean peepHole) {
        this.peepHole = peepHole;
    }

    public void setProjection(boolean projection) {
        this.projection = projection;
    }

    public void setClippingCellValue(double clippingCellValue) {
        this.clippingCellValue = clippingCellValue;
    }

    public void setClippingProjValue(double clippingProjValue) {
        this.clippingProjValue = clippingProjValue;
    }

    public void setForgetBias(double forgetBias) {
        this.forgetBias = forgetBias;
    }

    public void setXt(SDVariable xt) {
        this.xt = xt;
    }

    public void setHt_1(SDVariable ht_1) {
        this.ht_1 = ht_1;
    }

    public void setCt_1(SDVariable ct_1) {
        this.ct_1 = ct_1;
    }

    public void setWx(SDVariable Wx) {
        this.Wx = Wx;
    }

    public void setWh(SDVariable Wh) {
        this.Wh = Wh;
    }

    public void setWc(SDVariable Wc) {
        this.Wc = Wc;
    }

    public void setWp(SDVariable Wp) {
        this.Wp = Wp;
    }

    public void setB(SDVariable b) {
        this.b = b;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LSTMCellConfiguration)) {
            return false;
        }
        LSTMCellConfiguration other = (LSTMCellConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPeepHole() != other.isPeepHole()) {
            return false;
        }
        if (this.isProjection() != other.isProjection()) {
            return false;
        }
        if (Double.compare(this.getClippingCellValue(), other.getClippingCellValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getClippingProjValue(), other.getClippingProjValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getForgetBias(), other.getForgetBias()) != 0) {
            return false;
        }
        SDVariable this$xt = this.getXt();
        SDVariable other$xt = other.getXt();
        if (this$xt == null ? other$xt != null : !((Object)this$xt).equals(other$xt)) {
            return false;
        }
        SDVariable this$ht_1 = this.getHt_1();
        SDVariable other$ht_1 = other.getHt_1();
        if (this$ht_1 == null ? other$ht_1 != null : !((Object)this$ht_1).equals(other$ht_1)) {
            return false;
        }
        SDVariable this$ct_1 = this.getCt_1();
        SDVariable other$ct_1 = other.getCt_1();
        if (this$ct_1 == null ? other$ct_1 != null : !((Object)this$ct_1).equals(other$ct_1)) {
            return false;
        }
        SDVariable this$Wx = this.getWx();
        SDVariable other$Wx = other.getWx();
        if (this$Wx == null ? other$Wx != null : !((Object)this$Wx).equals(other$Wx)) {
            return false;
        }
        SDVariable this$Wh = this.getWh();
        SDVariable other$Wh = other.getWh();
        if (this$Wh == null ? other$Wh != null : !((Object)this$Wh).equals(other$Wh)) {
            return false;
        }
        SDVariable this$Wc = this.getWc();
        SDVariable other$Wc = other.getWc();
        if (this$Wc == null ? other$Wc != null : !((Object)this$Wc).equals(other$Wc)) {
            return false;
        }
        SDVariable this$Wp = this.getWp();
        SDVariable other$Wp = other.getWp();
        if (this$Wp == null ? other$Wp != null : !((Object)this$Wp).equals(other$Wp)) {
            return false;
        }
        SDVariable this$b = this.getB();
        SDVariable other$b = other.getB();
        return !(this$b == null ? other$b != null : !((Object)this$b).equals(other$b));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LSTMCellConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPeepHole() ? 79 : 97);
        result = result * 59 + (this.isProjection() ? 79 : 97);
        long $clippingCellValue = Double.doubleToLongBits(this.getClippingCellValue());
        result = result * 59 + (int)($clippingCellValue >>> 32 ^ $clippingCellValue);
        long $clippingProjValue = Double.doubleToLongBits(this.getClippingProjValue());
        result = result * 59 + (int)($clippingProjValue >>> 32 ^ $clippingProjValue);
        long $forgetBias = Double.doubleToLongBits(this.getForgetBias());
        result = result * 59 + (int)($forgetBias >>> 32 ^ $forgetBias);
        SDVariable $xt = this.getXt();
        result = result * 59 + ($xt == null ? 43 : ((Object)$xt).hashCode());
        SDVariable $ht_1 = this.getHt_1();
        result = result * 59 + ($ht_1 == null ? 43 : ((Object)$ht_1).hashCode());
        SDVariable $ct_1 = this.getCt_1();
        result = result * 59 + ($ct_1 == null ? 43 : ((Object)$ct_1).hashCode());
        SDVariable $Wx = this.getWx();
        result = result * 59 + ($Wx == null ? 43 : ((Object)$Wx).hashCode());
        SDVariable $Wh = this.getWh();
        result = result * 59 + ($Wh == null ? 43 : ((Object)$Wh).hashCode());
        SDVariable $Wc = this.getWc();
        result = result * 59 + ($Wc == null ? 43 : ((Object)$Wc).hashCode());
        SDVariable $Wp = this.getWp();
        result = result * 59 + ($Wp == null ? 43 : ((Object)$Wp).hashCode());
        SDVariable $b = this.getB();
        result = result * 59 + ($b == null ? 43 : ((Object)$b).hashCode());
        return result;
    }

    public String toString() {
        return "LSTMCellConfiguration(peepHole=" + this.isPeepHole() + ", projection=" + this.isProjection() + ", clippingCellValue=" + this.getClippingCellValue() + ", clippingProjValue=" + this.getClippingProjValue() + ", forgetBias=" + this.getForgetBias() + ", xt=" + this.getXt() + ", ht_1=" + this.getHt_1() + ", ct_1=" + this.getCt_1() + ", Wx=" + this.getWx() + ", Wh=" + this.getWh() + ", Wc=" + this.getWc() + ", Wp=" + this.getWp() + ", b=" + this.getB() + ")";
    }

    public static class LSTMCellConfigurationBuilder {
        private boolean peepHole;
        private boolean projection;
        private double clippingCellValue;
        private double clippingProjValue;
        private double forgetBias;
        private SDVariable xt;
        private SDVariable ht_1;
        private SDVariable ct_1;
        private SDVariable Wx;
        private SDVariable Wh;
        private SDVariable Wc;
        private SDVariable Wp;
        private SDVariable b;

        LSTMCellConfigurationBuilder() {
        }

        public LSTMCellConfigurationBuilder peepHole(boolean peepHole) {
            this.peepHole = peepHole;
            return this;
        }

        public LSTMCellConfigurationBuilder projection(boolean projection) {
            this.projection = projection;
            return this;
        }

        public LSTMCellConfigurationBuilder clippingCellValue(double clippingCellValue) {
            this.clippingCellValue = clippingCellValue;
            return this;
        }

        public LSTMCellConfigurationBuilder clippingProjValue(double clippingProjValue) {
            this.clippingProjValue = clippingProjValue;
            return this;
        }

        public LSTMCellConfigurationBuilder forgetBias(double forgetBias) {
            this.forgetBias = forgetBias;
            return this;
        }

        public LSTMCellConfigurationBuilder xt(SDVariable xt) {
            this.xt = xt;
            return this;
        }

        public LSTMCellConfigurationBuilder ht_1(SDVariable ht_1) {
            this.ht_1 = ht_1;
            return this;
        }

        public LSTMCellConfigurationBuilder ct_1(SDVariable ct_1) {
            this.ct_1 = ct_1;
            return this;
        }

        public LSTMCellConfigurationBuilder Wx(SDVariable Wx) {
            this.Wx = Wx;
            return this;
        }

        public LSTMCellConfigurationBuilder Wh(SDVariable Wh) {
            this.Wh = Wh;
            return this;
        }

        public LSTMCellConfigurationBuilder Wc(SDVariable Wc) {
            this.Wc = Wc;
            return this;
        }

        public LSTMCellConfigurationBuilder Wp(SDVariable Wp) {
            this.Wp = Wp;
            return this;
        }

        public LSTMCellConfigurationBuilder b(SDVariable b) {
            this.b = b;
            return this;
        }

        public LSTMCellConfiguration build() {
            return new LSTMCellConfiguration(this.peepHole, this.projection, this.clippingCellValue, this.clippingProjValue, this.forgetBias, this.xt, this.ht_1, this.ct_1, this.Wx, this.Wh, this.Wc, this.Wp, this.b);
        }

        public String toString() {
            return "LSTMCellConfiguration.LSTMCellConfigurationBuilder(peepHole=" + this.peepHole + ", projection=" + this.projection + ", clippingCellValue=" + this.clippingCellValue + ", clippingProjValue=" + this.clippingProjValue + ", forgetBias=" + this.forgetBias + ", xt=" + this.xt + ", ht_1=" + this.ht_1 + ", ct_1=" + this.ct_1 + ", Wx=" + this.Wx + ", Wh=" + this.Wh + ", Wc=" + this.Wc + ", Wp=" + this.Wp + ", b=" + this.b + ")";
        }
    }
}

