/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.GRUBp;

public class GRU
extends DynamicCustomOp {
    public GRU(@NonNull SameDiff sameDiff, @NonNull SDVariable x, @NonNull SDVariable hI, @NonNull SDVariable Wx, @NonNull SDVariable Wh, @NonNull SDVariable biases) {
        super(null, sameDiff, new SDVariable[]{x, hI, Wx, Wh, biases});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (hI == null) {
            throw new NullPointerException("hI is marked non-null but is null");
        }
        if (Wx == null) {
            throw new NullPointerException("Wx is marked non-null but is null");
        }
        if (Wh == null) {
            throw new NullPointerException("Wh is marked non-null but is null");
        }
        if (biases == null) {
            throw new NullPointerException("biases is marked non-null but is null");
        }
    }

    public GRU(@NonNull INDArray x, @NonNull INDArray hI, @NonNull INDArray Wx, @NonNull INDArray Wh, @NonNull INDArray biases) {
        super(new INDArray[]{x, hI, Wx, Wh, biases}, null);
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (hI == null) {
            throw new NullPointerException("hI is marked non-null but is null");
        }
        if (Wx == null) {
            throw new NullPointerException("Wx is marked non-null but is null");
        }
        if (Wh == null) {
            throw new NullPointerException("Wh is marked non-null but is null");
        }
        if (biases == null) {
            throw new NullPointerException("biases is marked non-null but is null");
        }
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 5 ? 1 : 0) != 0, (String)"Expected 5 inputs to GRU: initial cell output, input-to-hidden weights, hidden-to-hidden weights and biases got %s", inputDataTypes);
        DataType dt = inputDataTypes.get(1);
        for (int i = 0; i < inputDataTypes.size(); ++i) {
            Preconditions.checkState((boolean)inputDataTypes.get(i).isFPType(), (String)"All input types must be a floating point type, got %s", (Object)((Object)dt));
        }
        Preconditions.checkState((boolean)dt.isFPType(), (String)"Input type 1 must be a floating point type, got %s", (Object)((Object)dt));
        return Collections.singletonList(dt);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grads) {
        return Arrays.asList(new GRUBp(this.sameDiff, this.arg(0), this.arg(1), this.arg(2), this.arg(3), this.arg(4), grads.get(0)).outputVariables());
    }

    @Override
    public String opName() {
        return "gru";
    }

    public GRU() {
    }
}

