/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.ExecutionMode;
import org.nd4j.linalg.api.ops.OpContext;

public abstract class BaseOpContext
implements OpContext {
    protected Map<Integer, INDArray> fastpath_in = new HashMap<Integer, INDArray>();
    protected Map<Integer, INDArray> fastpath_out = new HashMap<Integer, INDArray>();
    protected List<Double> fastpath_t = new ArrayList<Double>();
    protected List<Boolean> fastpath_b = new ArrayList<Boolean>();
    protected List<Long> fastpath_i = new ArrayList<Long>();
    protected List<DataType> fastpath_d = new ArrayList<DataType>();
    protected ExecutionMode executionMode = ExecutionMode.UNDEFINED;

    @Override
    public void setIArguments(long ... arguments) {
        this.fastpath_i.clear();
        for (long v : arguments) {
            this.fastpath_i.add(v);
        }
    }

    @Override
    public List<Long> getIArguments() {
        return this.fastpath_i;
    }

    @Override
    public int numIArguments() {
        return this.fastpath_i.size();
    }

    @Override
    public void setTArguments(double ... arguments) {
        this.fastpath_t.clear();
        for (double v : arguments) {
            this.fastpath_t.add(v);
        }
    }

    @Override
    public List<Double> getTArguments() {
        return this.fastpath_t;
    }

    @Override
    public int numTArguments() {
        return this.fastpath_t.size();
    }

    @Override
    public void setBArguments(boolean ... arguments) {
        this.fastpath_b.clear();
        for (boolean v : arguments) {
            this.fastpath_b.add(v);
        }
    }

    @Override
    public List<Boolean> getBArguments() {
        return this.fastpath_b;
    }

    @Override
    public int numBArguments() {
        return this.fastpath_b.size();
    }

    @Override
    public void setDArguments(DataType ... arguments) {
        this.fastpath_d.clear();
        for (DataType v : arguments) {
            this.fastpath_d.add(v);
        }
    }

    @Override
    public List<DataType> getDArguments() {
        return this.fastpath_d;
    }

    @Override
    public int numDArguments() {
        return this.fastpath_d.size();
    }

    @Override
    public void setInputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.fastpath_in.put(index, array);
    }

    @Override
    public List<INDArray> getInputArrays() {
        INDArray arr;
        ArrayList<INDArray> result = new ArrayList<INDArray>();
        for (int e = 0; e < Integer.MAX_VALUE && (arr = this.fastpath_in.get(e)) != null; ++e) {
            result.add(arr);
        }
        return result;
    }

    @Override
    public int numInputArguments() {
        return this.fastpath_in.size();
    }

    @Override
    public INDArray getInputArray(int idx) {
        return this.fastpath_in.get(idx);
    }

    @Override
    public List<INDArray> getOutputArrays() {
        INDArray arr;
        ArrayList<INDArray> result = new ArrayList<INDArray>();
        for (int e = 0; e < Integer.MAX_VALUE && (arr = this.fastpath_out.get(e)) != null; ++e) {
            result.add(arr);
        }
        return result;
    }

    @Override
    public void setOutputArray(int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.fastpath_out.put(index, array);
    }

    @Override
    public INDArray getOutputArray(int i) {
        return this.fastpath_out.get(i);
    }

    @Override
    public int numOutputArguments() {
        return this.fastpath_out.size();
    }

    @Override
    public void setInputArrays(@NonNull List<INDArray> arrays) {
        if (arrays == null) {
            throw new NullPointerException("arrays is marked non-null but is null");
        }
        for (int e = 0; e < arrays.size(); ++e) {
            this.setInputArray(e, arrays.get(e));
        }
    }

    @Override
    public void setOutputArrays(@NonNull List<INDArray> arrays) {
        if (arrays == null) {
            throw new NullPointerException("arrays is marked non-null but is null");
        }
        for (int e = 0; e < arrays.size(); ++e) {
            this.setOutputArray(e, arrays.get(e));
        }
    }

    @Override
    public void setInputArrays(INDArray ... arrays) {
        for (int e = 0; e < arrays.length; ++e) {
            this.setInputArray(e, arrays[e]);
        }
    }

    @Override
    public void setOutputArrays(INDArray ... arrays) {
        for (int e = 0; e < arrays.length; ++e) {
            this.setOutputArray(e, arrays[e]);
        }
    }

    @Override
    public void purge() {
        this.fastpath_in.clear();
        this.fastpath_out.clear();
    }

    @Override
    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @Override
    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }
}

