/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.optimize.optimizations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.nd4j.autodiff.samediff.optimize.Optimizer;
import org.nd4j.autodiff.samediff.optimize.OptimizerSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOptimizerSet
implements OptimizerSet {
    private static final Logger log = LoggerFactory.getLogger(BaseOptimizerSet.class);

    @Override
    public List<Optimizer> getOptimizers() {
        Class<?>[] declaredClasses;
        Method[] methods = this.getClass().getDeclaredMethods();
        ArrayList<Optimizer> out = new ArrayList<Optimizer>(methods.length);
        for (Method m : methods) {
            int modifiers = m.getModifiers();
            Class<?> retType = m.getReturnType();
            if (retType == null || !Modifier.isPublic(modifiers) || !Optimizer.class.isAssignableFrom(retType)) continue;
            try {
                Optimizer o = (Optimizer)m.invoke(null, new Object[0]);
                out.add(o);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.warn("Could not create optimizer from method: {}", (Object)m, (Object)e);
            }
        }
        for (Class<?> c : declaredClasses = this.getClass().getDeclaredClasses()) {
            int modifiers = c.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || !Optimizer.class.isAssignableFrom(c)) continue;
            try {
                out.add((Optimizer)c.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn("Could not create optimizer from inner class: {}", c, (Object)e);
            }
        }
        return out;
    }
}

