/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.BaseConvolutionConfig;
import org.nd4j.linalg.util.ConvConfigUtil;

public class DeConv3DConfig
extends BaseConvolutionConfig {
    public static final String NCDHW = "NCDHW";
    public static final String NDHWC = "NDHWC";
    private long kD;
    private long kH;
    private long kW;
    private long sD;
    private long sH;
    private long sW;
    private long pD;
    private long pH;
    private long pW;
    private long dD;
    private long dH;
    private long dW;
    private boolean isSameMode;
    private String dataFormat;

    public DeConv3DConfig(long kD, long kH, long kW, long sD, long sH, long sW, long pD, long pH, long pW, long dD, long dH, long dW, boolean isSameMode, String dataFormat) {
        this.kD = kD;
        this.kH = kH;
        this.kW = kW;
        this.sD = sD;
        this.sH = sH;
        this.sW = sW;
        this.pD = pD;
        this.pH = pH;
        this.pW = pW;
        this.dD = dD;
        this.dH = dH;
        this.dW = dW;
        this.isSameMode = isSameMode;
        this.dataFormat = dataFormat;
        this.validate();
    }

    @Override
    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("kD", this.kD);
        ret.put("kH", this.kH);
        ret.put("kW", this.kW);
        ret.put("sD", this.sD);
        ret.put("sH", this.sH);
        ret.put("sW", this.sW);
        ret.put("pD", this.pD);
        ret.put("pH", this.pH);
        ret.put("pW", this.pW);
        ret.put("dD", this.dD);
        ret.put("dH", this.dH);
        ret.put("dW", this.dW);
        ret.put("isSameMode", this.isSameMode);
        ret.put("dataFormat", this.dataFormat);
        return ret;
    }

    @Override
    protected void validate() {
        ConvConfigUtil.validate3D(this.kH, this.kW, this.kD, this.sH, this.sW, this.sD, this.pH, this.pW, this.pD, this.dH, this.dW, this.dD);
        Preconditions.checkArgument((this.dataFormat != null ? 1 : 0) != 0, (String)"Data format can't be null");
    }

    private static long $default$kD() {
        return -1L;
    }

    private static long $default$kH() {
        return -1L;
    }

    private static long $default$kW() {
        return -1L;
    }

    private static long $default$sD() {
        return 1L;
    }

    private static long $default$sH() {
        return 1L;
    }

    private static long $default$sW() {
        return 1L;
    }

    private static long $default$pD() {
        return 0L;
    }

    private static long $default$pH() {
        return 0L;
    }

    private static long $default$pW() {
        return 0L;
    }

    private static long $default$dD() {
        return 1L;
    }

    private static long $default$dH() {
        return 1L;
    }

    private static long $default$dW() {
        return 1L;
    }

    private static boolean $default$isSameMode() {
        return false;
    }

    private static String $default$dataFormat() {
        return NCDHW;
    }

    public static DeConv3DConfigBuilder builder() {
        return new DeConv3DConfigBuilder();
    }

    public long getKD() {
        return this.kD;
    }

    public long getKH() {
        return this.kH;
    }

    public long getKW() {
        return this.kW;
    }

    public long getSD() {
        return this.sD;
    }

    public long getSH() {
        return this.sH;
    }

    public long getSW() {
        return this.sW;
    }

    public long getPD() {
        return this.pD;
    }

    public long getPH() {
        return this.pH;
    }

    public long getPW() {
        return this.pW;
    }

    public long getDD() {
        return this.dD;
    }

    public long getDH() {
        return this.dH;
    }

    public long getDW() {
        return this.dW;
    }

    public boolean isSameMode() {
        return this.isSameMode;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setKD(long kD) {
        this.kD = kD;
    }

    public void setKH(long kH) {
        this.kH = kH;
    }

    public void setKW(long kW) {
        this.kW = kW;
    }

    public void setSD(long sD) {
        this.sD = sD;
    }

    public void setSH(long sH) {
        this.sH = sH;
    }

    public void setSW(long sW) {
        this.sW = sW;
    }

    public void setPD(long pD) {
        this.pD = pD;
    }

    public void setPH(long pH) {
        this.pH = pH;
    }

    public void setPW(long pW) {
        this.pW = pW;
    }

    public void setDD(long dD) {
        this.dD = dD;
    }

    public void setDH(long dH) {
        this.dH = dH;
    }

    public void setDW(long dW) {
        this.dW = dW;
    }

    public void setSameMode(boolean isSameMode) {
        this.isSameMode = isSameMode;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeConv3DConfig)) {
            return false;
        }
        DeConv3DConfig other = (DeConv3DConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKD() != other.getKD()) {
            return false;
        }
        if (this.getKH() != other.getKH()) {
            return false;
        }
        if (this.getKW() != other.getKW()) {
            return false;
        }
        if (this.getSD() != other.getSD()) {
            return false;
        }
        if (this.getSH() != other.getSH()) {
            return false;
        }
        if (this.getSW() != other.getSW()) {
            return false;
        }
        if (this.getPD() != other.getPD()) {
            return false;
        }
        if (this.getPH() != other.getPH()) {
            return false;
        }
        if (this.getPW() != other.getPW()) {
            return false;
        }
        if (this.getDD() != other.getDD()) {
            return false;
        }
        if (this.getDH() != other.getDH()) {
            return false;
        }
        if (this.getDW() != other.getDW()) {
            return false;
        }
        if (this.isSameMode() != other.isSameMode()) {
            return false;
        }
        String this$dataFormat = this.getDataFormat();
        String other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeConv3DConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $kD = this.getKD();
        result = result * 59 + (int)($kD >>> 32 ^ $kD);
        long $kH = this.getKH();
        result = result * 59 + (int)($kH >>> 32 ^ $kH);
        long $kW = this.getKW();
        result = result * 59 + (int)($kW >>> 32 ^ $kW);
        long $sD = this.getSD();
        result = result * 59 + (int)($sD >>> 32 ^ $sD);
        long $sH = this.getSH();
        result = result * 59 + (int)($sH >>> 32 ^ $sH);
        long $sW = this.getSW();
        result = result * 59 + (int)($sW >>> 32 ^ $sW);
        long $pD = this.getPD();
        result = result * 59 + (int)($pD >>> 32 ^ $pD);
        long $pH = this.getPH();
        result = result * 59 + (int)($pH >>> 32 ^ $pH);
        long $pW = this.getPW();
        result = result * 59 + (int)($pW >>> 32 ^ $pW);
        long $dD = this.getDD();
        result = result * 59 + (int)($dD >>> 32 ^ $dD);
        long $dH = this.getDH();
        result = result * 59 + (int)($dH >>> 32 ^ $dH);
        long $dW = this.getDW();
        result = result * 59 + (int)($dW >>> 32 ^ $dW);
        result = result * 59 + (this.isSameMode() ? 79 : 97);
        String $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    public String toString() {
        return "DeConv3DConfig(kD=" + this.getKD() + ", kH=" + this.getKH() + ", kW=" + this.getKW() + ", sD=" + this.getSD() + ", sH=" + this.getSH() + ", sW=" + this.getSW() + ", pD=" + this.getPD() + ", pH=" + this.getPH() + ", pW=" + this.getPW() + ", dD=" + this.getDD() + ", dH=" + this.getDH() + ", dW=" + this.getDW() + ", isSameMode=" + this.isSameMode() + ", dataFormat=" + this.getDataFormat() + ")";
    }

    public DeConv3DConfig() {
        this.kD = DeConv3DConfig.$default$kD();
        this.kH = DeConv3DConfig.$default$kH();
        this.kW = DeConv3DConfig.$default$kW();
        this.sD = DeConv3DConfig.$default$sD();
        this.sH = DeConv3DConfig.$default$sH();
        this.sW = DeConv3DConfig.$default$sW();
        this.pD = DeConv3DConfig.$default$pD();
        this.pH = DeConv3DConfig.$default$pH();
        this.pW = DeConv3DConfig.$default$pW();
        this.dD = DeConv3DConfig.$default$dD();
        this.dH = DeConv3DConfig.$default$dH();
        this.dW = DeConv3DConfig.$default$dW();
        this.isSameMode = DeConv3DConfig.$default$isSameMode();
        this.dataFormat = DeConv3DConfig.$default$dataFormat();
    }

    public static class DeConv3DConfigBuilder {
        private boolean kD$set;
        private long kD$value;
        private boolean kH$set;
        private long kH$value;
        private boolean kW$set;
        private long kW$value;
        private boolean sD$set;
        private long sD$value;
        private boolean sH$set;
        private long sH$value;
        private boolean sW$set;
        private long sW$value;
        private boolean pD$set;
        private long pD$value;
        private boolean pH$set;
        private long pH$value;
        private boolean pW$set;
        private long pW$value;
        private boolean dD$set;
        private long dD$value;
        private boolean dH$set;
        private long dH$value;
        private boolean dW$set;
        private long dW$value;
        private boolean isSameMode$set;
        private boolean isSameMode$value;
        private boolean dataFormat$set;
        private String dataFormat$value;

        DeConv3DConfigBuilder() {
        }

        public DeConv3DConfigBuilder kD(long kD) {
            this.kD$value = kD;
            this.kD$set = true;
            return this;
        }

        public DeConv3DConfigBuilder kH(long kH) {
            this.kH$value = kH;
            this.kH$set = true;
            return this;
        }

        public DeConv3DConfigBuilder kW(long kW) {
            this.kW$value = kW;
            this.kW$set = true;
            return this;
        }

        public DeConv3DConfigBuilder sD(long sD) {
            this.sD$value = sD;
            this.sD$set = true;
            return this;
        }

        public DeConv3DConfigBuilder sH(long sH) {
            this.sH$value = sH;
            this.sH$set = true;
            return this;
        }

        public DeConv3DConfigBuilder sW(long sW) {
            this.sW$value = sW;
            this.sW$set = true;
            return this;
        }

        public DeConv3DConfigBuilder pD(long pD) {
            this.pD$value = pD;
            this.pD$set = true;
            return this;
        }

        public DeConv3DConfigBuilder pH(long pH) {
            this.pH$value = pH;
            this.pH$set = true;
            return this;
        }

        public DeConv3DConfigBuilder pW(long pW) {
            this.pW$value = pW;
            this.pW$set = true;
            return this;
        }

        public DeConv3DConfigBuilder dD(long dD) {
            this.dD$value = dD;
            this.dD$set = true;
            return this;
        }

        public DeConv3DConfigBuilder dH(long dH) {
            this.dH$value = dH;
            this.dH$set = true;
            return this;
        }

        public DeConv3DConfigBuilder dW(long dW) {
            this.dW$value = dW;
            this.dW$set = true;
            return this;
        }

        public DeConv3DConfigBuilder isSameMode(boolean isSameMode) {
            this.isSameMode$value = isSameMode;
            this.isSameMode$set = true;
            return this;
        }

        public DeConv3DConfigBuilder dataFormat(String dataFormat) {
            this.dataFormat$value = dataFormat;
            this.dataFormat$set = true;
            return this;
        }

        public DeConv3DConfig build() {
            long kD$value = this.kD$value;
            if (!this.kD$set) {
                kD$value = DeConv3DConfig.$default$kD();
            }
            long kH$value = this.kH$value;
            if (!this.kH$set) {
                kH$value = DeConv3DConfig.$default$kH();
            }
            long kW$value = this.kW$value;
            if (!this.kW$set) {
                kW$value = DeConv3DConfig.$default$kW();
            }
            long sD$value = this.sD$value;
            if (!this.sD$set) {
                sD$value = DeConv3DConfig.$default$sD();
            }
            long sH$value = this.sH$value;
            if (!this.sH$set) {
                sH$value = DeConv3DConfig.$default$sH();
            }
            long sW$value = this.sW$value;
            if (!this.sW$set) {
                sW$value = DeConv3DConfig.$default$sW();
            }
            long pD$value = this.pD$value;
            if (!this.pD$set) {
                pD$value = DeConv3DConfig.$default$pD();
            }
            long pH$value = this.pH$value;
            if (!this.pH$set) {
                pH$value = DeConv3DConfig.$default$pH();
            }
            long pW$value = this.pW$value;
            if (!this.pW$set) {
                pW$value = DeConv3DConfig.$default$pW();
            }
            long dD$value = this.dD$value;
            if (!this.dD$set) {
                dD$value = DeConv3DConfig.$default$dD();
            }
            long dH$value = this.dH$value;
            if (!this.dH$set) {
                dH$value = DeConv3DConfig.$default$dH();
            }
            long dW$value = this.dW$value;
            if (!this.dW$set) {
                dW$value = DeConv3DConfig.$default$dW();
            }
            boolean isSameMode$value = this.isSameMode$value;
            if (!this.isSameMode$set) {
                isSameMode$value = DeConv3DConfig.$default$isSameMode();
            }
            String dataFormat$value = this.dataFormat$value;
            if (!this.dataFormat$set) {
                dataFormat$value = DeConv3DConfig.$default$dataFormat();
            }
            return new DeConv3DConfig(kD$value, kH$value, kW$value, sD$value, sH$value, sW$value, pD$value, pH$value, pW$value, dD$value, dH$value, dW$value, isSameMode$value, dataFormat$value);
        }

        public String toString() {
            return "DeConv3DConfig.DeConv3DConfigBuilder(kD$value=" + this.kD$value + ", kH$value=" + this.kH$value + ", kW$value=" + this.kW$value + ", sD$value=" + this.sD$value + ", sH$value=" + this.sH$value + ", sW$value=" + this.sW$value + ", pD$value=" + this.pD$value + ", pH$value=" + this.pH$value + ", pW$value=" + this.pW$value + ", dD$value=" + this.dD$value + ", dH$value=" + this.dH$value + ", dW$value=" + this.dW$value + ", isSameMode$value=" + this.isSameMode$value + ", dataFormat$value=" + this.dataFormat$value + ")";
        }
    }
}

