/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.image;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ResizeBicubic
extends DynamicCustomOp {
    protected boolean alignCorners = false;
    protected boolean alignPixelCenters = false;

    public ResizeBicubic(@NonNull INDArray image, INDArray size, boolean alignCorners, boolean alignPixelCenters) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.addInputArgument(image, size);
        this.addBArgument(alignCorners, alignPixelCenters);
    }

    public ResizeBicubic(@NonNull SameDiff sameDiff, @NonNull SDVariable image, SDVariable size, boolean alignCorners, boolean alignPixelCenters) {
        super(sameDiff, new SDVariable[]{image, size});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.addBArgument(alignCorners, alignPixelCenters);
    }

    @Override
    public String opName() {
        return "resize_bicubic";
    }

    @Override
    public String tensorflowName() {
        return "ResizeBicubic";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.alignCorners = attributesForNode.get("align_corners").getB();
        this.alignPixelCenters = attributesForNode.get("half_pixel_centers").getB();
        this.addBArgument(this.alignCorners, this.alignPixelCenters);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && (inputDataTypes.size() == 1 || inputDataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected 1 or 2 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(Nd4j.defaultFloatingPointType());
    }

    public ResizeBicubic() {
    }
}

