/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class DistributionInitScheme
extends BaseWeightInitScheme {
    private Distribution distribution;

    public DistributionInitScheme(char order, Distribution distribution) {
        super(order);
        this.distribution = distribution;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        return this.distribution.sample(shape);
    }

    @Override
    public WeightInit type() {
        return WeightInit.DISTRIBUTION;
    }

    public static DistributionInitSchemeBuilder builder() {
        return new DistributionInitSchemeBuilder();
    }

    public static class DistributionInitSchemeBuilder {
        private char order;
        private Distribution distribution;

        DistributionInitSchemeBuilder() {
        }

        public DistributionInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public DistributionInitSchemeBuilder distribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public DistributionInitScheme build() {
            return new DistributionInitScheme(this.order, this.distribution);
        }

        public String toString() {
            return "DistributionInitScheme.DistributionInitSchemeBuilder(order=" + this.order + ", distribution=" + this.distribution + ")";
        }
    }
}

