/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.shape.bp.TileBp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Tile
extends DynamicCustomOp {
    private int[] jaxis;
    private boolean is_static_reps = false;

    public Tile(SameDiff sameDiff, SDVariable i_v, int[] axis) {
        super(null, sameDiff, new SDVariable[]{i_v}, false);
        this.jaxis = axis;
        this.addArguments();
    }

    public Tile(SameDiff sameDiff, SDVariable i_v, SDVariable axis) {
        super(null, sameDiff, new SDVariable[]{i_v, axis}, false);
        this.jaxis = null;
    }

    public Tile(INDArray[] inputs, INDArray[] outputs, int[] axis, boolean is_static_reps) {
        super(null, inputs, outputs);
        this.jaxis = axis;
        this.is_static_reps = is_static_reps;
        this.addArguments();
    }

    public Tile(INDArray[] inputs, INDArray[] outputs, int[] axis) {
        this(inputs, outputs, axis, false);
    }

    public Tile(INDArray x, INDArray repeat) {
        super(null, new INDArray[]{x, repeat}, null);
        this.jaxis = null;
    }

    public Tile(INDArray inputs, int ... axis) {
        super(null, new INDArray[]{inputs}, null);
        this.jaxis = axis;
        this.is_static_reps = true;
        this.addArguments();
    }

    public Tile() {
    }

    private void addArguments() {
        this.is_static_reps = true;
        this.addIArgument(this.jaxis);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping axisMapping = PropertyMapping.builder().onnxAttrName("axis").tfInputPosition(-1).propertyNames(new String[]{"axis"}).build();
        map.put("axis", axisMapping);
        ret.put(this.tensorflowName(), map);
        ret.put(this.onnxName(), map);
        return ret;
    }

    @Override
    public String opName() {
        return "tile";
    }

    @Override
    public String onnxName() {
        return "Tile";
    }

    @Override
    public String tensorflowName() {
        return "Tile";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        if (this.jaxis != null) {
            return new TileBp(this.sameDiff, this.arg(), i_v.get(0), this.jaxis).outputs();
        }
        return new TileBp(this.sameDiff, this.arg(0), this.arg(1), i_v.get(0)).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 1 || this.jaxis == null && dataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected 1 or 2 input datatypes for %s, got %s", this.getClass(), dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

