/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.image;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.ImageResizeMethod;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class ImageResize
extends DynamicCustomOp {
    @Override
    public String opName() {
        return "image_resize";
    }

    public ImageResize(@NonNull SameDiff sameDiff, @NonNull SDVariable in, @NonNull SDVariable size, boolean preserveAspectRatio, boolean antialias, ImageResizeMethod method) {
        super("image_resize", sameDiff, new SDVariable[]{in, size});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        this.addBArgument(preserveAspectRatio, antialias);
        this.addIArgument(method.ordinal());
    }

    public ImageResize(@NonNull INDArray in, @NonNull INDArray size, boolean preserveAspectRatio, boolean antialias, ImageResizeMethod method) {
        super("image_resize", new INDArray[]{in, size}, null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        Preconditions.checkArgument((in.rank() == 4 ? 1 : 0) != 0, (String)"expected input message in NHWC format i.e [batchSize, height, width, channels]");
        this.addBArgument(preserveAspectRatio, antialias);
        this.addIArgument(method.ordinal());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkArgument((dataTypes != null && dataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected exactly 2 input datatypes, got %s", dataTypes);
        Preconditions.checkArgument((boolean)dataTypes.get(0).isFPType(), (String)"Input datatype must be floating point, got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }

    public ImageResize() {
    }
}

