/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions.impl;

import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.Sign;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossUtil;
import org.nd4j.linalg.lossfunctions.serde.RowVectorDeserializer;
import org.nd4j.linalg.lossfunctions.serde.RowVectorSerializer;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LossL1
implements ILossFunction {
    @JsonSerialize(using=RowVectorSerializer.class)
    @JsonDeserialize(using=RowVectorDeserializer.class)
    protected final INDArray weights;

    public LossL1() {
        this(null);
    }

    public LossL1(INDArray weights) {
        if (weights != null && !weights.isRowVector()) {
            throw new IllegalArgumentException("Weights array must be a row vector");
        }
        this.weights = weights;
    }

    public INDArray scoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        if (labels.size(1) != preOutput.size(1)) {
            throw new IllegalArgumentException("Labels array numColumns (size(1) = " + labels.size(1) + ") does not match output layer number of outputs (nOut = " + preOutput.size(1) + ") ");
        }
        INDArray output = activationFn.getActivation(preOutput.dup(), true);
        INDArray scoreArr = output.subi(labels);
        Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform("abs", scoreArr));
        if (this.weights != null) {
            if (this.weights.length() != output.size(1)) {
                throw new IllegalStateException("Weights vector (length " + this.weights.length() + ") does not match output.size(1)=" + output.size(1));
            }
            scoreArr.muliRowVector(this.weights);
        }
        if (mask != null) {
            LossUtil.applyMask(scoreArr, mask);
        }
        return scoreArr;
    }

    @Override
    public double computeScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        double score = scoreArr.sumNumber().doubleValue();
        if (average) {
            score /= (double)scoreArr.size(0);
        }
        return score;
    }

    @Override
    public INDArray computeScoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        return scoreArr.sum(1);
    }

    @Override
    public INDArray computeGradient(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        if (labels.size(1) != preOutput.size(1)) {
            throw new IllegalArgumentException("Labels array numColumns (size(1) = " + labels.size(1) + ") does not match output layer number of outputs (nOut = " + preOutput.size(1) + ") ");
        }
        INDArray output = activationFn.getActivation(preOutput.dup(), true);
        INDArray outSubLabels = output.sub(labels);
        INDArray dLda = Nd4j.getExecutioner().execAndReturn(new Sign(outSubLabels));
        if (this.weights != null) {
            dLda.muliRowVector(this.weights);
        }
        if (mask != null && LossUtil.isPerOutputMasking(dLda, mask)) {
            LossUtil.applyMask(dLda, mask);
        }
        INDArray gradients = (INDArray)activationFn.backprop(preOutput, dLda).getFirst();
        if (mask != null) {
            LossUtil.applyMask(gradients, mask);
        }
        return gradients;
    }

    @Override
    public Pair<Double, INDArray> computeGradientAndScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        return new Pair((Object)this.computeScore(labels, preOutput, activationFn, mask, average), (Object)this.computeGradient(labels, preOutput, activationFn, mask));
    }

    @Override
    public String name() {
        return this.toString();
    }

    public String toString() {
        if (this.weights == null) {
            return "LossL1()";
        }
        return "LossL1(weights=" + this.weights + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LossL1)) {
            return false;
        }
        LossL1 other = (LossL1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$weights = this.getWeights();
        INDArray other$weights = other.getWeights();
        return !(this$weights == null ? other$weights != null : !this$weights.equals(other$weights));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LossL1;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : $weights.hashCode());
        return result;
    }

    public INDArray getWeights() {
        return this.weights;
    }
}

