/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.beans.ConstructorProperties;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.RmsPropUpdater;
import org.nd4j.linalg.learning.config.IUpdater;

public class RmsProp
implements IUpdater {
    public static final double DEFAULT_RMSPROP_LEARNING_RATE = 0.1;
    public static final double DEFAULT_RMSPROP_EPSILON = 1.0E-8;
    public static final double DEFAULT_RMSPROP_RMSDECAY = 0.95;
    private double learningRate = 0.1;
    private double rmsDecay = 0.95;
    private double epsilon = 1.0E-8;

    public RmsProp() {
        this(0.1, 0.95, 1.0E-8);
    }

    public RmsProp(double rmsDecay) {
        this(0.1, rmsDecay, 1.0E-8);
    }

    @Override
    public long stateSize(long numParams) {
        return numParams;
    }

    @Override
    public void applySchedules(int iteration, double newLearningRate) {
        this.learningRate = newLearningRate;
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        RmsPropUpdater u = new RmsPropUpdater(this);
        u.setStateViewArray(viewArray, viewArray.shape(), viewArray.ordering(), initializeViewArray);
        return u;
    }

    @Override
    public RmsProp clone() {
        return new RmsProp(this.learningRate, this.rmsDecay, this.epsilon);
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getRmsDecay() {
        return this.rmsDecay;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setRmsDecay(double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RmsProp)) {
            return false;
        }
        RmsProp other = (RmsProp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
            return false;
        }
        return Double.compare(this.getEpsilon(), other.getEpsilon()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof RmsProp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
        result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        return result;
    }

    public String toString() {
        return "RmsProp(learningRate=" + this.getLearningRate() + ", rmsDecay=" + this.getRmsDecay() + ", epsilon=" + this.getEpsilon() + ")";
    }

    @ConstructorProperties(value={"learningRate", "rmsDecay", "epsilon"})
    public RmsProp(double learningRate, double rmsDecay, double epsilon) {
        this.learningRate = learningRate;
        this.rmsDecay = rmsDecay;
        this.epsilon = epsilon;
    }

    public static class Builder {
        private double learningRate = 0.1;
        private double rmsDecay = 0.95;
        private double epsilon = 1.0E-8;

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder rmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return this;
        }

        public Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public RmsProp build() {
            return new RmsProp(this.learningRate, this.rmsDecay, this.epsilon);
        }

        public String toString() {
            return "RmsProp.Builder(learningRate=" + this.learningRate + ", rmsDecay=" + this.rmsDecay + ", epsilon=" + this.epsilon + ")";
        }
    }
}

