/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import net.ericaro.neoitertools.Generator;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.iter.FirstAxisIterator;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.impl.accum.AMax;
import org.nd4j.linalg.api.ops.impl.accum.AMean;
import org.nd4j.linalg.api.ops.impl.accum.AMin;
import org.nd4j.linalg.api.ops.impl.accum.Entropy;
import org.nd4j.linalg.api.ops.impl.accum.EqualsWithEps;
import org.nd4j.linalg.api.ops.impl.accum.LogEntropy;
import org.nd4j.linalg.api.ops.impl.accum.MatchCondition;
import org.nd4j.linalg.api.ops.impl.accum.Max;
import org.nd4j.linalg.api.ops.impl.accum.Mean;
import org.nd4j.linalg.api.ops.impl.accum.Min;
import org.nd4j.linalg.api.ops.impl.accum.Norm1;
import org.nd4j.linalg.api.ops.impl.accum.Norm2;
import org.nd4j.linalg.api.ops.impl.accum.NormMax;
import org.nd4j.linalg.api.ops.impl.accum.Prod;
import org.nd4j.linalg.api.ops.impl.accum.ShannonEntropy;
import org.nd4j.linalg.api.ops.impl.accum.StandardDeviation;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.api.ops.impl.accum.Variance;
import org.nd4j.linalg.api.ops.impl.accum.distances.EuclideanDistance;
import org.nd4j.linalg.api.ops.impl.accum.distances.ManhattanDistance;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastCopyOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastRSubOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarAdd;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarFMod;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMultiplication;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarRemainder;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseDivision;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarReverseSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSet;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSubtraction;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarEquals;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarGreaterThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThan;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarLessThanOrEqual;
import org.nd4j.linalg.api.ops.impl.scalar.comparison.ScalarNotEquals;
import org.nd4j.linalg.api.ops.impl.transforms.Negative;
import org.nd4j.linalg.api.ops.impl.transforms.Set;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.AddOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.DivOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.FModOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.MulOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.RemainderOp;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.SubOp;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.Eps;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.EqualTo;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.GreaterThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.LessThan;
import org.nd4j.linalg.api.ops.impl.transforms.comparison.NotEqualTo;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndexAll;
import org.nd4j.linalg.indexing.NewAxis;
import org.nd4j.linalg.indexing.PointIndex;
import org.nd4j.linalg.indexing.ShapeOffsetResolution;
import org.nd4j.linalg.indexing.SpecifiedIndex;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.profiler.OpProfiler;
import org.nd4j.linalg.string.NDArrayStrings;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.nd4j.linalg.util.LongUtils;
import org.nd4j.linalg.util.NDArrayMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNDArray
implements INDArray,
Iterable {
    protected static final Logger log = LoggerFactory.getLogger(BaseNDArray.class);
    private static final long serialVersionUID = 3285982317165542614L;
    protected volatile transient DataBuffer shapeInformation;
    protected volatile transient DataBuffer data;
    protected transient boolean compressed = false;
    protected int[] javaShapeInformation;
    private static final int[][] tadFinalPermuteDimensions = new int[32][0];

    public BaseNDArray() {
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public void markAsCompressed(boolean reallyCompressed) {
        this.compressed = reallyCompressed;
    }

    public BaseNDArray(DataBuffer buffer) {
        this.data = buffer;
        if (buffer.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length of buffer can not be >= Integer.MAX_VALUE");
        }
        int[] shape = new int[]{1, (int)buffer.length()};
        int[] stride = Nd4j.getStrides(shape);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, 1, Nd4j.order().charValue()));
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int[] stride, long offset, char ordering) {
        this.data = offset > 0L ? Nd4j.createBuffer(buffer, offset, ArrayUtil.prodLong((int[])shape)) : buffer;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, offset, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        this.init(shape, stride);
    }

    public BaseNDArray(double[][] data) {
        this(data, Nd4j.order().charValue());
    }

    public BaseNDArray(double[][] data, char ordering) {
        this(Nd4j.createBuffer(ordering == 'c' ? ArrayUtil.flatten((double[][])data) : ArrayUtil.flattenF((double[][])data)), new int[]{data.length, data[0].length}, Nd4j.getStrides(new int[]{data.length, data[0].length}, ordering), 0L, ordering);
        for (int r = 0; r < this.rows(); ++r) {
            assert (data[r].length == this.columns());
        }
    }

    public BaseNDArray(int[] shape, DataBuffer buffer) {
        this.data = buffer;
        this.init(shape, Nd4j.getStrides(shape));
    }

    public BaseNDArray(float[] data, int[] shape, char ordering) {
        this(data, shape, 0L, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, long offset, char ordering) {
        this(data, shape, Nd4j.getStrides(shape, ordering), offset);
    }

    public BaseNDArray(int[] shape, int[] stride, long offset, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape)), shape, stride, offset, ordering);
    }

    public BaseNDArray(int[] shape, int[] stride, long offset, char ordering, boolean initialize) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape), initialize), shape, stride, offset, ordering);
    }

    public BaseNDArray(int[] shape, int[] stride, char ordering) {
        this(shape, stride, 0L, ordering);
    }

    public BaseNDArray(int[] shape, long offset, char ordering) {
        this(shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(int[] shape) {
        this(shape, 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(int newRows, int newColumns, char ordering) {
        this.data = Nd4j.createBuffer((long)newRows * (long)newColumns);
        int[] shape = new int[]{newRows, newColumns};
        int[] stride = Nd4j.getStrides(shape, ordering);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        this.init(shape, stride);
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, char ordering) {
        this(slices, shape, Nd4j.getStrides(shape, ordering), ordering);
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride, char ordering) {
        DataBuffer ret;
        this.data = ret = slices.get(0).data().dataType() == DataBuffer.Type.FLOAT ? Nd4j.createBuffer(new float[ArrayUtil.prod((int[])shape)]) : Nd4j.createBuffer(new double[ArrayUtil.prod((int[])shape)]);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        this.init(shape, stride);
        if (slices.get(0).isScalar()) {
            for (int i = 0; i < this.length(); ++i) {
                this.putScalar(i, slices.get(i).getDouble(0));
            }
        } else {
            for (int i = 0; i < this.slices(); ++i) {
                this.putSlice(i, slices.get(i));
            }
        }
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, char ordering) {
        this(data, shape, stride, 0L, ordering);
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, long offset, char ordering) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, offset, Shape.elementWiseStride(shape, stride, ordering == 'f'), ordering));
        if (data != null && data.length > 0) {
            this.data = Nd4j.createBuffer(data, offset);
            if (offset >= (long)data.length) {
                throw new IllegalArgumentException("invalid offset: must be < data.length");
            }
        }
        this.init(shape, stride);
    }

    public BaseNDArray(DataBuffer data, int[] shape, int[] stride, long offset) {
        this.data = Nd4j.createBuffer(data, offset, ArrayUtil.prodLong((int[])shape));
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, offset, Shape.elementWiseStride(shape, stride, Nd4j.order().charValue() == 'f'), Nd4j.order().charValue()));
        this.init(shape, stride);
    }

    public BaseNDArray(int[] data, int[] shape, int[] strides) {
        this(Nd4j.createBuffer(data), shape, strides);
    }

    public BaseNDArray(DataBuffer data, int[] shape) {
        this(data, shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, long offset) {
        this(Nd4j.createBuffer(buffer, offset, ArrayUtil.prodLong((int[])shape)), shape, Nd4j.getStrides(shape), offset, Nd4j.order().charValue());
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), 0L, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, char ordering) {
        this(Nd4j.createBuffer(data), shape, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, int[] stride, long offset, char ordering) {
        this(Nd4j.createBuffer(data, offset), shape, stride, offset, ordering);
    }

    public BaseNDArray(float[] data, char order) {
        this(Nd4j.createBuffer(data), order);
    }

    public BaseNDArray(DataBuffer floatBuffer, char order) {
        this(floatBuffer, new int[]{(int)floatBuffer.length()}, Nd4j.getStrides(new int[]{(int)floatBuffer.length()}, order), 0L, order);
        if (floatBuffer.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length of buffer can not be >= Integer.MAX_VALUE");
        }
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, int[] strides) {
        this(buffer, shape, strides, 0L, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape) {
        this(data, shape, 0L);
    }

    public BaseNDArray(float[] data, int[] shape, long offset) {
        this(data, shape, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride, long offset) {
        this(new float[ArrayUtil.prod((int[])shape)], shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(int[] shape, int[] stride) {
        this(shape, stride, 0L);
    }

    public BaseNDArray(int[] shape, long offset) {
        this(shape, Nd4j.getStrides(shape), offset);
    }

    public BaseNDArray(int[] shape, char ordering) {
        this(shape, 0L, ordering);
    }

    public BaseNDArray(int newRows, int newColumns) {
        this(newRows, newColumns, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseNDArray(List<INDArray> slices, int[] shape, int[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride) {
        this(data, shape, stride, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data, int[] shape, int[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseNDArray(float[] data) {
        this(Nd4j.createBuffer(data));
    }

    public BaseNDArray(float[][] data) {
        this(data, Nd4j.order().charValue());
    }

    public BaseNDArray(float[][] data, char ordering) {
        this(Nd4j.createBuffer(ordering == 'c' ? ArrayUtil.flatten((float[][])data) : ArrayUtil.flattenF((float[][])data)), new int[]{data.length, data[0].length}, Nd4j.getStrides(new int[]{data.length, data[0].length}, ordering), 0L, ordering);
        for (int r = 0; r < this.rows(); ++r) {
            assert (data[r].length == this.columns());
        }
    }

    public BaseNDArray(DataBuffer buffer, int[] shape, long offset, char ordering) {
        this(buffer, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
    }

    public BaseNDArray(double[] data, int[] shape, int[] stride, long offset) {
        this(Nd4j.createBuffer(data), shape, stride, offset);
    }

    @Override
    @Deprecated
    public void setWrapAround(boolean wrapAround) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isWrapAround() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isValid() {
        try {
            this.linearIndex(this.length() - 1);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public INDArray linearViewColumnOrder() {
        return this;
    }

    protected INDArray create(DataBuffer data, int[] shape, long offset) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(data, shape, offset);
        }
        return Nd4j.create(data, shape, offset);
    }

    @Override
    public INDArray linearView() {
        return this;
    }

    @Override
    public void resetLinearView() {
    }

    @Override
    public int elementWiseStride() {
        return Shape.elementWiseStride(this.shapeInfoDataBuffer());
    }

    @Override
    public int elementStride() {
        return 1;
    }

    @Override
    @Deprecated
    public int majorStride() {
        return this.stride(-1);
    }

    @Override
    @Deprecated
    public int secondaryStride() {
        return this.majorStride();
    }

    @Override
    public int tensorssAlongDimension(int ... dimension) {
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        if (dimension.length >= this.rank()) {
            return 1;
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        int[] tensorShape = ArrayUtil.keep((int[])this.shape(), (int[])dimension);
        long len = ArrayUtil.prodLong((int[])tensorShape);
        if (len == 0L) {
            throw new IllegalStateException("Illegal length found after removing index");
        }
        int length = this.length();
        if ((long)length / len >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tensors along dimension can not be >= Integer.MAX_VALUE");
        }
        return (int)((long)length / len);
    }

    @Override
    public INDArray tensorAlongDimension(int index, int ... dimension) {
        int tads;
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        if (dimension.length >= this.rank()) {
            return this;
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        if (dimension.length > 1) {
            dimension = Ints.toArray(new ArrayList(new TreeSet(Ints.asList((int[])dimension))));
        }
        if (dimension.length > 1) {
            Arrays.sort(dimension);
        }
        if (index >= (tads = this.tensorssAlongDimension(dimension))) {
            throw new IllegalArgumentException("Illegal index " + index + " out of tads " + tads);
        }
        if (dimension.length == 1) {
            if (dimension[0] == 0 && this.isColumnVector()) {
                return this.transpose();
            }
            if (dimension[0] == 1 && this.isRowVector()) {
                return this;
            }
        }
        Pair<DataBuffer, DataBuffer> tadInfo = Nd4j.getExecutioner().getTADManager().getTADOnlyShapeInfo(this, dimension);
        DataBuffer shapeInfo = (DataBuffer)tadInfo.getFirst();
        int[] shape = Shape.shape(shapeInfo);
        int[] stride = Shape.stride(shapeInfo).asInt();
        long offset = this.offset() + ((DataBuffer)tadInfo.getSecond()).getLong((long)index);
        INDArray toTad = Nd4j.create(this.data(), shape, stride, offset);
        BaseNDArray baseNDArray = (BaseNDArray)toTad;
        char newOrder = Shape.getOrder(shape, stride, 1);
        int ews = baseNDArray.shapeInfoDataBuffer().getInt(baseNDArray.shapeInfoDataBuffer().length() - 2L);
        if (!Shape.isRowVectorShape(baseNDArray.shapeInfoDataBuffer())) {
            ews = -1;
        }
        baseNDArray.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, stride, 0L, ews, newOrder));
        return toTad;
    }

    @Override
    public INDArray javaTensorAlongDimension(int index, int ... dimension) {
        return this.doTad(index, dimension);
    }

    private void setShapeInformation(Pair<DataBuffer, int[]> shapeInfo) {
        this.shapeInformation = (DataBuffer)shapeInfo.getFirst();
        this.javaShapeInformation = (int[])shapeInfo.getSecond();
    }

    private INDArray doTad(int index, int ... dimension) {
        int tads;
        if (dimension == null || dimension.length == 0) {
            throw new IllegalArgumentException("Invalid input: dimensions not specified (null or length 0)");
        }
        if (dimension.length >= this.rank()) {
            return this;
        }
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + this.rank();
        }
        if (dimension.length > 1) {
            Arrays.sort(dimension);
        }
        if (index >= (tads = this.tensorssAlongDimension(dimension))) {
            throw new IllegalArgumentException("Illegal index " + index + " out of tads " + tads);
        }
        if (dimension.length == 1) {
            if (dimension[0] == 0 && this.isColumnVector()) {
                return this.transpose();
            }
            if (dimension[0] == 1 && this.isRowVector()) {
                return this;
            }
        }
        int[] tensorShape = ArrayUtil.keep((int[])this.shape(), (int[])dimension);
        int[] reverseDimensions = ArrayUtil.reverseCopy((int[])dimension);
        int[] remove = ArrayUtil.removeIndex((int[])ArrayUtil.range((int)0, (int)this.rank()), (int[])dimension);
        int[] newPermuteDims = Ints.concat((int[][])new int[][]{remove, reverseDimensions});
        int[] finalPermuteDims = tadFinalPermuteDimensions[dimension.length];
        INDArray permuted = this.permute(newPermuteDims);
        int sliceIdx = NDArrayMath.sliceOffsetForTensor(index, permuted, tensorShape);
        INDArray ret2 = permuted.slice(sliceIdx);
        if (dimension.length == tensorShape.length && ArrayUtil.prod((int[])tensorShape) == ret2.length()) {
            if (dimension.length == 1 && ret2.isRowVector()) {
                return ret2;
            }
            if (finalPermuteDims.length != ret2.rank()) {
                finalPermuteDims = new int[ret2.rank()];
                int count = 0;
                int i = finalPermuteDims.length - 1;
                while (i >= 0) {
                    finalPermuteDims[count++] = i--;
                }
            }
            return ret2.permutei(finalPermuteDims);
        }
        int length = ArrayUtil.prod((int[])tensorShape);
        int tensorLength = ArrayUtil.prod((int[])tensorShape);
        long offset = index * tensorLength / NDArrayMath.lengthPerSlice(ret2);
        if (sliceIdx == 0 && length == NDArrayMath.lengthPerSlice(ret2)) {
            ret2 = ret2.slice((int)offset);
            if (dimension.length == 1 && ret2.isRowVector()) {
                return ret2;
            }
            return ret2.permutei(finalPermuteDims);
        }
        if (length == NDArrayMath.lengthPerSlice(ret2)) {
            offset -= (long)ret2.slices() * (offset / (long)ret2.slices());
            ret2 = ret2.slice((int)offset);
            if (dimension.length == 1 && ret2.isRowVector()) {
                return ret2;
            }
            return ret2.permutei(finalPermuteDims);
        }
        while (ret2.length() > length) {
            sliceIdx = NDArrayMath.sliceOffsetForTensor(index, ret2, tensorShape);
            sliceIdx -= ret2.slices() * (sliceIdx / ret2.slices());
            ret2 = ret2.slice(sliceIdx);
        }
        if (dimension.length == 1 && ret2.isRowVector()) {
            return ret2;
        }
        return ret2.permutei(finalPermuteDims);
    }

    @Override
    public int vectorsAlongDimension(int dimension) {
        if (dimension == 0 && this.isVector() || this.isRowVector()) {
            return 1;
        }
        if (this.size(dimension) == 1 && !this.isVector()) {
            for (int i = dimension; i < this.rank(); ++i) {
                if (this.size(i) == 1) continue;
                return this.vectorsAlongDimension(i);
            }
            return this.length();
        }
        if (this.size(0) == 1 && !this.isVector()) {
            int realDimension = this.rank() - this.getLeadingOnes();
            int length = this.length();
            if (length / this.size(realDimension) >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Vectors along dimension can not be >= Integer.MAX_VALUE");
            }
            return length / this.size(realDimension);
        }
        int length = this.length();
        if (dimension >= Shape.rank(this.javaShapeInformation)) {
            if (length / this.size(Shape.rank(this.javaShapeInformation) - 1) >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Vectors along dimension can not be >= Integer.MAX_VALUE");
            }
            return length / this.size(Shape.rank(this.javaShapeInformation) - 1);
        }
        if (length / this.size(dimension) >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Vectors along dimension can not be >= Integer.MAX_VALUE");
        }
        return length / this.size(dimension);
    }

    @Override
    public INDArray vectorAlongDimension(int index, int dimension) {
        if (dimension < 0) {
            dimension = Shape.rank(this.javaShapeInformation) + dimension;
        }
        if (dimension == Shape.rank(this.javaShapeInformation) - 1 && this.size(dimension) == 1 && this.rank() > 2 || this.rank() > 2 && dimension == 0 && this.size(dimension) == 1) {
            return this;
        }
        INDArray ret = this.tensorAlongDimension(index, dimension);
        if (this.isMatrix() && ret.isVector() && dimension == 1 && !ret.isRowVector()) {
            return ret.reshape(ArrayUtil.reverseCopy((int[])ret.shape()));
        }
        if (this.isMatrix() && ret.isVector() && dimension == 0 && !ret.isColumnVector()) {
            return ret.reshape(ArrayUtil.reverseCopy((int[])ret.shape()));
        }
        return ret;
    }

    @Override
    public void setOrder(char order) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(this.shape(), this.stride(), 0L, this.elementWiseStride(), order));
    }

    @Override
    public void setShape(int ... shape) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape, this.stride(), 0L, this.elementWiseStride(), this.ordering()));
    }

    @Override
    public void setStride(int[] stride) {
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(this.shape(), stride, 0L, this.elementWiseStride(), this.ordering()));
    }

    @Override
    public INDArray cumsumi(int dimension) {
        if (this.isVector()) {
            double s = 0.0;
            for (int i = 0; i < this.length(); ++i) {
                this.putScalar(i, s += this.getDouble(i));
            }
        } else {
            if (dimension == Integer.MAX_VALUE) {
                INDArray flattened = this.ravel();
                double prevVal = flattened.getDouble(0);
                for (int i = 1; i < flattened.length(); ++i) {
                    double d = prevVal + flattened.getDouble(i);
                    flattened.putScalar(i, d);
                    prevVal = d;
                }
                return flattened;
            }
            for (int i = 0; i < this.vectorsAlongDimension(dimension); ++i) {
                INDArray vec = this.vectorAlongDimension(i, dimension);
                vec.cumsumi(0);
            }
        }
        return this;
    }

    @Override
    public Number normmaxNumber() {
        return this.normmax(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber normmaxComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number norm2Number() {
        return this.norm2(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber norm2Complex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number norm1Number() {
        return this.norm1(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber norm1Complex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number stdNumber() {
        return this.std(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber stdComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number prodNumber() {
        return this.prod(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber prodComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number meanNumber() {
        return this.mean(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public Number ameanNumber() {
        return this.amean(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber meanComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number varNumber() {
        return this.var(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber varComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number maxNumber() {
        return this.max(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public Number amaxNumber() {
        return this.amax(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber maxComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number minNumber() {
        return this.min(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public Number aminNumber() {
        return this.amin(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public Number scan(Condition condition) {
        MatchCondition op = new MatchCondition((INDArray)this, condition);
        return Nd4j.getExecutioner().exec(op, Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber minComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Number sumNumber() {
        return this.sum(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public Number entropyNumber() {
        return this.entropy(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public Number shannonEntropyNumber() {
        return this.shannonEntropy(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public Number logEntropyNumber() {
        return this.logEntropy(Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public IComplexNumber sumComplex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray cumsum(int dimension) {
        return this.dup().cumsumi(dimension);
    }

    @Override
    public INDArray assign(INDArray arr) {
        Nd4j.getExecutioner().exec(new Set(this, arr, this, this.length()));
        return this;
    }

    @Override
    public INDArray putScalar(int i, double value) {
        if (i < 0) {
            i += this.rank();
        }
        if (this.isScalar()) {
            if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED) {
                OpProfiler.getInstance().processScalarCall();
            }
            this.data.put((long)i, value);
            return this;
        }
        if (this.isRowVector()) {
            return this.putScalar(0, i, value);
        }
        if (this.isColumnVector()) {
            return this.putScalar(i, 0, value);
        }
        int[] indexes = this.ordering() == 'c' ? Shape.ind2subC(this, (long)i) : Shape.ind2sub(this, (long)i);
        return this.putScalar(indexes, value);
    }

    @Override
    public INDArray putScalar(int i, float value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(int i, int value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(int[] indexes, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0) continue;
            int n = i;
            indexes[n] = indexes[n] + this.rank();
        }
        if (indexes.length == 1) {
            return this.putScalar(indexes[0], value);
        }
        if (indexes.length == 2) {
            return this.putScalar(indexes[0], indexes[1], value);
        }
        if (indexes.length == 3) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], value);
        }
        if (indexes.length == 4) {
            return this.putScalar(indexes[0], indexes[1], indexes[2], indexes[3], value);
        }
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED) {
            OpProfiler.getInstance().processScalarCall();
        }
        long offset = Shape.getOffset(this.javaShapeInformation, indexes);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(int row, int col, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED) {
            OpProfiler.getInstance().processScalarCall();
        }
        if (this.rank() != 2) {
            throw new IllegalStateException("Cannot use putScalar(int,int,double) on a rank " + this.rank() + " INDArray");
        }
        long offset = Shape.getOffsetUnsafe(this.javaShapeInformation, row, col);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(int dim0, int dim1, int dim2, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED) {
            OpProfiler.getInstance().processScalarCall();
        }
        if (this.rank() != 3) {
            throw new IllegalStateException("Cannot use putScalar(int,int,int,double) on a rank " + this.rank() + " INDArray");
        }
        long offset = 0L;
        int size_0 = this.javaShapeInformation[1];
        int size_1 = this.javaShapeInformation[2];
        int size_2 = this.javaShapeInformation[3];
        if (size_0 != 1) {
            offset += (long)(dim0 * this.javaShapeInformation[4]);
        }
        if (size_1 != 1) {
            offset += (long)(dim1 * this.javaShapeInformation[5]);
        }
        if (size_2 != 1) {
            offset += (long)(dim2 * this.javaShapeInformation[6]);
        }
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(int dim0, int dim1, int dim2, int dim3, double value) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED) {
            OpProfiler.getInstance().processScalarCall();
        }
        if (this.rank() != 4) {
            throw new IllegalStateException("Cannot use putScalar(int,int,int,int,double) on a rank " + this.rank() + " INDArray");
        }
        long offset = Shape.getOffsetUnsafe(this.javaShapeInformation, dim0, dim1, dim2, dim3);
        this.data.put(offset, value);
        return this;
    }

    @Override
    public INDArray putScalar(int[] indexes, float value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray putScalar(int[] indexes, int value) {
        return this.putScalar(indexes, (double)value);
    }

    @Override
    public INDArray eps(Number other) {
        return this.dup().epsi(other);
    }

    @Override
    public INDArray epsi(Number other) {
        INDArray otherArr = Nd4j.valueArrayOf(this.shape(), other.doubleValue());
        return this.epsi(otherArr);
    }

    @Override
    public INDArray eps(INDArray other) {
        return this.dup().epsi(other);
    }

    @Override
    public INDArray epsi(INDArray other) {
        Nd4j.getExecutioner().exec(new Eps(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray lt(Number other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lte(Number other) {
        return this.dup().ltei(other);
    }

    @Override
    public INDArray lti(Number other) {
        Nd4j.getExecutioner().exec(new ScalarLessThan((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray ltei(Number other) {
        Nd4j.getExecutioner().exec(new ScalarLessThanOrEqual((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray eq(Number other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(Number other) {
        Nd4j.getExecutioner().exec(new ScalarEquals((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray gt(Number other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gte(Number other) {
        return this.dup().gtei(other);
    }

    @Override
    public INDArray gtei(Number other) {
        Nd4j.getExecutioner().exec(new ScalarGreaterThanOrEqual((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray gti(Number other) {
        Nd4j.getExecutioner().exec(new ScalarGreaterThan((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray lt(INDArray other) {
        return this.dup().lti(other);
    }

    @Override
    public INDArray lti(INDArray other) {
        Nd4j.getExecutioner().exec(new LessThan(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray neq(Number other) {
        return this.dup().neqi(other);
    }

    @Override
    public INDArray neqi(Number other) {
        Nd4j.getExecutioner().exec(new ScalarNotEquals((INDArray)this, other));
        return this;
    }

    @Override
    public INDArray neq(INDArray other) {
        return this.dup().neqi(other);
    }

    @Override
    public INDArray neqi(INDArray other) {
        Nd4j.getExecutioner().exec(new NotEqualTo(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray eq(INDArray other) {
        return this.dup().eqi(other);
    }

    @Override
    public INDArray eqi(INDArray other) {
        Nd4j.getExecutioner().exec(new EqualTo(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray gt(INDArray other) {
        return this.dup().gti(other);
    }

    @Override
    public INDArray gti(INDArray other) {
        Nd4j.getExecutioner().exec(new GreaterThan(this, other, this, this.length()));
        return this;
    }

    @Override
    public INDArray neg() {
        return Nd4j.getExecutioner().exec(new Negative(this, Nd4j.createUninitialized(this.shape(), this.ordering()))).z();
    }

    @Override
    public INDArray negi() {
        Nd4j.getExecutioner().exec(new Negative(this));
        return this;
    }

    @Override
    public INDArray rdiv(Number n, INDArray result) {
        return this.rdivi(n, result);
    }

    @Override
    public INDArray rdivi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarReverseDivision((INDArray)this, null, result, (long)result.length(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray rsub(Number n, INDArray result) {
        return this.rsubi(n, result);
    }

    @Override
    public INDArray rsubi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarReverseSubtraction((INDArray)this, null, result, result.lengthLong(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray div(Number n, INDArray result) {
        return this.divi(n, result);
    }

    @Override
    public INDArray divi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarDivision((INDArray)this, null, result, result.lengthLong(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray mul(Number n, INDArray result) {
        return this.muli(n, result);
    }

    @Override
    public INDArray muli(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarMultiplication((INDArray)this, null, result, result.lengthLong(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray sub(Number n, INDArray result) {
        return this.subi(n, result);
    }

    @Override
    public INDArray subi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarSubtraction((INDArray)this, null, result, result.lengthLong(), n));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray add(Number n, INDArray result) {
        return this.addi(n, result);
    }

    @Override
    public INDArray addi(Number n, INDArray result) {
        if (Double.isNaN(n.doubleValue())) {
            n = Nd4j.EPS_THRESHOLD;
        }
        Nd4j.getExecutioner().exec(new ScalarAdd((INDArray)this, null, result, result.lengthLong(), n));
        return result;
    }

    @Override
    public INDArray getScalar(int row, int column) {
        return this.getScalar(new int[]{row, column});
    }

    @Override
    public INDArray dup() {
        if (this.isCompressed() && this.ordering() == Nd4j.order().charValue()) {
            INDArray ret = Nd4j.createArrayFromShapeBuffer(this.data().dup(), this.shapeInfoDataBuffer());
            ret.markAsCompressed(true);
            return ret;
        }
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        INDArray ret = Shape.toOffsetZeroCopy(this);
        return ret;
    }

    @Override
    public INDArray dup(char order) {
        if (this.isCompressed() && this.ordering() == order) {
            INDArray ret = Nd4j.createArrayFromShapeBuffer(this.data().dup(), this.shapeInfoDataBuffer());
            ret.markAsCompressed(true);
            return ret;
        }
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        return Shape.toOffsetZeroCopy(this, order);
    }

    @Override
    public int getInt(int ... indices) {
        return (int)this.getDouble(indices);
    }

    @Override
    public double getDouble(int ... indices) {
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED) {
            OpProfiler.getInstance().processScalarCall();
        }
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] >= 0) continue;
            int n = i;
            indices[n] = indices[n] + this.rank();
        }
        if (indices.length == 1) {
            if (this.isRowVector()) {
                return Shape.getDouble(this, 0, indices[0]);
            }
            if (this.isColumnVector()) {
                return Shape.getDouble(this, indices[0], 0);
            }
            if (this.isScalar() && indices[0] == 0) {
                return this.data().getDouble(0L);
            }
            throw new IllegalStateException("Indexes length must be > 1 for non vectors and scalars");
        }
        return Shape.getDouble(this, indices);
    }

    @Override
    public float getFloat(int ... indices) {
        return (float)this.getDouble(indices);
    }

    @Override
    public boolean isScalar() {
        if (Shape.rank(this.javaShapeInformation) > 2) {
            return false;
        }
        if (Shape.rank(this.javaShapeInformation) == 1) {
            return this.shapeOf().getInt(0L) == 1;
        }
        if (Shape.rank(this.javaShapeInformation) == 2) {
            return this.shapeOf().getInt(0L) == 1 && this.shapeOf().getInt(1L) == 1;
        }
        return false;
    }

    @Override
    public INDArray put(int[] indices, INDArray element) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Unable to insert anything but a scalar");
        }
        if (this.isRowVector() && indices[0] == 0 && indices.length == 2) {
            int ix = Shape.offset(this.javaShapeInformation);
            for (int i = 1; i < indices.length; ++i) {
                ix += indices[i] * this.stride(i);
            }
            if ((long)ix >= this.data.length()) {
                throw new IllegalArgumentException("Illegal indices " + Arrays.toString(indices));
            }
            this.data.put((long)ix, element.getDouble(0));
        } else {
            int ix = Shape.offset(this.javaShapeInformation);
            for (int i = 0; i < indices.length; ++i) {
                if (this.size(i) == 1) continue;
                ix += indices[i] * this.stride(i);
            }
            if ((long)ix >= this.data.length()) {
                throw new IllegalArgumentException("Illegal indices " + Arrays.toString(indices));
            }
            this.data.put((long)ix, element.getDouble(0));
        }
        return this;
    }

    @Override
    public INDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    @Override
    public INDArray put(int i, int j, Number element) {
        return this.putScalar(new int[]{i, j}, element.doubleValue());
    }

    @Override
    public INDArray putSlice(int slice, INDArray put) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.put(0, put.getScalar(0));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar() || put.isVector() && put.length() == this.length()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            if (put.isScalar()) {
                this.putScalar(slice, put.getDouble(0));
            } else {
                for (int i = 0; i < this.length(); ++i) {
                    this.putScalar(i, put.getDouble(i));
                }
            }
            return this;
        }
        this.assertSlice(put, slice);
        INDArray view = this.slice(slice);
        if (put.length() == 1) {
            this.putScalar(slice, put.getDouble(0));
        } else if (put.isVector()) {
            for (int i = 0; i < put.length(); ++i) {
                view.putScalar(i, put.getDouble(i));
            }
        } else {
            assert (Shape.shapeEquals(view.shape(), put.shape()));
            INDArray linear = view;
            INDArray putLinearView = put;
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, putLinearView.getDouble(i));
            }
        }
        return this;
    }

    protected void assertSlice(INDArray put, int slice) {
        assert (slice <= this.slices()) : "Invalid slice specified " + slice;
        int[] sliceShape = put.shape();
        if (Shape.isRowVectorShape(sliceShape)) {
            return;
        }
        int[] requiredShape = ArrayUtil.removeIndex((int[])this.shape(), (int)0);
        if (put.isScalar()) {
            return;
        }
        if (this.isVector() && put.isVector() && put.length() < this.length()) {
            return;
        }
        if (Shape.isColumnVectorShape(sliceShape)) {
            return;
        }
        if (!(Shape.shapeEquals(sliceShape, requiredShape) || Shape.isRowVectorShape(requiredShape) || Shape.isRowVectorShape(sliceShape))) {
            throw new IllegalStateException(String.format("Invalid shape size of %s . Should have been %s ", Arrays.toString(sliceShape), Arrays.toString(requiredShape)));
        }
    }

    @Override
    public boolean isMatrix() {
        int rank = this.rank();
        return rank == 2 && this.size(0) != 1 && this.size(1) != 1;
    }

    @Override
    @Deprecated
    public int index(int row, int column) {
        if (!this.isMatrix()) {
            if (this.isColumnVector()) {
                int idx = this.linearIndex(row);
                return idx;
            }
            if (this.isRowVector()) {
                int idx = this.linearIndex(column);
                return idx;
            }
            throw new IllegalStateException("Unable to get row/column from a non matrix");
        }
        return Shape.offset(this.javaShapeInformation) + (row * this.stride(0) + column * this.stride(1));
    }

    protected INDArray newShape(int[] newShape, char ordering) {
        return this.create(this.data(), newShape, this.stride(), Shape.offset(this.javaShapeInformation));
    }

    protected INDArray create(DataBuffer data, int[] newShape, int[] newStrides, long offset, char ordering) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(data, newShape, newStrides, offset, ordering);
        }
        return Nd4j.create(data, newShape, newStrides, offset, ordering);
    }

    protected INDArray create(DataBuffer data, int[] newShape, int[] newStrides, long offset) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(data, newShape, newStrides, offset);
        }
        return Nd4j.create(data, newShape, newStrides, offset);
    }

    protected INDArray create(int[] shape) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(shape, this.getStrides(shape, Nd4j.order().charValue()), 0L);
        }
        return Nd4j.create(shape, this.getStrides(shape, Nd4j.order().charValue()), 0L);
    }

    protected INDArray create(int[] shape, int[] strides, long offset) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(shape, strides, offset);
        }
        return Nd4j.create(shape, strides, offset);
    }

    protected int[] getStrides(int[] shape, char ordering) {
        return Nd4j.getStrides(shape, ordering);
    }

    @Override
    public double squaredDistance(INDArray other) {
        double d2 = this.distance2(other);
        return d2 * d2;
    }

    @Override
    public double distance2(INDArray other) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        return Nd4j.getExecutioner().execAndReturn(new EuclideanDistance(this, other)).getFinalResult().doubleValue();
    }

    @Override
    public double distance1(INDArray other) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        return Nd4j.getExecutioner().execAndReturn(new ManhattanDistance(this, other)).getFinalResult().doubleValue();
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, INDArray element) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (indices[0] instanceof SpecifiedIndex && element.isVector()) {
            indices[0].reset();
            int cnt = 0;
            while (indices[0].hasNext()) {
                long idx = indices[0].next();
                this.putScalar((int)idx, element.getDouble(cnt));
                ++cnt;
            }
            return this;
        }
        return this.get(indices).assign(element);
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, Number element) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        INDArray get = this.get(indices);
        for (int i = 0; i < get.length(); ++i) {
            get.putScalar(i, element.doubleValue());
        }
        return this;
    }

    @Override
    public INDArray swapAxes(int dimension, int with) {
        int[] shape = ArrayUtil.range((int)0, (int)this.shape().length);
        shape[dimension] = with;
        shape[with] = dimension;
        return this.permute(shape);
    }

    @Override
    public boolean isView() {
        return Shape.offset(this.javaShapeInformation) > 0 || (long)this.length() < this.data().length() && this.data.dataType() != DataBuffer.Type.INT || this.data().originalDataBuffer() != null;
    }

    @Override
    public DataBuffer data() {
        return this.data;
    }

    @Override
    public void setData(DataBuffer data) {
        this.data = data;
    }

    @Override
    public int slices() {
        if (this.isRowVector()) {
            return this.length();
        }
        return this.size(0);
    }

    @Override
    public INDArray subArray(ShapeOffsetResolution resolution) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        long[] offsets = resolution.getOffsets();
        int[] shape = LongUtils.toInts(resolution.getShapes());
        int[] stride = LongUtils.toInts(resolution.getStrides());
        long offset = this.offset() + resolution.getOffset();
        int n = shape.length;
        if (shape.length < 1) {
            return this.create(Nd4j.createBufferDetached(shape));
        }
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (stride.length != n) {
            throw new IllegalArgumentException("Invalid stride " + Arrays.toString(stride));
        }
        if (shape.length == this.rank() && Shape.contentEquals(shape, this.shapeOf())) {
            if (ArrayUtil.isZero((long[])offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        char newOrder = Shape.getOrder(shape, stride, 1);
        return this.create(this.data, Arrays.copyOf(shape, shape.length), stride, offset, newOrder);
    }

    @Override
    public INDArray subArray(long[] offsets, int[] shape, int[] stride) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        int n = shape.length;
        if (shape.length < 1) {
            return this.create(Nd4j.createBufferDetached(shape));
        }
        if (offsets.length != n) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (stride.length != n) {
            throw new IllegalArgumentException("Invalid stride " + Arrays.toString(stride));
        }
        if (Shape.contentEquals(shape, this.shapeOf())) {
            if (ArrayUtil.isZero((long[])offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        long[] dotProductOffsets = offsets;
        int[] dotProductStride = stride;
        long offset = (long)Shape.offset(this.javaShapeInformation) + NDArrayIndex.offset(dotProductStride, dotProductOffsets);
        if (offset >= this.data().length()) {
            offset = ArrayUtil.sumLong((long[])offsets);
        }
        return this.create(this.data, Arrays.copyOf(shape, shape.length), stride, offset, this.ordering());
    }

    protected INDArray create(DataBuffer buffer) {
        return Nd4j.create(buffer);
    }

    @Override
    public INDArray cond(Condition condition) {
        return this.dup().condi(condition);
    }

    @Override
    public INDArray condi(Condition condition) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        BaseNDArray linear = this;
        for (int i = 0; i < this.length(); ++i) {
            boolean met = condition.apply(linear.getDouble(i));
            linear.putScalar(i, met ? 1 : 0);
        }
        return this;
    }

    protected void init(int[] shape, int[] stride) {
        if (shape.length == 1) {
            this.init(new int[]{1, shape[0]}, new int[]{1, stride[0]});
        }
        if (this.ordering() == '\u0000') {
            Shape.setOrder(this.shapeInfo(), Nd4j.order().charValue());
            throw new IllegalStateException("setOrder() shouldn't ever happen here");
        }
    }

    @Override
    public INDArray getScalar(int i) {
        return Nd4j.scalar(this.getDouble(i));
    }

    protected INDArray doColumnWise(INDArray columnVector, char operation) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (!columnVector.isColumnVector() || this.size(0) != columnVector.size(0)) {
            throw new IllegalStateException("Mismatched shapes (shape = " + Arrays.toString(this.shape()) + ", row vector shape =" + Arrays.toString(columnVector.shape()) + ")");
        }
        if (columnVector.data().sameUnderlyingData(this.data())) {
            return this.doColumnWise(columnVector.dup(), operation);
        }
        if (this.isVector()) {
            switch (operation) {
                case 'a': {
                    this.addi(columnVector);
                    break;
                }
                case 'p': {
                    this.assign(columnVector);
                    break;
                }
                case 's': {
                    this.subi(columnVector);
                    break;
                }
                case 'm': {
                    this.muli(columnVector);
                    break;
                }
                case 'd': {
                    this.divi(columnVector);
                    break;
                }
                case 'h': {
                    this.rsubi(columnVector);
                    break;
                }
                case 't': {
                    this.rdivi(columnVector);
                }
            }
            return this;
        }
        if (this.rows() == 1 && columnVector.isScalar()) {
            this.applyScalarOp(columnVector, operation);
        } else if (this.rank() == 2 && this.elementWiseStride() == 1 && this.ordering() == 'c' && columnVector.elementWiseStride() == 1) {
            switch (operation) {
                case 'a': {
                    ScalarAdd op = new ScalarAdd((INDArray)this, columnVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'p': {
                    ScalarSet op = new ScalarSet((INDArray)this, columnVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 's': {
                    ScalarSubtraction op = new ScalarSubtraction((INDArray)this, columnVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'm': {
                    ScalarMultiplication op = new ScalarMultiplication((INDArray)this, columnVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'd': {
                    ScalarDivision op = new ScalarDivision((INDArray)this, columnVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'h': {
                    ScalarReverseSubtraction op = new ScalarReverseSubtraction((INDArray)this, columnVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 't': {
                    ScalarReverseDivision op = new ScalarReverseDivision((INDArray)this, columnVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(1);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
            }
        } else {
            this.applyBroadcastOp(columnVector, operation);
        }
        return this;
    }

    @Override
    @Deprecated
    public boolean isCleanedUp() {
        return false;
    }

    @Override
    @Deprecated
    public void cleanup() {
        if (Nd4j.shouldInstrument) {
            Nd4j.getInstrumentation().log(this, "destroyed");
        }
    }

    protected INDArray doRowWise(INDArray rowVector, char operation) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (!rowVector.isRowVector() || this.size(1) != rowVector.size(1)) {
            throw new IllegalStateException("Mismatched shapes (shape = " + Arrays.toString(this.shape()) + ", row vector shape =" + Arrays.toString(rowVector.shape()) + ")");
        }
        if (rowVector.data().sameUnderlyingData(this.data())) {
            return this.doRowWise(rowVector.dup(), operation);
        }
        if (this.isVector()) {
            switch (operation) {
                case 'a': {
                    this.addi(rowVector);
                    break;
                }
                case 'p': {
                    this.assign(rowVector);
                    break;
                }
                case 's': {
                    this.subi(rowVector);
                    break;
                }
                case 'm': {
                    this.muli(rowVector);
                    break;
                }
                case 'd': {
                    this.divi(rowVector);
                    break;
                }
                case 'h': {
                    this.rsubi(rowVector);
                    break;
                }
                case 't': {
                    this.rdivi(rowVector);
                }
            }
            return this;
        }
        if (this.rank() == 2 && this.columns() == 1 && rowVector.isScalar()) {
            if (this instanceof IComplexNDArray) {
                this.applyScalarOp(rowVector, operation);
            }
        } else if (this.rank() == 2 && this.elementWiseStride() == 1 && this.ordering() == 'f' && rowVector.elementWiseStride() == 1) {
            switch (operation) {
                case 'a': {
                    ScalarAdd op = new ScalarAdd((INDArray)this, rowVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'p': {
                    ScalarSet op = new ScalarSet((INDArray)this, rowVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 's': {
                    ScalarSubtraction op = new ScalarSubtraction((INDArray)this, rowVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'm': {
                    ScalarMultiplication op = new ScalarMultiplication((INDArray)this, rowVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'd': {
                    ScalarDivision op = new ScalarDivision((INDArray)this, rowVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 'h': {
                    ScalarReverseSubtraction op = new ScalarReverseSubtraction((INDArray)this, rowVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
                case 't': {
                    ScalarReverseDivision op = new ScalarReverseDivision((INDArray)this, rowVector, (INDArray)this, (long)this.length(), 0.0);
                    op.setDimension(0);
                    Nd4j.getExecutioner().exec(op);
                    break;
                }
            }
        } else {
            this.applyBroadcastOp(rowVector, operation);
        }
        return this;
    }

    private void applyBroadcastOp(INDArray vector, char operation) {
        int alongDimension;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        int n = alongDimension = Shape.isRowVectorShape(vector.shape()) ? 1 : 0;
        if (this.data() == vector.data()) {
            vector = vector.dup();
        }
        switch (operation) {
            case 'a': {
                Nd4j.getExecutioner().exec(new BroadcastAddOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 's': {
                Nd4j.getExecutioner().exec(new BroadcastSubOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 'm': {
                Nd4j.getExecutioner().exec(new BroadcastMulOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 'd': {
                Nd4j.getExecutioner().exec(new BroadcastDivOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 'h': {
                Nd4j.getExecutioner().exec(new BroadcastRSubOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 't': {
                Nd4j.getExecutioner().exec(new BroadcastRDivOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
            case 'p': {
                Nd4j.getExecutioner().exec(new BroadcastCopyOp((INDArray)this, vector, (INDArray)this, alongDimension), alongDimension);
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown operation: " + operation);
    }

    private void applyScalarOp(INDArray vector, char operation) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this instanceof IComplexNDArray) {
            IComplexNDArray row = (IComplexNDArray)vector;
            switch (operation) {
                case 'a': {
                    this.addi(row.getComplex(0));
                    break;
                }
                case 's': {
                    this.subi(row.getComplex(0));
                    break;
                }
                case 'm': {
                    this.muli(row.getComplex(0));
                    break;
                }
                case 'd': {
                    this.divi(row.getComplex(0));
                    break;
                }
                case 'h': {
                    this.rsubi(row.getComplex(0));
                    break;
                }
                case 't': {
                    this.rdivi(row.getComplex(0));
                }
            }
        } else {
            switch (operation) {
                case 'a': {
                    this.addi(vector.getDouble(0));
                    break;
                }
                case 's': {
                    this.subi(vector.getDouble(0));
                    break;
                }
                case 'm': {
                    this.muli(vector.getDouble(0));
                    break;
                }
                case 'd': {
                    this.divi(vector.getDouble(0));
                    break;
                }
                case 'h': {
                    this.rsubi(vector.getDouble(0));
                    break;
                }
                case 't': {
                    this.rdivi(vector.getDouble(0));
                }
            }
        }
    }

    protected DataBuffer shapeOf() {
        return Shape.shapeOf(this.shapeInfoDataBuffer());
    }

    protected DataBuffer strideOf() {
        return Shape.stride(this.shapeInfoDataBuffer());
    }

    @Override
    public int stride(int dimension) {
        int rank = Shape.rank(this.javaShapeInformation);
        if (dimension < 0) {
            return this.strideOf().getInt((long)(dimension + rank));
        }
        return this.strideOf().getInt((long)dimension);
    }

    @Override
    public INDArray rdiviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 't');
    }

    @Override
    public INDArray rdivColumnVector(INDArray columnVector) {
        return this.dup().rdiviColumnVector(columnVector);
    }

    @Override
    public INDArray rdiviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 't');
    }

    @Override
    public INDArray rdivRowVector(INDArray rowVector) {
        return this.dup().rdiviRowVector(rowVector);
    }

    @Override
    public INDArray rsubiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'h');
    }

    @Override
    public INDArray rsubColumnVector(INDArray columnVector) {
        return this.dup().rsubiColumnVector(columnVector);
    }

    @Override
    public INDArray rsubiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'h');
    }

    @Override
    public INDArray rsubRowVector(INDArray rowVector) {
        return this.dup().rsubiRowVector(rowVector);
    }

    @Override
    public INDArray put(int i, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Element must be a scalar");
        }
        return this.putScalar(i, element.getDouble(0));
    }

    @Override
    public INDArray diviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'd');
    }

    @Override
    public INDArray divColumnVector(INDArray columnVector) {
        return this.dup().diviColumnVector(columnVector);
    }

    @Override
    public INDArray diviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'd');
    }

    @Override
    public INDArray divRowVector(INDArray rowVector) {
        return this.dup().diviRowVector(rowVector);
    }

    @Override
    public INDArray muliColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'm');
    }

    @Override
    public INDArray mulColumnVector(INDArray columnVector) {
        return this.dup().muliColumnVector(columnVector);
    }

    @Override
    public INDArray muliRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'm');
    }

    @Override
    public INDArray mulRowVector(INDArray rowVector) {
        return this.dup().muliRowVector(rowVector);
    }

    @Override
    public INDArray subiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 's');
    }

    @Override
    public INDArray subColumnVector(INDArray columnVector) {
        return this.dup().subiColumnVector(columnVector);
    }

    @Override
    public INDArray subiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 's');
    }

    @Override
    public INDArray subRowVector(INDArray rowVector) {
        return this.dup().subiRowVector(rowVector);
    }

    @Override
    public INDArray addiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'a');
    }

    @Override
    public INDArray putiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'p');
    }

    @Override
    public INDArray addColumnVector(INDArray columnVector) {
        return this.dup().addiColumnVector(columnVector);
    }

    @Override
    public INDArray addiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'a');
    }

    @Override
    public INDArray putiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 'p');
    }

    @Override
    public INDArray addRowVector(INDArray rowVector) {
        return this.dup().addiRowVector(rowVector);
    }

    @Override
    public INDArray mmul(INDArray other) {
        int[] shape = new int[]{this.rows(), other.columns()};
        INDArray result = Nd4j.createUninitialized(shape, 'f');
        if (result.isScalar()) {
            return Nd4j.scalar(Nd4j.getBlasWrapper().dot(this, other));
        }
        return this.mmuli(other, result);
    }

    protected INDArray create(int[] shape, char ordering) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(shape, ordering);
        }
        return Nd4j.create(shape, ordering);
    }

    @Override
    public INDArray mmul(INDArray other, INDArray result) {
        return this.mmuli(other, result);
    }

    @Override
    public INDArray div(INDArray other) {
        return this.divi(other, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray div(INDArray other, INDArray result) {
        return this.divi(other, result);
    }

    @Override
    public INDArray mul(INDArray other) {
        return this.muli(other, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray mul(INDArray other, INDArray result) {
        return this.muli(other, result);
    }

    @Override
    public INDArray sub(INDArray other) {
        return this.subi(other, Nd4j.createUninitialized(other.shape(), other.ordering()));
    }

    @Override
    public INDArray sub(INDArray other, INDArray result) {
        return this.subi(other, result);
    }

    @Override
    public INDArray add(INDArray other) {
        return this.dup().addi(other);
    }

    @Override
    public INDArray add(INDArray other, INDArray result) {
        return this.dup().addi(other, result);
    }

    @Override
    public INDArray mmuli(INDArray other) {
        return this.dup().mmuli(other, this);
    }

    @Override
    public INDArray mmuli(INDArray other, INDArray result) {
        LinAlgExceptions.assertMultiplies(this, other);
        if (other.isScalar()) {
            return this.muli(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.muli(this.getDouble(0), result);
        }
        if (result == this || result == other) {
            INDArray temp = this.create(result.shape(), Nd4j.getStrides(result.shape(), 'f'));
            temp.setOrder('f');
            if (other.columns() == 1) {
                Nd4j.getBlasWrapper().level2().gemv(BlasBufferUtil.getCharForTranspose(result), BlasBufferUtil.getCharForTranspose(this), 1.0, this, other, 0.0, temp);
            } else {
                Nd4j.getBlasWrapper().level3().gemm(BlasBufferUtil.getCharForTranspose(result), BlasBufferUtil.getCharForTranspose(this), BlasBufferUtil.getCharForTranspose(temp), 1.0, this, other, 0.0, temp);
            }
            result.assign(temp);
        } else {
            boolean requiresTemp = result.ordering() == 'c';
            INDArray gemmResultArr = requiresTemp ? Nd4j.createUninitialized(result.shape(), 'f') : result;
            if (other.columns() == 1) {
                Nd4j.getBlasWrapper().level2().gemv(this.ordering(), BlasBufferUtil.getCharForTranspose(other), 1.0, this, other, 0.0, gemmResultArr);
            } else {
                if (this.isView() && this.isVector()) {
                    return this.dup().mmuli(other, gemmResultArr);
                }
                Nd4j.getBlasWrapper().level3().gemm(this.ordering(), BlasBufferUtil.getCharForTranspose(other), BlasBufferUtil.getCharForTranspose(gemmResultArr), 1.0, this, other, 0.0, gemmResultArr);
            }
            if (requiresTemp) {
                result.assign(gemmResultArr);
            }
        }
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    private INDArray create(int[] shape, int[] stride) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(shape, stride);
        }
        return Nd4j.create(shape, stride);
    }

    @Override
    public INDArray divi(INDArray other) {
        return this.divi(other, (INDArray)this);
    }

    @Override
    public INDArray divi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.divi(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.divi(this.getDouble(0), result);
        }
        LinAlgExceptions.assertSameShape(other, result);
        Nd4j.getExecutioner().exec(new DivOp(this, other, result, this.length()));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray muli(INDArray other) {
        return this.muli(other, (INDArray)this);
    }

    @Override
    public INDArray muli(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.muli(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.muli(this.getDouble(0), result);
        }
        LinAlgExceptions.assertSameShape(other, result);
        Nd4j.getExecutioner().exec(new MulOp(this, other, result, this.length()));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray subi(INDArray other) {
        return this.subi(other, (INDArray)this);
    }

    @Override
    public INDArray subi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return this.subi(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.subi(this.getDouble(0), result);
        }
        LinAlgExceptions.assertSameShape(other, result);
        Nd4j.getExecutioner().exec(new SubOp(this, other, result, this.length()));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray addi(INDArray other) {
        return this.addi(other, (INDArray)this);
    }

    @Override
    public INDArray addi(INDArray other, INDArray result) {
        if (other.isScalar()) {
            return result.addi(other.getDouble(0), result);
        }
        if (this.isScalar()) {
            return other.addi(this.getDouble(0), result);
        }
        LinAlgExceptions.assertSameShape(other, result);
        Nd4j.getExecutioner().exec(new AddOp((INDArray)this, other, result));
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY) {
            Nd4j.clearNans(result);
        }
        return result;
    }

    @Override
    public INDArray normmax(int ... dimension) {
        return Nd4j.getExecutioner().exec(new NormMax(this), dimension);
    }

    @Override
    public INDArray rdiv(INDArray other) {
        return this.dup().rdivi(other);
    }

    @Override
    public INDArray rdivi(INDArray other) {
        return this.rdivi(other, (INDArray)this);
    }

    @Override
    public INDArray rdiv(INDArray other, INDArray result) {
        return this.dup().rdivi(other, result);
    }

    @Override
    public INDArray rdivi(INDArray other, INDArray result) {
        return other.divi(this, result);
    }

    @Override
    public INDArray rsub(INDArray other, INDArray result) {
        return this.dup().rsubi(other, result);
    }

    @Override
    public INDArray rsub(INDArray other) {
        return this.dup().rsubi(other);
    }

    @Override
    public INDArray rsubi(INDArray other) {
        return this.rsubi(other, (INDArray)this);
    }

    @Override
    public INDArray rsubi(INDArray other, INDArray result) {
        return other.subi(this, result);
    }

    @Override
    public INDArray assign(Number value) {
        Nd4j.getExecutioner().exec(new ScalarSet((INDArray)this, value));
        return this;
    }

    @Override
    public INDArray assignIf(INDArray arr, Condition condition) {
        BooleanIndexing.assignIf(this, arr, condition);
        return this;
    }

    @Override
    public INDArray replaceWhere(INDArray arr, Condition condition) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        BooleanIndexing.replaceWhere((INDArray)this, arr, condition);
        return this;
    }

    @Override
    @Deprecated
    public int linearIndex(int i) {
        int idx = i;
        for (int j = 0; j < Shape.rank(this.javaShapeInformation) - 1; ++j) {
            if (this.size(i) == 1) continue;
            idx += i * this.stride(j);
        }
        return Shape.offset(this.javaShapeInformation) + idx;
    }

    @Override
    public INDArray slice(int slice) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        int slices = this.slices();
        if (slice >= slices) {
            throw new IllegalArgumentException("Illegal slice " + slice);
        }
        if (Shape.rank(this.javaShapeInformation) == 0 || this.isRowVector()) {
            if (slice == 0) {
                return this.createScalarForIndex(slice, true);
            }
            if (this.isRowVector()) {
                return this.createScalarForIndex(slice, true);
            }
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (slice < 0) {
            slice += this.rank();
        }
        INDArrayIndex[] indexes = new INDArrayIndex[this.rank()];
        indexes[0] = NDArrayIndex.point(slice);
        for (int i = 1; i < this.rank(); ++i) {
            indexes[i] = NDArrayIndex.all();
        }
        return this.get(indexes);
    }

    protected INDArray createScalarForIndex(int i, boolean applyOffset) {
        return this.create(this.data(), new int[]{1, 1}, new int[]{1, 1}, applyOffset ? (long)(Shape.offset(this.javaShapeInformation) + i) : (long)i);
    }

    protected INDArray createScalar(double d) {
        return Nd4j.scalar(d);
    }

    @Override
    public int getTrailingOnes() {
        int numLeadingOnes = 0;
        for (int i = this.rank() - 1; i > 0; --i) {
            if (this.size(i) != 1) continue;
            ++numLeadingOnes;
        }
        return numLeadingOnes;
    }

    @Override
    public int getLeadingOnes() {
        int numLeadingOnes = 0;
        for (int i = 0; i < this.rank(); ++i) {
            if (this.size(i) != 1) continue;
            ++numLeadingOnes;
        }
        return numLeadingOnes;
    }

    @Override
    public INDArray slice(int slice, int dimension) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        int slices = this.size(dimension);
        if (slice >= slices) {
            throw new IllegalArgumentException("Illegal slice " + slice);
        }
        if (Shape.rank(this.javaShapeInformation) == 0) {
            if (slice == 0) {
                return this.createScalarForIndex(slice, true);
            }
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (slice < 0) {
            slice += this.rank();
        }
        INDArrayIndex[] indexes = new INDArrayIndex[this.rank()];
        indexes[dimension] = NDArrayIndex.point(slice);
        for (int i = 0; i < this.rank(); ++i) {
            if (i == dimension) continue;
            indexes[i] = NDArrayIndex.all();
        }
        return this.get(indexes);
    }

    @Override
    public INDArray getScalar(int ... indexes) {
        return Nd4j.scalar(this.getDouble(indexes));
    }

    @Override
    public INDArray rdiv(Number n) {
        return this.rdivi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray rdivi(Number n) {
        return this.rdivi(n, (INDArray)this);
    }

    @Override
    public INDArray rsub(Number n) {
        return this.rsubi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray rsubi(Number n) {
        return this.rsubi(n, (INDArray)this);
    }

    @Override
    public INDArray div(Number n) {
        return this.divi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray divi(Number n) {
        return this.divi(n, (INDArray)this);
    }

    @Override
    public INDArray mul(Number n) {
        return this.muli(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray muli(Number n) {
        return this.muli(n, (INDArray)this);
    }

    @Override
    public INDArray sub(Number n) {
        return this.subi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray subi(Number n) {
        return this.subi(n, (INDArray)this);
    }

    @Override
    public INDArray add(Number n) {
        return this.addi(n, Nd4j.createUninitialized(this.shape(), this.ordering()));
    }

    @Override
    public INDArray addi(Number n) {
        return this.addi(n, (INDArray)this);
    }

    @Override
    public INDArray repmat(int[] shape) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        int rows = this.rows() * shape[0];
        int cols = this.columns() * shape[1];
        INDArray ret = this.reshape(1, this.length()).repeat(0, shape[0]).reshape(rows, this.columns()).repeat(0, shape[1]);
        return ret.reshape(rows, cols);
    }

    @Override
    public INDArray repeat(int dimension, int ... repeats) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (dimension < 0) {
            dimension += this.rank();
        }
        if (repeats.length < this.rank()) {
            repeats = dimension > 0 ? Ints.concat((int[][])new int[][]{ArrayUtil.nTimes((int)(this.rank() - repeats.length), (int)1), repeats}) : Ints.concat((int[][])new int[][]{repeats, ArrayUtil.nTimes((int)(this.rank() - repeats.length), (int)1)});
        }
        int[] newShape = new int[this.rank()];
        for (int i = 0; i < newShape.length; ++i) {
            newShape[i] = this.size(i) * repeats[i];
        }
        INDArray ret = this.create(newShape);
        int repeatDelta = ArrayUtil.prod((int[])newShape) / this.length();
        for (int i = 0; i < this.tensorssAlongDimension(dimension); ++i) {
            INDArray thisTensor = this.tensorAlongDimension(i, dimension);
            INDArray retTensor = ret.tensorAlongDimension(i, dimension);
            int retIdx = 0;
            for (int k = 0; k < thisTensor.length(); ++k) {
                for (int j = 0; j < repeatDelta; ++j) {
                    retTensor.putScalar(retIdx++, thisTensor.getDouble(k));
                }
            }
        }
        return ret;
    }

    @Override
    public INDArray putRow(int row, INDArray toPut) {
        if (this.isRowVector() && toPut.isVector()) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.point(row), NDArrayIndex.all()}, toPut);
    }

    @Override
    public INDArray putColumn(int column, INDArray toPut) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isColumnVector() && toPut.isVector()) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.point(column)}, toPut);
    }

    @Override
    public double getDouble(int i) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (i >= this.length()) {
            throw new IllegalArgumentException("Unable to get linear index >= " + this.length());
        }
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED) {
            OpProfiler.getInstance().processScalarCall();
        }
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (i == 0) {
            return this.data().getDouble((long)i);
        }
        int[] dimensions = this.ordering() == 'c' ? Shape.ind2subC(this, (long)i) : Shape.ind2sub(this, (long)i);
        Shape.assertShapeLessThan(dimensions, this.shape());
        return this.getDouble(dimensions);
    }

    @Override
    public double getDouble(int i, int j) {
        return this.getDouble(new int[]{i, j});
    }

    @Override
    public float getFloat(int i) {
        return (float)this.getDouble(i);
    }

    @Override
    public float getFloat(int i, int j) {
        return (float)this.getDouble(i, j);
    }

    @Override
    public INDArray transpose() {
        return this.transposei();
    }

    @Override
    public INDArray transposei() {
        return this.permute(ArrayUtil.reverseCopy((int[])ArrayUtil.range((int)0, (int)this.rank())));
    }

    protected INDArray create(DataBuffer data, int[] shape, int[] strides) {
        if (this instanceof IComplexNDArray) {
            return Nd4j.createComplex(data, shape, strides, 0L, this.ordering());
        }
        return Nd4j.create(data, shape, strides, 0L, this.ordering());
    }

    @Override
    public INDArray reshape(char order, int ... newShape) {
        INDArray reshapeAttempt;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (newShape == null || newShape.length < 2) {
            throw new ND4JIllegalStateException("Can't reshape(int...) without shape arguments. Got empty shape instead.");
        }
        int numberNegativesOnes = 0;
        int[] shape = ArrayUtil.copy((int[])newShape);
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 0) continue;
            if (numberNegativesOnes >= 1) {
                throw new IllegalArgumentException("Only one dimension can be negative ones");
            }
            ++numberNegativesOnes;
            int shapeLength = 1;
            for (int j = 0; j < shape.length; ++j) {
                if (shape[j] < 1) continue;
                shapeLength *= shape[j];
            }
            int realShape = Math.abs(this.length() / shapeLength);
            int[] thisNewShape = new int[shape.length];
            for (int j = 0; j < shape.length; ++j) {
                thisNewShape[j] = i != j ? shape[j] : realShape;
            }
            shape = thisNewShape;
            break;
        }
        if ((reshapeAttempt = Shape.newShapeNoCopy(this, shape, order == 'f')) != null) {
            return reshapeAttempt;
        }
        INDArray ret = Nd4j.createUninitialized(shape, order);
        if (order != this.ordering()) {
            ret.setData(this.dup(order).data());
        } else {
            ret.assign(this);
        }
        return ret;
    }

    @Override
    public double getDoubleUnsafe(long offset) {
        return this.data().getDouble(offset);
    }

    @Override
    public INDArray putScalarUnsafe(long offset, double value) {
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED) {
            OpProfiler.getInstance().processScalarCall();
        }
        this.data().put(offset, value);
        return this;
    }

    @Override
    public int innerMostStride() {
        if (this.ordering() == 'c') {
            return this.stride(-1);
        }
        return this.stride(0);
    }

    @Override
    public INDArray reshape(char order, int rows, int columns) {
        return this.reshape(order, new int[]{rows, columns});
    }

    @Override
    public INDArray reshape(int ... shape) {
        return this.reshape(Nd4j.order().charValue(), shape);
    }

    @Override
    public void checkDimensions(INDArray other) {
        assert (Shape.contentEquals(other.shape(), Shape.shapeOf(this.shapeInformation))) : " Other array should have been shape: " + Shape.toString(Shape.shapeOf(this.shapeInformation)) + " but was " + Arrays.toString(other.shape());
        assert (Shape.contentEquals(other.stride(), Shape.stride(this.shapeInformation))) : " Other array should have been stride: " + Shape.toString(Shape.stride(this.shapeInformation)) + " but was " + Arrays.toString(other.stride());
        assert ((long)Shape.offset(this.javaShapeInformation) == other.offset()) : "Offset of this array is " + Shape.offset(this.javaShapeInformation) + " but other was " + other.offset();
    }

    @Override
    public INDArray prod(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Prod(this), dimension);
    }

    @Override
    public INDArray mean(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Mean(this), dimension);
    }

    @Override
    public INDArray amean(int ... dimension) {
        return Nd4j.getExecutioner().exec(new AMean(this), dimension);
    }

    @Override
    public INDArray mean(INDArray result, int ... dimension) {
        return Nd4j.getExecutioner().exec(new Mean((INDArray)this, null, result), dimension);
    }

    @Override
    public INDArray var(int ... dimension) {
        return Nd4j.getExecutioner().exec((Accumulation)new Variance(this), dimension);
    }

    @Override
    public INDArray var(boolean biasCorrected, int ... dimension) {
        return Nd4j.getExecutioner().exec((Accumulation)new Variance((INDArray)this, biasCorrected), dimension);
    }

    @Override
    public INDArray max(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Max(this), dimension);
    }

    @Override
    public INDArray amax(int ... dimension) {
        return Nd4j.getExecutioner().exec(new AMax(this), dimension);
    }

    @Override
    public INDArray min(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Min(this), dimension);
    }

    @Override
    public INDArray amin(int ... dimension) {
        return Nd4j.getExecutioner().exec(new AMin(this), dimension);
    }

    @Override
    public INDArray sum(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Sum(this), dimension);
    }

    @Override
    public INDArray entropy(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Entropy(this), dimension);
    }

    @Override
    public INDArray shannonEntropy(int ... dimension) {
        return Nd4j.getExecutioner().exec(new ShannonEntropy(this), dimension);
    }

    @Override
    public INDArray logEntropy(int ... dimension) {
        return Nd4j.getExecutioner().exec(new LogEntropy(this), dimension);
    }

    @Override
    public INDArray sum(INDArray result, int ... dimension) {
        return Nd4j.getExecutioner().exec(new Sum((INDArray)this, null, result), dimension);
    }

    @Override
    public INDArray norm1(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Norm1(this), dimension);
    }

    @Override
    public INDArray std(int ... dimension) {
        return Nd4j.getExecutioner().exec((Accumulation)new StandardDeviation(this), dimension);
    }

    @Override
    public INDArray std(boolean biasCorrected, int ... dimension) {
        return Nd4j.getExecutioner().exec((Accumulation)new StandardDeviation((INDArray)this, biasCorrected), dimension);
    }

    @Override
    public Number stdNumber(boolean biasCorrected) {
        return Nd4j.getExecutioner().exec((Accumulation)new StandardDeviation((INDArray)this, biasCorrected), Integer.MAX_VALUE).getDouble(0);
    }

    @Override
    public INDArray norm2(int ... dimension) {
        return Nd4j.getExecutioner().exec(new Norm2(this), dimension);
    }

    @Override
    public int columns() {
        if (this.isMatrix()) {
            return this.size(1);
        }
        if (Shape.isColumnVectorShape(this.shape())) {
            return 1;
        }
        if (Shape.isRowVectorShape(this.shape())) {
            return this.length();
        }
        throw new IllegalStateException("Rank is " + this.rank() + " columns() call is not valid");
    }

    @Override
    public int rows() {
        if (this.isMatrix()) {
            return this.size(0);
        }
        if (Shape.isRowVectorShape(this.shape())) {
            return 1;
        }
        if (Shape.isColumnVectorShape(this.shape())) {
            return this.length();
        }
        throw new IllegalStateException("Rank is " + this.rank() + " rows() call is not valid");
    }

    @Override
    public INDArray ravel(char ordering) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length can not be >= Integer.MAX_VALUE");
        }
        INDArray ret = this.create(new int[]{1, this.length()}, ordering);
        NDArrayIndex index = new NDArrayIndex(this.shape());
        int i = 0;
        while (i < this.length()) {
            double val = this.getDouble((int)index.next());
            ret.putScalar(new int[]{0, i++}, val);
        }
        return ret;
    }

    @Override
    public INDArray ravel() {
        return this.reshape(1, this.length());
    }

    @Override
    public void sliceVectors(List<INDArray> list) {
        if (this.isVector()) {
            list.add(this);
        } else {
            for (int i = 0; i < this.slices(); ++i) {
                this.slice(i).sliceVectors(list);
            }
        }
    }

    @Override
    public INDArray reshape(int newRows, int newColumns) {
        return this.reshape(new int[]{newRows, newColumns});
    }

    @Override
    public INDArray getColumn(int c) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (this.isColumnVector() && c == 0) {
            return this;
        }
        if (this.isColumnVector() && c > 0) {
            throw new IllegalArgumentException("Illegal index for row");
        }
        return this.get(NDArrayIndex.all(), NDArrayIndex.point(c));
    }

    @Override
    public INDArray getRows(int[] rindices) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (!this.isMatrix() && !this.isVector()) {
            throw new IllegalArgumentException("Unable to get columns from a non matrix or vector");
        }
        if (this.isVector()) {
            return Nd4j.pullRows(this, 1, rindices);
        }
        INDArray ret = Nd4j.create(rindices.length, this.columns());
        for (int i = 0; i < rindices.length; ++i) {
            ret.putRow(i, this.getRow(rindices[i]));
        }
        return ret;
    }

    @Override
    public INDArray get(INDArrayIndex ... indexes) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (indexes.length > this.rank()) {
            int numNonNewAxis = 0;
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] instanceof NewAxis) continue;
                ++numNonNewAxis;
            }
            if (numNonNewAxis > this.rank()) {
                throw new IllegalArgumentException("Too many indices for array. Number of indexes must be <= rank()");
            }
        }
        if (indexes.length == 1 && indexes[0] instanceof NDArrayIndexAll || indexes.length == 2 && (this.isRowVector() && indexes[0] instanceof PointIndex && indexes[0].offset() == 0L && indexes[1] instanceof NDArrayIndexAll || this.isColumnVector() && indexes[1] instanceof PointIndex && indexes[0].offset() == 0L && indexes[0] instanceof NDArrayIndexAll)) {
            return this;
        }
        indexes = NDArrayIndex.resolve(this.shapeInfoDataBuffer(), indexes);
        ShapeOffsetResolution resolution = new ShapeOffsetResolution(this);
        resolution.exec(indexes);
        if (indexes.length < 1) {
            throw new IllegalStateException("Invalid index found of zero length");
        }
        int[] shape = LongUtils.toInts(resolution.getShapes());
        int numSpecifiedIndex = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (!(indexes[i] instanceof SpecifiedIndex)) continue;
            ++numSpecifiedIndex;
        }
        if (shape != null && numSpecifiedIndex > 0) {
            Generator<List<List<Long>>> gen = SpecifiedIndex.iterate(indexes);
            INDArray ret = Nd4j.create(shape, 'c');
            int count = 0;
            do {
                try {
                    List next = (List)gen.next();
                    ArrayList coordsCombo = new ArrayList();
                    for (int i = 0; i < next.size(); ++i) {
                        if (((List)next.get(i)).size() > 1) {
                            throw new IllegalStateException("Illegal entry returned");
                        }
                        coordsCombo.add(((List)next.get(i)).get(0));
                    }
                    ret.putScalar(count++, this.getDouble(Ints.toArray(coordsCombo)));
                }
                catch (NoSuchElementException e) {
                    break;
                }
            } while (count < ret.length());
            return ret;
        }
        INDArray ret = this.subArray(resolution);
        return ret;
    }

    @Override
    public INDArray getColumns(int ... cindices) {
        if (!this.isMatrix() && !this.isVector()) {
            throw new IllegalArgumentException("Unable to get columns from a non matrix or vector");
        }
        if (this.isVector()) {
            return Nd4j.pullRows(this, 0, cindices, this.ordering());
        }
        INDArray ret = Nd4j.create(this.rows(), cindices.length);
        for (int i = 0; i < cindices.length; ++i) {
            ret.putColumn(i, this.getColumn(cindices[i]));
        }
        return ret;
    }

    protected INDArray create(int rows, int length) {
        return this.create(new int[]{rows, length});
    }

    @Override
    public INDArray getRow(int r) {
        if (this.isRowVector() && r == 0) {
            return this;
        }
        if (this.isRowVector() && r > 0) {
            throw new IllegalArgumentException("Illegal index for row");
        }
        INDArray result = this.get(NDArrayIndex.point(r), NDArrayIndex.all());
        if (!this.isView() && this.ordering() == 'c' && result.elementWiseStride() == 1 && result.ordering() != 'c') {
            ((BaseNDArray)result).setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(result.shape(), result.stride(), 0L, 1, 'c'));
        }
        return result;
    }

    @Override
    public boolean equalsWithEps(Object o, double eps) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (o == null) {
            return false;
        }
        if (!(o instanceof INDArray)) {
            return false;
        }
        INDArray n = (INDArray)o;
        if (this.lengthLong() != n.lengthLong()) {
            return false;
        }
        if (this.isScalar() && n.isScalar()) {
            if (this.data.dataType() == DataBuffer.Type.FLOAT) {
                double val = this.getDouble(0);
                double val2 = n.getDouble(0);
                if (Double.isNaN(val) != Double.isNaN(val2)) {
                    return false;
                }
                return Math.abs(val - val2) < eps;
            }
            double val = this.getDouble(0);
            double val2 = n.getDouble(0);
            if (Double.isNaN(val) != Double.isNaN(val2)) {
                return false;
            }
            return Math.abs(val - val2) < eps;
        }
        if (this.isVector() && n.isVector()) {
            EqualsWithEps op = new EqualsWithEps((INDArray)this, n, eps);
            Nd4j.getExecutioner().exec(op);
            double diff = op.getFinalResult().doubleValue();
            return diff < 0.5;
        }
        if (!Arrays.equals(this.shape(), n.shape())) {
            return false;
        }
        if (!Shape.shapeEquals(this.shape(), n.shape())) {
            return false;
        }
        if (this.slices() != n.slices()) {
            return false;
        }
        if (n.ordering() == this.ordering()) {
            EqualsWithEps op = new EqualsWithEps((INDArray)this, n, eps);
            Nd4j.getExecutioner().exec(op);
            double diff = op.getFinalResult().doubleValue();
            return diff < 0.5;
        }
        EqualsWithEps op = new EqualsWithEps((INDArray)this, n, eps);
        Nd4j.getExecutioner().exec(op);
        double diff = op.getFinalResult().doubleValue();
        return diff < 0.5;
    }

    public boolean equals(Object o) {
        return this.equalsWithEps(o, Nd4j.EPS_THRESHOLD);
    }

    @Override
    public DataBuffer shapeInfoDataBuffer() {
        return this.shapeInformation;
    }

    @Override
    public IntBuffer shapeInfo() {
        return this.shapeInformation.asNioInt();
    }

    @Override
    public int[] shape() {
        return Shape.shape(this.javaShapeInformation);
    }

    @Override
    public String shapeInfoToString() {
        return Shape.shapeToString(this);
    }

    @Override
    public int[] stride() {
        return Shape.stride(this.javaShapeInformation);
    }

    @Override
    public long offset() {
        if (this.data().offset() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset of buffer can not be >= Integer.MAX_VALUE");
        }
        return this.data().offset();
    }

    @Override
    public char ordering() {
        return Shape.order(this.javaShapeInformation);
    }

    @Override
    public int size(int dimension) {
        if (this.isScalar()) {
            if (dimension == 0 || dimension == 1 || dimension < 0) {
                return (int)this.lengthLong();
            }
            throw new IllegalArgumentException("Illegal dimension for scalar " + dimension);
        }
        if (dimension < 0) {
            return this.shapeOf().getInt((long)(dimension + Shape.rank(this.javaShapeInformation)));
        }
        if (dimension >= this.rank()) {
            throw new IllegalArgumentException("Invalid size: cannot get size of dimension " + dimension + " for rank " + this.rank() + " NDArray (array shape: " + Arrays.toString(this.shape()) + ")");
        }
        return this.shapeOf().getInt((long)dimension);
    }

    @Override
    public int rank() {
        return Shape.rank(this.javaShapeInformation);
    }

    @Override
    public int length() {
        return Shape.length(this.shapeInformation);
    }

    @Override
    public long lengthLong() {
        return Shape.length(this.shapeInformation);
    }

    @Override
    public INDArray broadcast(int ... shape) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (Shape.shapeEquals(shape, this.shape())) {
            return this;
        }
        if (this.isScalar()) {
            return Nd4j.createUninitialized(shape).assign(this.getDouble(0));
        }
        boolean compatible = true;
        int count = shape.length - 1;
        int thisCount = Shape.rank(this.javaShapeInformation) - 1;
        for (int i = shape.length - 1; i > 0 && count >= 0 && thisCount >= 0; --count, --thisCount, --i) {
            if (shape[count] == this.shape()[thisCount] || shape[count] == 1 || this.shape()[thisCount] == 1) continue;
            compatible = false;
            break;
        }
        if (!compatible) {
            throw new IllegalArgumentException("Incompatible broadcast from " + Arrays.toString(this.shape()) + " to " + Arrays.toString(shape));
        }
        int[] retShape = new int[shape.length];
        ArrayList<Integer> broadCastDimensions = new ArrayList<Integer>();
        ArrayList<Integer> nonBroadCastDimensions = new ArrayList<Integer>();
        for (int i = 0; i < retShape.length; ++i) {
            if (this.shape().length == 1) {
                if (i == 0) {
                    if (i < this.shape().length) {
                        retShape[i] = Math.max(1, shape[i]);
                        continue;
                    }
                    retShape[i] = shape[i];
                    continue;
                }
                if (i < this.shape().length) {
                    retShape[i] = Math.max(shape[i], this.size(i));
                    continue;
                }
                retShape[i] = shape[i];
                continue;
            }
            if (i < this.rank() && this.size(i) == 1) {
                broadCastDimensions.add(i);
            } else {
                nonBroadCastDimensions.add(i);
            }
            retShape[i] = i < this.shape().length ? Math.max(shape[i], this.size(i)) : shape[i];
        }
        INDArray ret = this.create(retShape, this.ordering());
        if (this.isRowVector()) {
            for (int i = 0; i < ret.slices(); ++i) {
                ret.putSlice(i, this);
            }
        } else if (this.isColumnVector()) {
            for (int i = 0; i < ret.columns(); ++i) {
                ret.putColumn(i, this);
            }
        } else {
            int idx = 0;
            for (int i = 0; i < ret.length(); ++i) {
                ret.putScalar(i, this.getDouble(idx));
                if (idx < this.length()) continue;
                idx = 0;
            }
        }
        return ret;
    }

    @Override
    public INDArray dimShuffle(Object[] rearrange, int[] newOrder, boolean[] broadCastable) {
        int i;
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (broadCastable.length != Shape.rank(this.javaShapeInformation)) {
            throw new IllegalArgumentException("The broadcastable dimensions must be the same length as the current shape");
        }
        boolean broadcast = false;
        HashSet<Object> set = new HashSet<Object>();
        for (int i2 = 0; i2 < rearrange.length; ++i2) {
            set.add(rearrange[i2]);
            if (rearrange[i2] instanceof Integer) {
                Integer j = (Integer)rearrange[i2];
                if (j < broadCastable.length) continue;
                throw new IllegalArgumentException("Illegal dimension, dimension must be < broadcastable.length (aka the real dimensions");
            }
            if (rearrange[i2] instanceof Character) {
                Character c = (Character)rearrange[i2];
                if (c.charValue() != 'x') {
                    throw new IllegalArgumentException("Illegal input: Must be x");
                }
                broadcast = true;
                continue;
            }
            throw new IllegalArgumentException("Only characters and integers allowed");
        }
        if (!broadcast) {
            int[] ret = new int[rearrange.length];
            for (int i3 = 0; i3 < ret.length; ++i3) {
                ret[i3] = (Integer)rearrange[i3];
            }
            return this.permute(ret);
        }
        ArrayList<Integer> drop = new ArrayList<Integer>();
        for (int i4 = 0; i4 < broadCastable.length; ++i4) {
            if (set.contains(i4)) continue;
            if (broadCastable[i4]) {
                drop.add(i4);
                continue;
            }
            throw new IllegalArgumentException("We can't drop the given dimension because its not broadcastable");
        }
        int[] shuffle = new int[broadCastable.length];
        int count = 0;
        for (int i5 = 0; i5 < rearrange.length; ++i5) {
            if (!(rearrange[i5] instanceof Integer)) continue;
            shuffle[count++] = (Integer)rearrange[i5];
        }
        ArrayList<Integer> augment = new ArrayList<Integer>();
        for (int i6 = 0; i6 < rearrange.length; ++i6) {
            if (!(rearrange[i6] instanceof Character)) continue;
            augment.add(i6);
        }
        Integer[] augmentDims = augment.toArray(new Integer[1]);
        count = 0;
        int dropIdx = 0;
        int[] newShape = new int[shuffle.length + drop.size()];
        for (int i7 = 0; i7 < newShape.length; ++i7) {
            if (i7 < shuffle.length) {
                newShape[count++] = shuffle[i7];
                continue;
            }
            newShape[count++] = (Integer)drop.get(dropIdx++);
        }
        INDArray ret = this.permute(newShape);
        ArrayList<Integer> newDims = new ArrayList<Integer>();
        int[] shape = Arrays.copyOfRange(ret.shape(), 0, shuffle.length);
        for (i = 0; i < shape.length; ++i) {
            newDims.add(shape[i]);
        }
        for (i = 0; i < augmentDims.length; ++i) {
            newDims.add(augmentDims[i], 1);
        }
        int[] toReshape = ArrayUtil.toArray(newDims);
        ret = ret.reshape(toReshape);
        return ret;
    }

    @Override
    public INDArray permute(int ... rearrange) {
        Nd4j.getCompressor().autoDecompress((INDArray)this);
        if (rearrange.length != this.rank()) {
            return this.dup();
        }
        boolean alreadyInOrder = true;
        int rank = Shape.rank(this.javaShapeInformation);
        for (int i = 0; i < rank; ++i) {
            if (rearrange[i] == i) continue;
            alreadyInOrder = false;
            break;
        }
        if (alreadyInOrder) {
            return this;
        }
        this.checkArrangeArray(rearrange);
        int[] newShape = this.doPermuteSwap(this.shapeOf(), rearrange);
        int[] newStride = this.doPermuteSwap(this.strideOf(), rearrange);
        char newOrder = Shape.getOrder(newShape, newStride, this.elementStride());
        INDArray value = this.create(this.data(), newShape, newStride, this.offset(), newOrder);
        return value;
    }

    @Override
    public INDArray permutei(int ... rearrange) {
        boolean alreadyInOrder = true;
        IntBuffer shapeInfo = this.shapeInfo();
        int rank = Shape.rank(this.javaShapeInformation);
        for (int i = 0; i < rank; ++i) {
            if (rearrange[i] == i) continue;
            alreadyInOrder = false;
            break;
        }
        if (alreadyInOrder) {
            return this;
        }
        this.checkArrangeArray(rearrange);
        int[] newShape = this.doPermuteSwap(Shape.shapeOf(shapeInfo), rearrange);
        int[] newStride = this.doPermuteSwap(Shape.stride(shapeInfo), rearrange);
        char newOrder = Shape.getOrder(newShape, newStride, this.elementStride());
        int ews = shapeInfo.get(2 * rank + 2);
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(newShape, newStride, this.offset(), ews, newOrder));
        if (shapeInfo.get(2 * rank + 2) > 0) {
            this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(newShape, newStride, this.offset(), -1, newOrder));
        }
        return this;
    }

    protected int[] doPermuteSwap(IntBuffer shape, int[] rearrange) {
        int[] ret = new int[rearrange.length];
        for (int i = 0; i < rearrange.length; ++i) {
            ret[i] = shape.get(rearrange[i]);
        }
        return ret;
    }

    protected int[] doPermuteSwap(DataBuffer shape, int[] rearrange) {
        int[] ret = new int[rearrange.length];
        for (int i = 0; i < rearrange.length; ++i) {
            ret[i] = shape.getInt((long)rearrange[i]);
        }
        return ret;
    }

    protected void checkArrangeArray(int[] arr) {
        int i;
        assert (arr.length == Shape.rank(this.javaShapeInformation)) : "Invalid rearrangement: number of arrangement != shape";
        for (i = 0; i < arr.length; ++i) {
            if (arr[i] >= arr.length) {
                throw new IllegalArgumentException("The specified dimensions can't be swapped. Given element " + i + " was >= number of dimensions");
            }
            if (arr[i] >= 0) continue;
            throw new IllegalArgumentException("Invalid dimension: " + i + " : negative value");
        }
        for (i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr.length; ++j) {
                if (i == j || arr[i] != arr[j]) continue;
                throw new IllegalArgumentException("Permute array must have unique elements");
            }
        }
    }

    @Override
    public boolean isVector() {
        return this.isRowVector() || this.isColumnVector();
    }

    @Override
    public boolean isSquare() {
        return this.isMatrix() && this.rows() == this.columns();
    }

    @Override
    public boolean isRowVector() {
        return this.rank() == 2 && this.rows() == 1;
    }

    @Override
    public boolean isColumnVector() {
        return this.rank() == 2 && this.columns() == 1;
    }

    public String toString() {
        if (!this.isCompressed() && !Nd4j.preventUnpack) {
            return new NDArrayStrings().format(this);
        }
        if (this.isCompressed() && Nd4j.compressDebug) {
            return "COMPRESSED ARRAY. SYSTEM PROPERTY compressdebug is true. This is to prevent auto decompression from being triggered.";
        }
        if (Nd4j.preventUnpack) {
            return "Array string unpacking is disabled.";
        }
        return new NDArrayStrings().format(this);
    }

    @Override
    public Object element() {
        if (!this.isScalar()) {
            throw new IllegalStateException("Unable to retrieve element from non scalar matrix");
        }
        if (this.data.dataType() == DataBuffer.Type.FLOAT) {
            return Float.valueOf(this.data.getFloat(0L));
        }
        return this.data.getDouble(0L);
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n) {
        return this.dup().rdivi(n);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n) {
        return this.rdivi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n) {
        return this.dup().rsubi(n);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n) {
        return this.rsubi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray div(IComplexNumber n) {
        return this.dup().divi(n);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n) {
        return this.divi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n) {
        return this.muli(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n) {
        return this.subi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray add(IComplexNumber n) {
        return this.dup().addi(n);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n) {
        return this.addi(n, Nd4j.createComplex(this.shape()));
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n, IComplexNDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).rdivi(n, result);
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n, IComplexNDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).rsubi(n, result);
    }

    @Override
    public IComplexNDArray div(IComplexNumber n, IComplexNDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).divi(n, result);
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n, IComplexNDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).muli(n, result);
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n, IComplexNDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).subi(n, result);
    }

    @Override
    public IComplexNDArray add(IComplexNumber n, IComplexNDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, IComplexNDArray result) {
        return Nd4j.createComplex(this).addi(n, result);
    }

    protected INDArray create(BaseNDArray baseNDArray) {
        return baseNDArray;
    }

    @Override
    public INDArray remainder(INDArray denominator) {
        return this.remainder(denominator, Nd4j.createUninitialized(this.shape()));
    }

    @Override
    public INDArray remainder(INDArray denominator, INDArray result) {
        RemainderOp op = new RemainderOp((INDArray)this, denominator, result);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray remainder(Number denominator) {
        return this.remainder(denominator, Nd4j.createUninitialized(this.shape()));
    }

    @Override
    public INDArray remainder(Number denominator, INDArray result) {
        ScalarRemainder op = new ScalarRemainder((INDArray)this, null, result, (long)this.length(), denominator);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray remainderi(INDArray denominator) {
        RemainderOp op = new RemainderOp((INDArray)this, denominator, this);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    @Override
    public INDArray remainderi(Number denominator) {
        ScalarRemainder op = new ScalarRemainder((INDArray)this, null, (INDArray)this, (long)this.length(), denominator);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    @Override
    public INDArray fmod(INDArray denominator) {
        return this.fmod(denominator, Nd4j.createUninitialized(this.shape()));
    }

    @Override
    public INDArray fmod(INDArray denominator, INDArray result) {
        FModOp op = new FModOp((INDArray)this, denominator, result);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray fmod(Number denominator) {
        return this.fmod(denominator, Nd4j.createUninitialized(this.shape()));
    }

    @Override
    public INDArray fmod(Number denominator, INDArray result) {
        ScalarFMod op = new ScalarFMod((INDArray)this, null, result, (long)this.length(), denominator);
        Nd4j.getExecutioner().exec(op);
        return result;
    }

    @Override
    public INDArray fmodi(INDArray denominator) {
        FModOp op = new FModOp((INDArray)this, denominator, this);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    @Override
    public INDArray fmodi(Number denominator) {
        ScalarFMod op = new ScalarFMod((INDArray)this, null, (INDArray)this, (long)this.length(), denominator);
        Nd4j.getExecutioner().exec(op);
        return this;
    }

    public Iterator<Object> iterator() {
        return new FirstAxisIterator(this);
    }

    @Override
    public long originalOffset() {
        if (this.data().originalOffset() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Original offset of buffer can not be >= Integer.MAX_VALUE");
        }
        return this.data().originalOffset();
    }

    private void readObject(ObjectInputStream s) {
        try {
            s.defaultReadObject();
            this.read(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.write(out);
    }

    protected void write(ObjectOutputStream out) throws IOException {
        if (this.isView()) {
            INDArray copy = this.dup();
            copy.shapeInfoDataBuffer().write((OutputStream)out);
            copy.data().write((OutputStream)out);
        } else {
            this.shapeInformation.write((OutputStream)out);
            this.data().write((OutputStream)out);
        }
    }

    protected void read(ObjectInputStream s) {
        this.shapeInformation = Nd4j.createBuffer(new int[Shape.shapeInfoLength(this.rank())], 0L);
        this.shapeInformation.read((InputStream)s);
        this.setShapeInformation((Pair<DataBuffer, int[]>)Pair.create((Object)this.shapeInformation, (Object)this.shapeInformation.asInt()));
        this.data = Nd4j.createBuffer((long)this.length(), false);
        this.data().read((InputStream)s);
    }

    @Override
    public INDArray argMax(int ... dimension) {
        return Nd4j.argMax(this, dimension);
    }

    @Override
    public boolean isAttached() {
        return this.data.isAttached();
    }

    @Override
    public boolean isInScope() {
        if (!this.isAttached()) {
            return true;
        }
        return this.data.isInScope();
    }

    @Override
    public INDArray detach() {
        if (!this.isAttached()) {
            return this;
        }
        Nd4j.getExecutioner().commit();
        if (Nd4j.getMemoryManager().getCurrentWorkspace() == null) {
            DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            return Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        }
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        Nd4j.getMemoryManager().setCurrentWorkspace(null);
        DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
        Nd4j.getMemoryManager().memcpy(buffer, this.data());
        INDArray copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        Nd4j.getMemoryManager().setCurrentWorkspace(workspace);
        return copy;
    }

    @Override
    public INDArray leverage() {
        if (!this.isAttached()) {
            return this;
        }
        MemoryWorkspace workspace = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (workspace == null) {
            return this.detach();
        }
        MemoryWorkspace parentWorkspace = workspace.getParentWorkspace();
        if (this.data.getParentWorkspace() == parentWorkspace) {
            return this;
        }
        if (parentWorkspace == null) {
            return this.detach();
        }
        Nd4j.getExecutioner().commit();
        Nd4j.getMemoryManager().setCurrentWorkspace(parentWorkspace);
        INDArray copy = null;
        if (!this.isView()) {
            DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = this.dup(this.ordering());
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(workspace);
        return copy;
    }

    @Override
    public INDArray leverageTo(String id) {
        MemoryWorkspace target;
        if (!this.isAttached()) {
            return this;
        }
        if (!Nd4j.getWorkspaceManager().checkIfWorkspaceExists(id)) {
            return this;
        }
        MemoryWorkspace current = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (current == (target = Nd4j.getWorkspaceManager().getWorkspaceForCurrentThread(id))) {
            return this;
        }
        if (this.data.getParentWorkspace() == target) {
            return this;
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(target);
        INDArray copy = null;
        if (!this.isView()) {
            DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = this.dup(this.ordering());
        }
        Nd4j.getMemoryManager().setCurrentWorkspace(current);
        return copy;
    }

    @Override
    public INDArray migrate() {
        MemoryWorkspace current = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (current == null) {
            return this;
        }
        INDArray copy = null;
        if (!this.isView()) {
            DataBuffer buffer = Nd4j.createBuffer(this.lengthLong(), false);
            Nd4j.getMemoryManager().memcpy(buffer, this.data());
            copy = Nd4j.createArrayFromShapeBuffer(buffer, this.shapeInfoDataBuffer());
        } else {
            copy = this.dup(this.ordering());
        }
        return copy;
    }

    @Override
    public Number percentileNumber(Number quantile) {
        if (quantile.intValue() < 0 || quantile.intValue() > 100) {
            throw new ND4JIllegalStateException("Percentile value should be in 0...100 range");
        }
        if (this.isScalar()) {
            return this.getDouble(0);
        }
        INDArray sorted = Nd4j.sort(this.dup(this.ordering()), true);
        return this.getPercentile(quantile, sorted);
    }

    @Override
    public Number medianNumber() {
        return this.percentileNumber(50);
    }

    @Override
    public INDArray median(int ... dimension) {
        return this.percentile(50, dimension);
    }

    protected double getPercentile(Number quantile, INDArray sorted) {
        if (quantile.intValue() == 0) {
            return sorted.getDouble(0);
        }
        if (quantile.intValue() == 100) {
            return sorted.getDouble(sorted.length() - 1);
        }
        double pos = quantile.doubleValue() / 100.0 * (double)(sorted.length() + 1);
        double fposition = FastMath.floor((double)pos);
        int position = (int)fposition;
        double diff = pos - fposition;
        double lower = sorted.getDouble(position - 1);
        double upper = sorted.getDouble(position);
        return lower + diff * (upper - lower);
    }

    @Override
    public INDArray percentile(Number quantile, int ... dimension) {
        if (quantile.doubleValue() < 0.0 || quantile.doubleValue() > 100.0) {
            throw new ND4JIllegalStateException("Percentile value should be in 0...100 range");
        }
        if (this.isScalar()) {
            return Nd4j.scalar(this.getDouble(0));
        }
        INDArray sorted = Nd4j.getNDArrayFactory().sort(this.dup(this.ordering()), false, dimension);
        INDArray ret = Nd4j.createUninitialized(sorted.tensorssAlongDimension(dimension));
        for (int i = 0; i < ret.length(); ++i) {
            ret.putScalar(i, this.getPercentile(quantile, sorted.tensorAlongDimension(i, dimension)));
        }
        return ret;
    }

    static {
        BaseNDArray.tadFinalPermuteDimensions[1] = new int[]{1, 0};
        for (int i = 2; i < 32; ++i) {
            BaseNDArray.tadFinalPermuteDimensions[i] = new int[i];
            int k = i - 1;
            int j = 0;
            while (k >= 0) {
                BaseNDArray.tadFinalPermuteDimensions[i][j] = k--;
                ++j;
            }
        }
    }
}

