/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.arithmetic.AddOp;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.Nesterovs;

public class NesterovsUpdater
implements GradientUpdater<Nesterovs> {
    private final Nesterovs config;
    private INDArray v;
    private char gradientReshapeOrder;

    public NesterovsUpdater(Nesterovs config) {
        this.config = config;
    }

    @Override
    public void setStateViewArray(INDArray viewArray, int[] gradientShape, char gradientOrder, boolean initialize) {
        if (!viewArray.isRowVector()) {
            throw new IllegalArgumentException("Invalid input: expect row vector input");
        }
        if (initialize) {
            viewArray.assign(0);
        }
        this.v = viewArray;
        this.v = Shape.newShapeNoCopy(this.v, gradientShape, gradientOrder == 'f');
        if (this.v == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view array");
        }
        this.gradientReshapeOrder = gradientOrder;
    }

    @Override
    public void applyUpdater(INDArray gradient, int iteration) {
        if (this.v == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        double momentum = this.config.getMomentum();
        double learningRate = this.config.getLearningRate();
        INDArray vPrev = this.v.dup(this.gradientReshapeOrder);
        this.v.muli(momentum).subi(gradient.dup(this.gradientReshapeOrder).muli(learningRate));
        Nd4j.getExecutioner().exec(new AddOp(vPrev.muli(momentum), this.v.mul(-momentum - 1.0), gradient));
    }

    @Override
    public Nesterovs getConfig() {
        return this.config;
    }

    public INDArray getV() {
        return this.v;
    }

    public char getGradientReshapeOrder() {
        return this.gradientReshapeOrder;
    }

    public void setV(INDArray v) {
        this.v = v;
    }

    public void setGradientReshapeOrder(char gradientReshapeOrder) {
        this.gradientReshapeOrder = gradientReshapeOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NesterovsUpdater)) {
            return false;
        }
        NesterovsUpdater other = (NesterovsUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Nesterovs this$config = this.getConfig();
        Nesterovs other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        INDArray this$v = this.getV();
        INDArray other$v = other.getV();
        if (this$v == null ? other$v != null : !this$v.equals(other$v)) {
            return false;
        }
        return this.getGradientReshapeOrder() == other.getGradientReshapeOrder();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NesterovsUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Nesterovs $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        INDArray $v = this.getV();
        result = result * 59 + ($v == null ? 43 : $v.hashCode());
        result = result * 59 + this.getGradientReshapeOrder();
        return result;
    }

    public String toString() {
        return "NesterovsUpdater(config=" + this.getConfig() + ", v=" + this.getV() + ", gradientReshapeOrder=" + this.getGradientReshapeOrder() + ")";
    }
}

