/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.convolution;

import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.convolution.Convolution;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pooling2D
extends BaseTransformOp {
    private static final Logger log = LoggerFactory.getLogger(Pooling2D.class);
    private int kh;
    private int kw;
    private int sy;
    private int sx;
    private int ph;
    private int pw;
    private Pooling2DType type;
    boolean isSameMode;
    double extra;
    protected DataBuffer im2colShape;

    public Pooling2D() {
    }

    public Pooling2D(INDArray x, int kh, int kw, int sy, int sx, int ph, int pw, boolean isSameMode, Pooling2DType type, double extra, int virtualHeight, int virtualWidth, INDArray z) {
        super(x);
        this.kh = kh;
        this.kw = kw;
        this.sy = sy;
        this.sx = sx;
        this.ph = ph;
        this.pw = pw;
        this.isSameMode = isSameMode;
        this.type = type;
        this.z = z;
        this.extra = extra;
        this.im2colShape = Pooling2D.getNewOutputShape(x, kh, kw, sy, sx, ph, pw, virtualHeight, virtualWidth, false);
        this.extraArgs = this.extraArgs();
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public int opNum() {
        return 71;
    }

    @Override
    public String name() {
        return "pooling2d";
    }

    @Override
    public Object[] extraArgs() {
        return new Object[]{this.kw, this.kh, this.sx, this.sy, this.pw, this.ph, this.isSameMode ? 1.0 : 0.0, this.type.ordinal(), this.extra};
    }

    private static INDArray getNewOutputArray(INDArray img, int kernelHeight, int kernelWidth, int strideY, int strideX, int padHeight, int padWidth, boolean coverAll) {
        int n = img.size(0);
        int c = img.size(1);
        int h = img.size(2);
        int w = img.size(3);
        int outHeight = Convolution.outSize(h, kernelHeight, strideY, padHeight, coverAll);
        int outWidth = Convolution.outSize(w, kernelWidth, strideX, padWidth, coverAll);
        return Nd4j.createUninitialized(new int[]{n, c, kernelHeight, kernelWidth, outHeight, outWidth}, 'c');
    }

    private static DataBuffer getNewOutputShape(INDArray img, int kernelHeight, int kernelWidth, int strideY, int strideX, int padHeight, int padWidth, int outHeight, int outWidth, boolean coverAll) {
        int n = img.size(0);
        int c = img.size(1);
        int h = img.size(2);
        int w = img.size(3);
        return (DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{n, c, kernelHeight, kernelWidth, outHeight, outWidth}, 'c').getFirst();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return null;
    }

    @Override
    public float op(float origin, float other) {
        return 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return 0.0;
    }

    @Override
    public double op(double origin) {
        return 0.0;
    }

    @Override
    public float op(float origin) {
        return 0.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        return null;
    }

    public DataBuffer getIm2colShape() {
        return this.im2colShape;
    }

    public static enum Pooling2DType {
        MAX,
        AVG,
        PNORM;

    }
}

