/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import lombok.NonNull;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;

public class Not
extends BaseTransformOp {
    protected double comparable;

    public Not() {
    }

    public Not(@NonNull INDArray x) {
        this(x, 0.0);
        if (x == null) {
            throw new NullPointerException("x");
        }
    }

    public Not(@NonNull INDArray x, Number comparable) {
        this(x, x, comparable, x.lengthLong());
        if (x == null) {
            throw new NullPointerException("x");
        }
    }

    public Not(@NonNull INDArray x, INDArray z, Number comparable) {
        this(x, z, comparable, x.lengthLong());
        if (x == null) {
            throw new NullPointerException("x");
        }
    }

    public Not(@NonNull INDArray x, INDArray z) {
        this(x, z, z.lengthLong());
        if (x == null) {
            throw new NullPointerException("x");
        }
    }

    public Not(@NonNull INDArray x, INDArray z, long n) {
        this(x, z, 0.0, n);
        if (x == null) {
            throw new NullPointerException("x");
        }
    }

    public Not(@NonNull INDArray x, INDArray z, Number comparable, long n) {
        super(x, null, z, n);
        if (x == null) {
            throw new NullPointerException("x");
        }
        this.comparable = comparable.doubleValue();
        this.extraArgs = new Object[]{this.comparable};
    }

    @Override
    public int opNum() {
        return 59;
    }

    @Override
    public String name() {
        return "boolean_not";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return null;
    }

    @Override
    public float op(float origin, float other) {
        return 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return 0.0;
    }

    @Override
    public double op(double origin) {
        return 0.0;
    }

    @Override
    public float op(float origin) {
        return 0.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        return new Not(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        return new Not(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

