/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.GridExecutioner;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.DeviceLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceLocalNDArray
extends DeviceLocal<INDArray> {
    private static final Logger log = LoggerFactory.getLogger(DeviceLocalNDArray.class);

    public DeviceLocalNDArray() {
    }

    public DeviceLocalNDArray(INDArray array) {
        this.broadcast(array);
    }

    public void broadcast(INDArray array) {
        if (array == null) {
            return;
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueueBlocking();
        }
        int numDevices = Nd4j.getAffinityManager().getNumberOfDevices();
        for (int i = 0; i < numDevices; ++i) {
            if (Nd4j.getAffinityManager().getDeviceForCurrentThread() == i) {
                this.set(i, array);
                continue;
            }
            this.set(i, Nd4j.getAffinityManager().replicateToDevice((Integer)i, array));
        }
    }
}

