/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.HardSigmoidDerivative;

public class HardSigmoid
extends BaseTransformOp {
    public HardSigmoid() {
    }

    public HardSigmoid(INDArray x, INDArray z) {
        super(x, z);
    }

    public HardSigmoid(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public HardSigmoid(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public HardSigmoid(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    public HardSigmoid(INDArray ndArray) {
        super(ndArray);
    }

    @Override
    public int opNum() {
        return 51;
    }

    @Override
    public String name() {
        return "hard_sigmoid";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return this.sigmoid(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return this.sigmoid(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return this.sigmoid(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)this.hardSigmoid(origin);
    }

    @Override
    public double op(double origin, double other) {
        return this.hardSigmoid(origin);
    }

    @Override
    public double op(double origin) {
        return this.hardSigmoid(origin);
    }

    @Override
    public float op(float origin) {
        return (float)this.hardSigmoid(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return this.sigmoid(origin);
    }

    private double hardSigmoid(double input) {
        return Math.min(1.0, Math.max(0.0, 0.2 * input + 0.5));
    }

    @Override
    public TransformOp derivative() {
        return new HardSigmoidDerivative(this.x, this.y, this.z, this.n);
    }

    private IComplexNumber sigmoid(IComplexNumber number) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new HardSigmoid(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new HardSigmoid(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new HardSigmoid(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new HardSigmoid(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

