/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions.impl;

import org.apache.commons.math3.util.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.LogSoftMax;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.serde.RowVectorDeserializer;
import org.nd4j.linalg.lossfunctions.serde.RowVectorSerializer;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LossBinaryXENT
implements ILossFunction {
    @JsonSerialize(using=RowVectorSerializer.class)
    @JsonDeserialize(using=RowVectorDeserializer.class)
    private final INDArray weights;

    public LossBinaryXENT() {
        this(null);
    }

    public LossBinaryXENT(INDArray weights) {
        if (weights != null && !weights.isRowVector()) {
            throw new IllegalArgumentException("Weights array must be a row vector");
        }
        this.weights = weights;
    }

    private INDArray scoreArray(INDArray labels, INDArray preOutput, String activationFn, INDArray mask) {
        INDArray scoreArr;
        if ("softmax".equals(activationFn)) {
            INDArray logsoftmax = Nd4j.getExecutioner().execAndReturn(new LogSoftMax(preOutput.dup()));
            scoreArr = logsoftmax.muli(labels);
        } else {
            INDArray output = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(activationFn, preOutput.dup()));
            scoreArr = Transforms.log(output, true).muli(labels);
            INDArray secondTerm = output.rsub(1);
            Transforms.log(secondTerm, false);
            secondTerm.muli(labels.rsub(1));
            scoreArr.addi(secondTerm);
        }
        if (this.weights != null) {
            if (this.weights.length() != preOutput.size(1)) {
                throw new IllegalStateException("Weights vector (length " + this.weights.length() + ") does not match output.size(1)=" + preOutput.size(1));
            }
            scoreArr.muliRowVector(this.weights);
        }
        if (mask != null) {
            scoreArr.muliColumnVector(mask);
        }
        return scoreArr;
    }

    @Override
    public double computeScore(INDArray labels, INDArray preOutput, String activationFn, INDArray mask, boolean average) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        double score = -scoreArr.sumNumber().doubleValue();
        if (average) {
            score /= (double)scoreArr.size(0);
        }
        return score;
    }

    @Override
    public INDArray computeScoreArray(INDArray labels, INDArray preOutput, String activationFn, INDArray mask) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        return scoreArr.sum(1).muli(-1);
    }

    @Override
    public INDArray computeGradient(INDArray labels, INDArray preOutput, String activationFn, INDArray mask) {
        INDArray grad;
        INDArray output = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(activationFn, preOutput.dup()));
        if ("softmax".equals(activationFn)) {
            if (this.weights != null) {
                INDArray temp = labels.mulRowVector(this.weights);
                INDArray col = temp.sum(1);
                grad = output.mulColumnVector(col).sub(temp);
            } else {
                grad = output.subi(labels);
            }
        } else {
            grad = Nd4j.getExecutioner().execAndReturn(Nd4j.getOpFactory().createTransform(activationFn, preOutput.dup()).derivative());
            INDArray denominator = output.mul(output.rsub(1));
            INDArray numerator = output.sub(labels);
            grad.muli(numerator).divi(denominator);
            if (this.weights != null) {
                if (this.weights.length() != output.size(1)) {
                    throw new IllegalStateException("Weights vector (length " + this.weights.length() + ") does not match output.size(1)=" + output.size(1));
                }
                grad.muliRowVector(this.weights);
            }
        }
        if (mask != null) {
            grad.muliColumnVector(mask);
        }
        return grad;
    }

    @Override
    public Pair<Double, INDArray> computeGradientAndScore(INDArray labels, INDArray preOutput, String activationFn, INDArray mask, boolean average) {
        return new Pair((Object)this.computeScore(labels, preOutput, activationFn, mask, average), (Object)this.computeGradient(labels, preOutput, activationFn, mask));
    }

    public String toString() {
        if (this.weights == null) {
            return "LossBinaryXENT()";
        }
        return "LossBinaryXENT(weights=" + this.weights + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LossBinaryXENT)) {
            return false;
        }
        LossBinaryXENT other = (LossBinaryXENT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$weights = this.getWeights();
        INDArray other$weights = other.getWeights();
        return !(this$weights == null ? other$weights != null : !this$weights.equals(other$weights));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LossBinaryXENT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : $weights.hashCode());
        return result;
    }

    public INDArray getWeights() {
        return this.weights;
    }
}

