/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.compression;

import java.io.Serializable;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.compression.CompressionType;
import org.nd4j.linalg.compression.NDArrayCompressor;

public class CompressionDescriptor
implements Cloneable,
Serializable {
    private CompressionType compressionType;
    private String compressionAlgorithm;
    private long originalLength;
    private long compressedLength;
    private long numberOfElements;
    private long originalElementSize;

    public CompressionDescriptor() {
    }

    public CompressionDescriptor(DataBuffer buffer) {
        this.originalLength = buffer.length() * (long)buffer.getElementSize();
        this.numberOfElements = buffer.length();
        this.originalElementSize = buffer.getElementSize();
    }

    public CompressionDescriptor(DataBuffer buffer, String algorithm) {
        this(buffer);
        this.compressionAlgorithm = algorithm;
    }

    public CompressionDescriptor(DataBuffer buffer, NDArrayCompressor compressor) {
        this(buffer, compressor.getDescriptor());
        this.compressionType = compressor.getCompressionType();
    }

    public CompressionDescriptor clone() {
        CompressionDescriptor descriptor = new CompressionDescriptor();
        descriptor.compressionType = this.compressionType;
        descriptor.compressionAlgorithm = this.compressionAlgorithm;
        descriptor.originalLength = this.originalLength;
        descriptor.compressedLength = this.compressedLength;
        descriptor.numberOfElements = this.numberOfElements;
        descriptor.originalElementSize = this.originalElementSize;
        return descriptor;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public long getOriginalLength() {
        return this.originalLength;
    }

    public long getCompressedLength() {
        return this.compressedLength;
    }

    public long getNumberOfElements() {
        return this.numberOfElements;
    }

    public long getOriginalElementSize() {
        return this.originalElementSize;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public void setCompressionAlgorithm(String compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public void setOriginalLength(long originalLength) {
        this.originalLength = originalLength;
    }

    public void setCompressedLength(long compressedLength) {
        this.compressedLength = compressedLength;
    }

    public void setNumberOfElements(long numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public void setOriginalElementSize(long originalElementSize) {
        this.originalElementSize = originalElementSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompressionDescriptor)) {
            return false;
        }
        CompressionDescriptor other = (CompressionDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompressionType this$compressionType = this.getCompressionType();
        CompressionType other$compressionType = other.getCompressionType();
        if (this$compressionType == null ? other$compressionType != null : !((Object)((Object)this$compressionType)).equals((Object)other$compressionType)) {
            return false;
        }
        String this$compressionAlgorithm = this.getCompressionAlgorithm();
        String other$compressionAlgorithm = other.getCompressionAlgorithm();
        if (this$compressionAlgorithm == null ? other$compressionAlgorithm != null : !this$compressionAlgorithm.equals(other$compressionAlgorithm)) {
            return false;
        }
        if (this.getOriginalLength() != other.getOriginalLength()) {
            return false;
        }
        if (this.getCompressedLength() != other.getCompressedLength()) {
            return false;
        }
        if (this.getNumberOfElements() != other.getNumberOfElements()) {
            return false;
        }
        return this.getOriginalElementSize() == other.getOriginalElementSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompressionDescriptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompressionType $compressionType = this.getCompressionType();
        result = result * 59 + ($compressionType == null ? 0 : ((Object)((Object)$compressionType)).hashCode());
        String $compressionAlgorithm = this.getCompressionAlgorithm();
        result = result * 59 + ($compressionAlgorithm == null ? 0 : $compressionAlgorithm.hashCode());
        long $originalLength = this.getOriginalLength();
        result = result * 59 + (int)($originalLength >>> 32 ^ $originalLength);
        long $compressedLength = this.getCompressedLength();
        result = result * 59 + (int)($compressedLength >>> 32 ^ $compressedLength);
        long $numberOfElements = this.getNumberOfElements();
        result = result * 59 + (int)($numberOfElements >>> 32 ^ $numberOfElements);
        long $originalElementSize = this.getOriginalElementSize();
        result = result * 59 + (int)($originalElementSize >>> 32 ^ $originalElementSize);
        return result;
    }

    public String toString() {
        return "CompressionDescriptor(compressionType=" + (Object)((Object)this.getCompressionType()) + ", compressionAlgorithm=" + this.getCompressionAlgorithm() + ", originalLength=" + this.getOriginalLength() + ", compressedLength=" + this.getCompressedLength() + ", numberOfElements=" + this.getNumberOfElements() + ", originalElementSize=" + this.getOriginalElementSize() + ")";
    }
}

