/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.arithmetic;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;

public class Axpy
extends BaseTransformOp {
    private double p;

    public Axpy() {
    }

    public Axpy(INDArray x, INDArray z, double p) {
        this.p = p;
        this.init(x, z, z, x.length());
    }

    public Axpy(INDArray x, INDArray z, double p, long n) {
        this.p = p;
        this.init(x, z, z, n);
    }

    public Axpy(INDArray x, INDArray y, INDArray z, double p, long n) {
        this.p = p;
        this.init(x, y, z, x.length());
    }

    @Override
    public int opNum() {
        return 17;
    }

    @Override
    public String name() {
        return "axpy";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return null;
    }

    @Override
    public float op(float origin, float other) {
        return 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return 0.0;
    }

    @Override
    public double op(double origin) {
        return 0.0;
    }

    @Override
    public float op(float origin) {
        return 0.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Axpy(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.p, (long)xAlongDimension.length());
        }
        throw new IllegalStateException("op.Y can't be null");
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Axpy(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.p, (long)xAlongDimension.length());
        }
        throw new IllegalStateException("op.Y can't be null");
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        if (x.lengthLong() < n || y.lengthLong() < n || z.lengthLong() < n) {
            throw new IllegalStateException("Mis matched lengths: X: [" + x.lengthLong() + "], Y: [" + y.lengthLong() + "], Z: [" + z.lengthLong() + "], N: [" + n + "]");
        }
        this.extraArgs = new Object[]{this.p, (double)n};
    }
}

