/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks.cpu.accumulation;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveAction;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.parallel.tasks.Task;
import org.nd4j.linalg.api.parallel.tasks.TaskExecutorProvider;
import org.nd4j.linalg.api.parallel.tasks.cpu.accumulation.CPUAccumulationTask;
import org.nd4j.linalg.api.shape.tensor.TensorCalculator;

public class CPUAccumulations1dAction
extends RecursiveAction
implements Task<Void> {
    private Future future;
    private List<Task<?>> subTasks = null;
    private Accumulation op;
    private int threshold;
    private TensorCalculator tCalcx;
    private TensorCalculator tCalcy;
    private int firstTensor;
    private int lastTensor;
    private INDArray output;

    public CPUAccumulations1dAction(Accumulation op, int threshold, TensorCalculator tCalcx, TensorCalculator tCalcy, int firstTensor, int lastTensor, INDArray output) {
        this.op = op;
        this.threshold = threshold;
        this.tCalcx = tCalcx;
        this.tCalcy = tCalcy;
        this.firstTensor = firstTensor;
        this.lastTensor = lastTensor;
        this.output = output;
    }

    @Override
    protected void compute() {
        int nTensors = this.lastTensor - this.firstTensor + 1;
        int nElements = nTensors * this.tCalcx.getTensorLength();
        if (nTensors > 1 && nElements > this.threshold) {
            int nFirst = nTensors / 2;
            CPUAccumulations1dAction taskLeft = new CPUAccumulations1dAction(this.op, this.threshold, this.tCalcx, this.tCalcy, this.firstTensor, this.firstTensor + nFirst - 1, this.output);
            taskLeft.fork();
            CPUAccumulations1dAction taskRight = new CPUAccumulations1dAction(this.op, this.threshold, this.tCalcx, this.tCalcy, this.firstTensor + nFirst, this.lastTensor, this.output);
            taskRight.fork();
            taskLeft.join();
            taskRight.join();
        } else if (nTensors == 1 && nElements > this.threshold) {
            int offsetX = this.tCalcx.getOffsetForTensor(this.firstTensor);
            int offsetY = this.tCalcy != null ? this.tCalcy.getOffsetForTensor(this.firstTensor) : 0;
            int incrX = this.tCalcx.getElementWiseStrideForTensor();
            int incrY = this.tCalcy != null ? this.tCalcy.getElementWiseStrideForTensor() : 0;
            int n = this.tCalcx.getTensorLength();
            int nFirst = n / 2;
            CPUAccumulationTask first = new CPUAccumulationTask(this.op, this.threshold, nFirst, offsetX, offsetY, incrX, incrY, false);
            first.fork();
            int nSecond = n - nFirst;
            int offsetX2 = offsetX + nFirst * incrX;
            int offsetY2 = offsetY + nFirst * incrY;
            CPUAccumulationTask second = new CPUAccumulationTask(this.op, this.threshold, nSecond, offsetX2, offsetY2, incrX, incrY, false);
            second.fork();
            double accum = this.op.combineSubResults((Double)first.join(), (Double)second.join());
            this.output.putScalar(this.firstTensor, this.op.calculateFinalResult(accum, (long)this.tCalcx.getTensorLength()));
        } else {
            this.execute();
        }
    }

    @Override
    public Void call() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void execute() {
        DataBuffer x = this.op.x().data();
        DataBuffer y = this.op.y() != null ? this.op.y().data() : null;
        int incrX = this.tCalcx.getElementWiseStrideForTensor();
        int n = this.tCalcx.getTensorLength();
        if (y != null) {
            int incrY = this.tCalcy.getElementWiseStrideForTensor();
            for (int tensorNum = this.firstTensor; tensorNum <= this.lastTensor; ++tensorNum) {
                double dy;
                int i;
                int byteOffsetY;
                int offsetX = this.tCalcx.getOffsetForTensor(tensorNum);
                int offsetY = this.tCalcy.getOffsetForTensor(tensorNum);
                if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
                    int i2;
                    if (x.dataType() == DataBuffer.Type.FLOAT) {
                        int i3;
                        float[] xf = (float[])x.array();
                        float[] yf = (float[])y.array();
                        float accum = this.op.zeroFloat();
                        if (incrX == 1 && incrY == 1) {
                            for (i3 = 0; i3 < n; ++i3) {
                                accum = this.op.update(accum, this.op.op(xf[offsetX + i3], yf[offsetY + i3]));
                            }
                        } else {
                            for (i3 = 0; i3 < n; ++i3) {
                                accum = this.op.update(accum, this.op.op(xf[offsetX + i3 * incrX], yf[offsetY + i3 * incrY]));
                            }
                        }
                        this.output.putScalar(tensorNum, this.op.calculateFinalResult(accum, (long)n));
                        continue;
                    }
                    double[] xd = (double[])x.array();
                    double[] yd = (double[])y.array();
                    double accum = this.op.zeroDouble();
                    if (incrX == 1 && incrY == 1) {
                        for (i2 = 0; i2 < n; ++i2) {
                            accum = this.op.update(accum, this.op.op(xd[offsetX + i2], yd[offsetY + i2]));
                        }
                    } else {
                        for (i2 = 0; i2 < n; ++i2) {
                            accum = this.op.update(accum, this.op.op(xd[offsetX + i2 * incrX], yd[offsetY + i2 * incrY]));
                        }
                    }
                    this.output.putScalar(tensorNum, this.op.calculateFinalResult(accum, (long)n));
                    continue;
                }
                ByteBuffer nbbx = x.asNio();
                ByteBuffer nbby = y.asNio();
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    int i4;
                    int byteOffsetX = offsetX;
                    byteOffsetY = offsetY;
                    FloatBuffer floatBufferX = nbbx.asFloatBuffer();
                    FloatBuffer floatBuffery = nbby.asFloatBuffer();
                    float accum = this.op.zeroFloat();
                    int idx = 0;
                    if (incrX == 1 && incrY == 1) {
                        i4 = 0;
                        while (i4 < n) {
                            float fx = floatBufferX.get(byteOffsetX + i4);
                            float fy = floatBuffery.get(byteOffsetY + i4);
                            accum = this.op.update(accum, this.op.op(fx, fy));
                            ++i4;
                            ++idx;
                        }
                    } else {
                        i4 = 0;
                        while (i4 < n) {
                            float fx = floatBufferX.get(byteOffsetX + i4 * incrX);
                            float fy = floatBuffery.get(byteOffsetY + i4 * incrY);
                            accum = this.op.update(accum, this.op.op(fx, fy));
                            ++i4;
                            ++idx;
                        }
                    }
                    this.output.putScalar(tensorNum, this.op.calculateFinalResult(accum, (long)n));
                    continue;
                }
                int byteOffsetX = offsetX;
                byteOffsetY = offsetY;
                DoubleBuffer doubleBufferX = nbbx.asDoubleBuffer();
                DoubleBuffer doubleBufferY = nbby.asDoubleBuffer();
                double accum = this.op.zeroDouble();
                int idx = 0;
                if (incrX == 1 && incrY == 1) {
                    i = 0;
                    while (i < n) {
                        double dx = doubleBufferX.get(byteOffsetX + i);
                        dy = doubleBufferY.get(byteOffsetY + i);
                        accum = this.op.update(accum, this.op.op(dx, dy));
                        ++i;
                        ++idx;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        double dx = doubleBufferX.get(byteOffsetX + i * incrX);
                        dy = doubleBufferY.get(byteOffsetY + i * incrY);
                        accum = this.op.update(accum, this.op.op(dx, dy));
                        ++i;
                        ++idx;
                    }
                }
                this.output.putScalar(tensorNum, this.op.calculateFinalResult(accum, (long)n));
            }
        } else {
            for (int tensorNum = this.firstTensor; tensorNum <= this.lastTensor; ++tensorNum) {
                double dx;
                int i;
                int byteOffsetX;
                int offsetX = this.tCalcx.getOffsetForTensor(tensorNum);
                if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
                    int i5;
                    if (x.dataType() == DataBuffer.Type.FLOAT) {
                        int i6;
                        float[] xf = (float[])x.array();
                        float accum = this.op.zeroFloat();
                        if (incrX == 1) {
                            for (i6 = 0; i6 < n; ++i6) {
                                accum = this.op.update(accum, this.op.op(xf[offsetX + i6]));
                            }
                        } else {
                            for (i6 = 0; i6 < n; ++i6) {
                                accum = this.op.update(accum, this.op.op(xf[offsetX + i6 * incrX]));
                            }
                        }
                        this.output.putScalar(tensorNum, this.op.calculateFinalResult(accum, (long)n));
                        continue;
                    }
                    double[] xd = (double[])x.array();
                    double accum = this.op.zeroDouble();
                    if (incrX == 1) {
                        for (i5 = 0; i5 < n; ++i5) {
                            accum = this.op.update(accum, this.op.op(xd[offsetX + i5]));
                        }
                    } else {
                        for (i5 = 0; i5 < n; ++i5) {
                            accum = this.op.update(accum, this.op.op(xd[offsetX + i5 * incrX]));
                        }
                    }
                    this.output.putScalar(tensorNum, this.op.calculateFinalResult(accum, (long)n));
                    continue;
                }
                ByteBuffer nbbx = x.asNio();
                FloatBuffer floatBuffer = nbbx.asFloatBuffer();
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    int i7;
                    byteOffsetX = offsetX;
                    float accum = this.op.zeroFloat();
                    int idx = 0;
                    if (incrX == 1) {
                        i7 = 0;
                        while (i7 < n) {
                            float fx = this.op.op(floatBuffer.get(byteOffsetX + i7));
                            accum = this.op.update(accum, fx);
                            ++i7;
                            ++idx;
                        }
                    } else {
                        i7 = 0;
                        while (i7 < n) {
                            float fx = this.op.op(floatBuffer.get(byteOffsetX + i7 * incrX));
                            accum = this.op.update(accum, fx);
                            ++i7;
                            ++idx;
                        }
                    }
                    this.output.putScalar(tensorNum, this.op.calculateFinalResult(accum, (long)n));
                    continue;
                }
                byteOffsetX = offsetX;
                DoubleBuffer doubleBuffer = nbbx.asDoubleBuffer();
                double accum = this.op.zeroDouble();
                int idx = 0;
                if (incrX == 1) {
                    i = 0;
                    while (i < n) {
                        dx = this.op.op(doubleBuffer.get(byteOffsetX + i));
                        accum = this.op.update(accum, dx);
                        ++i;
                        ++idx;
                    }
                } else {
                    i = 0;
                    while (i < n) {
                        dx = this.op.op(doubleBuffer.get(byteOffsetX + i * incrX));
                        accum = this.op.update(accum, dx);
                        ++i;
                        ++idx;
                    }
                }
                this.output.putScalar(tensorNum, this.op.calculateFinalResult(accum, (long)n));
            }
        }
    }

    @Override
    public Void invokeBlocking() {
        this.invokeAsync();
        return this.blockUntilComplete();
    }

    @Override
    public void invokeAsync() {
        this.future = TaskExecutorProvider.getTaskExecutor().executeAsync(this);
    }

    @Override
    public Void blockUntilComplete() {
        if (this.future == null) {
            this.invokeAsync();
        }
        try {
            this.future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.subTasks != null) {
            for (Task<?> t : this.subTasks) {
                t.blockUntilComplete();
            }
        }
        return null;
    }
}

