/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.transforms.Exp;
import org.nd4j.linalg.api.ops.impl.transforms.Log;
import org.nd4j.linalg.factory.Nd4j;

public class LogSoftMax
extends BaseTransformOp {
    public LogSoftMax() {
    }

    public LogSoftMax(INDArray x, INDArray z) {
        super(x, z);
    }

    public LogSoftMax(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public LogSoftMax(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public LogSoftMax(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    public LogSoftMax(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 40;
    }

    @Override
    public String name() {
        return "logsoftmax";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        return origin;
    }

    @Override
    public double op(double origin, double other) {
        return origin;
    }

    @Override
    public double op(double origin) {
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LogSoftMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new LogSoftMax(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LogSoftMax(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new LogSoftMax(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public void exec() {
        this.exec(1);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public void exec(int ... dimensions) {
        if (dimensions[0] != 1) {
            throw new IllegalArgumentException("Only supports row wise calculations");
        }
        if (this.x.isMatrix()) {
            INDArray rowMax = this.x.max(1);
            INDArray xMinusRowMax = this.x.subColumnVector(rowMax);
            INDArray expXMinusRowMax = Nd4j.getExecutioner().execAndReturn(new Exp(xMinusRowMax.dup()));
            INDArray logRowSumExp = expXMinusRowMax.sum(1);
            Nd4j.getExecutioner().exec(new Log(logRowSumExp));
            INDArray logsoftmax = xMinusRowMax.subiColumnVector(logRowSumExp);
            if (this.z != null) {
                this.z.assign(logsoftmax);
            } else {
                this.z = logsoftmax;
            }
        } else if (this.x.isVector()) {
            double max = this.x.maxNumber().doubleValue();
            INDArray xMinusMax = this.x.sub(max);
            INDArray expXMinusMax = Nd4j.getExecutioner().execAndReturn(new Exp(xMinusMax.dup()));
            double logRowSumExp = FastMath.log((double)expXMinusMax.sumNumber().doubleValue());
            INDArray logsoftmax = xMinusMax.subi(logRowSumExp);
            if (this.z != null) {
                this.z.assign(logsoftmax);
            } else {
                this.z = logsoftmax;
            }
        }
    }
}

