/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.GradientUpdaterAggregator;
import org.nd4j.linalg.ops.transforms.Transforms;

public class RmsProp
implements GradientUpdater {
    private INDArray lastGradient;
    private double rmsDecay = 0.95;
    private double learningRate = 0.1;
    private static final double epsilon = 1.0E-8;

    public RmsProp(double learningRate, double rmsDecay) {
        this.learningRate = learningRate;
        this.rmsDecay = rmsDecay;
    }

    @Override
    public void update(Object ... args) {
        if (args.length > 0) {
            this.learningRate = (Double)args[0];
        }
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        INDArray ret;
        if (this.lastGradient == null) {
            this.lastGradient = Nd4j.zeros(gradient.shape()).add(1.0E-8);
        }
        this.lastGradient.muli(this.rmsDecay).addi(gradient.mul(gradient).muli(1.0 - this.rmsDecay));
        try {
            ret = gradient.mul(this.learningRate).divi(Transforms.sqrt(this.lastGradient));
        }
        catch (ArithmeticException ae) {
            ret = gradient.mul(this.learningRate).divi(Transforms.sqrt(this.lastGradient.add(1.0E-8)));
        }
        return ret;
    }

    @Override
    public GradientUpdaterAggregator getAggregator(boolean addThis) {
        RmsPropAggregator ag = new RmsPropAggregator();
        if (addThis) {
            ag.aggregate(this);
        }
        return ag;
    }

    public INDArray getLastGradient() {
        return this.lastGradient;
    }

    public double getRmsDecay() {
        return this.rmsDecay;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLastGradient(INDArray lastGradient) {
        this.lastGradient = lastGradient;
    }

    public void setRmsDecay(double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RmsProp)) {
            return false;
        }
        RmsProp other = (RmsProp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$lastGradient = this.getLastGradient();
        INDArray other$lastGradient = other.getLastGradient();
        if (this$lastGradient == null ? other$lastGradient != null : !this$lastGradient.equals(other$lastGradient)) {
            return false;
        }
        if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
            return false;
        }
        return Double.compare(this.getLearningRate(), other.getLearningRate()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof RmsProp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $lastGradient = this.getLastGradient();
        result = result * 59 + ($lastGradient == null ? 0 : $lastGradient.hashCode());
        long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
        result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        return result;
    }

    public String toString() {
        return "RmsProp(lastGradient=" + this.getLastGradient() + ", rmsDecay=" + this.getRmsDecay() + ", learningRate=" + this.getLearningRate() + ")";
    }

    public RmsProp() {
    }

    public static class RmsPropAggregator
    implements GradientUpdaterAggregator {
        private INDArray lastGradientSum;
        private double rmsDecaySum;
        private double lrSum;
        private int count = 0;

        @Override
        public GradientUpdater getUpdater() {
            RmsProp rmsProp = new RmsProp(this.lrSum / (double)this.count, this.rmsDecaySum / (double)this.count);
            rmsProp.setLastGradient(this.lastGradientSum.div(this.count));
            return rmsProp;
        }

        @Override
        public void aggregate(GradientUpdater updater) {
            if (!(updater instanceof RmsProp)) {
                throw new UnsupportedOperationException();
            }
            RmsProp rmsProp = (RmsProp)updater;
            if (this.lastGradientSum == null) {
                this.lastGradientSum = rmsProp.lastGradient.dup();
                this.rmsDecaySum = rmsProp.rmsDecay;
                this.lrSum = rmsProp.learningRate;
            } else {
                this.lastGradientSum.addi(rmsProp.lastGradient);
                this.rmsDecaySum += rmsProp.rmsDecay;
                this.lrSum += rmsProp.learningRate;
            }
            ++this.count;
        }

        @Override
        public GradientUpdaterAggregator combine(GradientUpdaterAggregator other) {
            if (!(other instanceof RmsPropAggregator)) {
                throw new IllegalArgumentException("Cannot combine RmsPropAggregator with aggregator: " + other);
            }
            RmsPropAggregator aggregator = (RmsPropAggregator)other;
            this.lastGradientSum.addi(aggregator.lastGradientSum);
            this.rmsDecaySum += aggregator.rmsDecaySum;
            this.lrSum += aggregator.lrSum;
            this.count += aggregator.count;
            return this;
        }
    }
}

