/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.io.Serializable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.GradientUpdaterAggregator;
import org.nd4j.linalg.ops.transforms.Transforms;

public class AdaDelta
implements Serializable,
GradientUpdater {
    private INDArray msg;
    private INDArray msdx;
    private double rho = 0.95;

    public AdaDelta(double rho) {
        this.rho = rho;
    }

    @Override
    public void update(Object ... args) {
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        if (this.msg == null) {
            this.msg = Nd4j.zeros(gradient.shape());
        }
        if (this.msdx == null) {
            this.msdx = Nd4j.zeros(gradient.shape());
        }
        this.msg.muli(this.rho);
        this.msg.addi(1.0 - this.rho).muli(gradient.mul(gradient));
        INDArray ret = Transforms.sqrt(this.msdx.add(Nd4j.EPS_THRESHOLD)).divi(Transforms.sqrt(this.msg.add(Nd4j.EPS_THRESHOLD))).muli(gradient);
        this.msdx.muli(this.rho);
        INDArray dxSquared = ret.mul(ret);
        this.msdx.addi(dxSquared.muli(1.0 - this.rho));
        return ret;
    }

    @Override
    public GradientUpdaterAggregator getAggregator(boolean addThis) {
        AdaDeltaAggregator ag = new AdaDeltaAggregator();
        if (addThis) {
            ag.aggregate(this);
        }
        return ag;
    }

    public INDArray getMsg() {
        return this.msg;
    }

    public INDArray getMsdx() {
        return this.msdx;
    }

    public double getRho() {
        return this.rho;
    }

    public void setMsg(INDArray msg) {
        this.msg = msg;
    }

    public void setMsdx(INDArray msdx) {
        this.msdx = msdx;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaDelta)) {
            return false;
        }
        AdaDelta other = (AdaDelta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$msg = this.getMsg();
        INDArray other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        INDArray this$msdx = this.getMsdx();
        INDArray other$msdx = other.getMsdx();
        if (this$msdx == null ? other$msdx != null : !this$msdx.equals(other$msdx)) {
            return false;
        }
        return Double.compare(this.getRho(), other.getRho()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaDelta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 0 : $msg.hashCode());
        INDArray $msdx = this.getMsdx();
        result = result * 59 + ($msdx == null ? 0 : $msdx.hashCode());
        long $rho = Double.doubleToLongBits(this.getRho());
        result = result * 59 + (int)($rho >>> 32 ^ $rho);
        return result;
    }

    public String toString() {
        return "AdaDelta(msg=" + this.getMsg() + ", msdx=" + this.getMsdx() + ", rho=" + this.getRho() + ")";
    }

    public AdaDelta() {
    }

    public static class AdaDeltaAggregator
    implements GradientUpdaterAggregator {
        private INDArray msgSum;
        private INDArray msdxSum;
        private double rhoSum;
        private int count = 0;

        @Override
        public GradientUpdater getUpdater() {
            AdaDelta adaDelta = new AdaDelta(this.rhoSum / (double)this.count);
            adaDelta.setMsg(this.msgSum.div(this.count));
            adaDelta.setMsdx(this.msdxSum.div(this.count));
            adaDelta.setRho(this.rhoSum / (double)this.count);
            return adaDelta;
        }

        @Override
        public void aggregate(GradientUpdater updater) {
            if (!(updater instanceof AdaDelta)) {
                throw new UnsupportedOperationException("Cannot aggregate AdaDelta with updater: " + updater);
            }
            AdaDelta adaDelta = (AdaDelta)updater;
            if (this.msgSum == null) {
                this.msgSum = adaDelta.msg.dup();
                this.msdxSum = adaDelta.msdx.dup();
                this.rhoSum = adaDelta.rho;
            } else {
                this.msgSum.addi(adaDelta.msg);
                this.msdxSum.addi(adaDelta.msdx);
                this.rhoSum += adaDelta.rho;
            }
            ++this.count;
        }

        @Override
        public GradientUpdaterAggregator combine(GradientUpdaterAggregator other) {
            if (!(other instanceof AdaDeltaAggregator)) {
                throw new IllegalArgumentException("Cannot combine AdaDeltaAggregator with aggregator: " + other);
            }
            AdaDeltaAggregator aggregator = (AdaDeltaAggregator)other;
            this.msgSum.addi(aggregator.msgSum);
            this.msdxSum.addi(aggregator.msdxSum);
            this.rhoSum += aggregator.rhoSum;
            this.count += aggregator.count;
            return this;
        }
    }
}

