/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape.loop.one;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.StridePermutation;
import org.nd4j.linalg.util.ArrayUtil;

public class RawArrayIterationInformation1
implements Serializable {
    private int nDim;
    private int aOffset = -1;
    private int[] aStrides;
    private int[] shape;
    private DataBuffer a;

    public RawArrayIterationInformation1 computeOut() {
        int i;
        int aOffset = this.aOffset;
        int[] aStrides = ArrayUtil.copy((int[])this.aStrides);
        int[] shape = ArrayUtil.copy((int[])this.shape);
        int nDim = this.nDim;
        StridePermutation[] perms = Shape.createSortedStrides(aStrides);
        for (i = 0; i < nDim; ++i) {
            int iPerm = perms[nDim - i - 1].getPermutation();
            shape[i] = this.shape[iPerm];
            aStrides[i] = aStrides[iPerm];
        }
        for (i = 0; i < nDim; ++i) {
            int outStrideA = aStrides[i];
            int shapeI = shape[i];
            if (outStrideA >= 0) continue;
            aOffset += outStrideA * shapeI - 1;
            int n = i;
            aStrides[n] = aStrides[n] - outStrideA;
        }
        i = 0;
        for (int j = 1; j < nDim; ++j) {
            if (shape[i] == 1) {
                shape[i] = shape[j];
                aStrides[i] = aStrides[j];
                continue;
            }
            if (shape[j] == 1) continue;
            if (aStrides[i] * shape[i] == aStrides[j]) {
                int n = i;
                shape[n] = shape[n] * shape[j];
                continue;
            }
            shape[++i] = shape[j];
            aStrides[i] = aStrides[j];
        }
        nDim = i + 1;
        return RawArrayIterationInformation1.builder().aOffset(aOffset).a(this.a).aStrides(aStrides).shape(shape).nDim(nDim).build();
    }

    public static RawArrayIterationInformation1Builder builder() {
        return new RawArrayIterationInformation1Builder();
    }

    public int getNDim() {
        return this.nDim;
    }

    public int getAOffset() {
        return this.aOffset;
    }

    public int[] getAStrides() {
        return this.aStrides;
    }

    public int[] getShape() {
        return this.shape;
    }

    public DataBuffer getA() {
        return this.a;
    }

    public void setNDim(int nDim) {
        this.nDim = nDim;
    }

    public void setAOffset(int aOffset) {
        this.aOffset = aOffset;
    }

    public void setAStrides(int[] aStrides) {
        this.aStrides = aStrides;
    }

    public void setShape(int[] shape) {
        this.shape = shape;
    }

    public void setA(DataBuffer a) {
        this.a = a;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawArrayIterationInformation1)) {
            return false;
        }
        RawArrayIterationInformation1 other = (RawArrayIterationInformation1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNDim() != other.getNDim()) {
            return false;
        }
        if (this.getAOffset() != other.getAOffset()) {
            return false;
        }
        if (!Arrays.equals(this.getAStrides(), other.getAStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getShape(), other.getShape())) {
            return false;
        }
        DataBuffer this$a = this.getA();
        DataBuffer other$a = other.getA();
        return !(this$a == null ? other$a != null : !this$a.equals(other$a));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawArrayIterationInformation1;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNDim();
        result = result * 59 + this.getAOffset();
        result = result * 59 + Arrays.hashCode(this.getAStrides());
        result = result * 59 + Arrays.hashCode(this.getShape());
        DataBuffer $a = this.getA();
        result = result * 59 + ($a == null ? 0 : $a.hashCode());
        return result;
    }

    public String toString() {
        return "RawArrayIterationInformation1(nDim=" + this.getNDim() + ", aOffset=" + this.getAOffset() + ", aStrides=" + Arrays.toString(this.getAStrides()) + ", shape=" + Arrays.toString(this.getShape()) + ", a=" + this.getA() + ")";
    }

    @ConstructorProperties(value={"nDim", "aOffset", "aStrides", "shape", "a"})
    public RawArrayIterationInformation1(int nDim, int aOffset, int[] aStrides, int[] shape, DataBuffer a) {
        this.nDim = nDim;
        this.aOffset = aOffset;
        this.aStrides = aStrides;
        this.shape = shape;
        this.a = a;
    }

    public RawArrayIterationInformation1() {
    }

    public static class RawArrayIterationInformation1Builder {
        private int nDim;
        private int aOffset;
        private int[] aStrides;
        private int[] shape;
        private DataBuffer a;

        RawArrayIterationInformation1Builder() {
        }

        public RawArrayIterationInformation1Builder nDim(int nDim) {
            this.nDim = nDim;
            return this;
        }

        public RawArrayIterationInformation1Builder aOffset(int aOffset) {
            this.aOffset = aOffset;
            return this;
        }

        public RawArrayIterationInformation1Builder aStrides(int[] aStrides) {
            this.aStrides = aStrides;
            return this;
        }

        public RawArrayIterationInformation1Builder shape(int[] shape) {
            this.shape = shape;
            return this;
        }

        public RawArrayIterationInformation1Builder a(DataBuffer a) {
            this.a = a;
            return this;
        }

        public RawArrayIterationInformation1 build() {
            return new RawArrayIterationInformation1(this.nDim, this.aOffset, this.aStrides, this.shape, this.a);
        }

        public String toString() {
            return "RawArrayIterationInformation1.RawArrayIterationInformation1Builder(nDim=" + this.nDim + ", aOffset=" + this.aOffset + ", aStrides=" + Arrays.toString(this.aStrides) + ", shape=" + Arrays.toString(this.shape) + ", a=" + this.a + ")";
        }
    }
}

