/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks.cpu.transform;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.parallel.tasks.cpu.transform.BaseCPUTransformOpAction;

public class CPUTransformOpAction
extends BaseCPUTransformOpAction {
    public CPUTransformOpAction(TransformOp op, int threshold, int n, int offsetX, int offsetY, int offsetZ, int incrX, int incrY, int incrZ) {
        super(op, threshold, n, offsetX, offsetY, offsetZ, incrX, incrY, incrZ);
    }

    public CPUTransformOpAction(TransformOp op, int threshold) {
        super(op, threshold);
    }

    public CPUTransformOpAction(TransformOp op, int threshold, int tadIdx, int tadDim) {
        super(op, threshold, tadIdx, tadDim);
    }

    @Override
    public Void call() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nSubTasks = 1 + this.n / this.threshold;
            this.subTasks = new ArrayList(nSubTasks);
            int taskSize = this.n / nSubTasks;
            int soFar = 0;
            for (int i = 0; i < nSubTasks; ++i) {
                int nInTask = i == nSubTasks - 1 ? this.n - soFar : taskSize;
                int offsetXNew = this.offsetX + soFar * this.incrX;
                int offsetYNew = this.offsetY + soFar * this.incrY;
                int offsetZNew = this.offsetZ + soFar * this.incrZ;
                CPUTransformOpAction t = new CPUTransformOpAction(this.op, this.threshold, nInTask, offsetXNew, offsetYNew, offsetZNew, this.incrX, this.incrY, this.incrZ);
                t.invokeAsync();
                this.subTasks.add(t);
                soFar += nInTask;
            }
        } else {
            this.execute();
        }
        return null;
    }

    @Override
    protected void compute() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nFirst = this.n / 2;
            CPUTransformOpAction first = new CPUTransformOpAction(this.op, this.threshold, nFirst, this.offsetX, this.offsetY, this.offsetZ, this.incrX, this.incrY, this.incrZ);
            first.fork();
            int nSecond = this.n - nFirst;
            int offsetX2 = this.offsetX + nFirst * this.incrX;
            int offsetY2 = this.offsetY + nFirst * this.incrY;
            int offsetZ2 = this.offsetZ + nFirst * this.incrZ;
            CPUTransformOpAction second = new CPUTransformOpAction(this.op, this.threshold, nSecond, offsetX2, offsetY2, offsetZ2, this.incrX, this.incrY, this.incrZ);
            second.fork();
            first.join();
            second.join();
        } else {
            this.execute();
        }
    }

    private void execute() {
        DataBuffer x = this.op.x().data();
        DataBuffer y = this.op.y() != null ? this.op.y().data() : null;
        DataBuffer z = this.op.z().data();
        if (y != null) {
            if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    float[] xf = (float[])x.array();
                    float[] yf = (float[])y.array();
                    if (this.incrX == 1 && this.incrY == 1 && (x == z || this.incrZ == 1)) {
                        if (x == z) {
                            for (int i = 0; i < this.n; ++i) {
                                int xIdx = this.offsetX + i;
                                xf[xIdx] = this.op.op(xf[xIdx], yf[this.offsetY + i]);
                            }
                        } else {
                            float[] zf = (float[])z.array();
                            for (int i = 0; i < this.n; ++i) {
                                zf[this.offsetZ + i] = this.op.op(xf[this.offsetX + i], yf[this.offsetY + i]);
                            }
                        }
                    } else if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i * this.incrX;
                            xf[xIdx] = this.op.op(xf[xIdx], yf[this.offsetY + i * this.incrY]);
                        }
                    } else {
                        float[] zf = (float[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zf[this.offsetZ + i * this.incrZ] = this.op.op(xf[this.offsetX + i * this.incrX], yf[this.offsetY + i * this.incrY]);
                        }
                    }
                } else {
                    double[] xd = (double[])x.array();
                    double[] yd = (double[])y.array();
                    if (this.incrX == 1 && this.incrY == 1 && (x == z || this.incrZ == 1)) {
                        if (x == z) {
                            for (int i = 0; i < this.n; ++i) {
                                int xIdx = this.offsetX + i;
                                xd[xIdx] = this.op.op(xd[xIdx], yd[this.offsetY + i]);
                            }
                        } else {
                            double[] zd = (double[])z.array();
                            for (int i = 0; i < this.n; ++i) {
                                zd[this.offsetZ + i] = this.op.op(xd[this.offsetX + i], yd[this.offsetY + i]);
                            }
                        }
                    } else if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i * this.incrX;
                            xd[xIdx] = this.op.op(xd[xIdx], yd[this.offsetY + i * this.incrY]);
                        }
                    } else {
                        double[] zd = (double[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zd[this.offsetZ + i * this.incrZ] = this.op.op(xd[this.offsetX + i * this.incrX], yd[this.offsetY + i * this.incrY]);
                        }
                    }
                }
            } else {
                ByteBuffer nbbx = x.asNio();
                ByteBuffer nbby = y.asNio();
                ByteBuffer nbbz = z.asNio();
                if (x.dataType() == DataBuffer.Type.FLOAT) {
                    int byteOffsetX = this.offsetX;
                    int byteOffsetY = this.offsetY;
                    int byteOffsetZ = this.offsetZ;
                    FloatBuffer floatBufferX = nbbx.asFloatBuffer();
                    FloatBuffer floatBufferY = nbby.asFloatBuffer();
                    FloatBuffer floatBufferZ = nbbz.asFloatBuffer();
                    if (this.incrX == 1 && this.incrY == 1 && (x == z || this.incrZ == 1)) {
                        if (x == z) {
                            for (int i = 0; i < this.n; ++i) {
                                int xbOffset = byteOffsetX + i;
                                floatBufferX.put(xbOffset, this.op.op(floatBufferX.get(xbOffset), floatBufferY.get(byteOffsetY + i)));
                            }
                        } else {
                            for (int i = 0; i < this.n; ++i) {
                                floatBufferZ.put(byteOffsetZ + i, this.op.op(floatBufferX.get(byteOffsetX + i), floatBufferY.get(byteOffsetY + i)));
                            }
                        }
                    } else if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xbOffset = byteOffsetX + i * this.incrX;
                            floatBufferX.put(xbOffset, this.op.op(floatBufferX.get(xbOffset), floatBufferY.get(byteOffsetY + i * this.incrY)));
                        }
                    } else {
                        for (int i = 0; i < 4 * this.n; ++i) {
                            floatBufferZ.put(byteOffsetZ + i * this.incrZ, this.op.op(floatBufferX.get(byteOffsetX + i * this.incrX), floatBufferY.get(byteOffsetY + i * this.incrY)));
                        }
                    }
                } else {
                    int byteOffsetX = this.offsetX;
                    int byteOffsetY = this.offsetY;
                    int byteOffsetZ = this.offsetZ;
                    DoubleBuffer doubleBufferX = nbbx.asDoubleBuffer();
                    DoubleBuffer doubleBufferY = nbby.asDoubleBuffer();
                    DoubleBuffer doubleBufferZ = nbbz.asDoubleBuffer();
                    if (this.incrX == 1 && this.incrY == 1 && (x == z || this.incrZ == 1)) {
                        if (x == z) {
                            for (int i = 0; i < this.n; ++i) {
                                int xbOffset = byteOffsetX + i;
                                doubleBufferX.put(xbOffset, this.op.op(doubleBufferX.get(xbOffset), doubleBufferY.get(byteOffsetY + i)));
                            }
                        } else {
                            for (int i = 0; i < this.n; ++i) {
                                doubleBufferZ.put(byteOffsetZ + i, this.op.op(doubleBufferX.get(byteOffsetX + i), doubleBufferY.get(byteOffsetY + i)));
                            }
                        }
                    } else if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xbOffset = byteOffsetX + i * this.incrX;
                            doubleBufferX.put(xbOffset, this.op.op(doubleBufferX.get(xbOffset), doubleBufferY.get(byteOffsetY + i * this.incrY)));
                        }
                    } else {
                        for (int i = 0; i < this.n; ++i) {
                            doubleBufferZ.put(byteOffsetZ + i * this.incrZ, this.op.op(doubleBufferX.get(byteOffsetX + i * this.incrX), doubleBufferY.get(byteOffsetY + i * this.incrY)));
                        }
                    }
                }
            }
        } else if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                float[] xf = (float[])x.array();
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i;
                            xf[xIdx] = this.op.op(xf[xIdx]);
                        }
                    } else {
                        float[] zf = (float[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zf[this.offsetZ + i] = this.op.op(xf[this.offsetX + i]);
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xIdx = this.offsetX + i * this.incrX;
                        xf[xIdx] = this.op.op(xf[xIdx]);
                    }
                } else {
                    float[] zf = (float[])z.array();
                    for (int i = 0; i < this.n; ++i) {
                        zf[this.offsetZ + i * this.incrZ] = this.op.op(xf[this.offsetX + i * this.incrX]);
                    }
                }
            } else {
                double[] xd = (double[])x.array();
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i;
                            xd[xIdx] = this.op.op(xd[xIdx]);
                        }
                    } else {
                        double[] zd = (double[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zd[this.offsetZ + i] = this.op.op(xd[this.offsetX + i]);
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xIdx = this.offsetX + i * this.incrX;
                        xd[xIdx] = this.op.op(xd[xIdx]);
                    }
                } else {
                    double[] zd = (double[])z.array();
                    for (int i = 0; i < this.n; ++i) {
                        zd[this.offsetZ + i * this.incrZ] = this.op.op(xd[this.offsetX + i * this.incrX]);
                    }
                }
            }
        } else {
            ByteBuffer nbbx = x.asNio();
            ByteBuffer nbbz = z.asNio();
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                int byteOffsetX = this.offsetX;
                int byteOffsetZ = this.offsetZ;
                FloatBuffer floatBufferX = nbbx.asFloatBuffer();
                FloatBuffer floatBufferZ = nbbz.asFloatBuffer();
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xbOffset = byteOffsetX + i;
                            floatBufferX.put(xbOffset, this.op.op(floatBufferX.get(xbOffset)));
                        }
                    } else {
                        for (int i = 0; i < this.n; ++i) {
                            floatBufferZ.put(byteOffsetZ + i, this.op.op(floatBufferX.get(byteOffsetX + i)));
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xbOffset = byteOffsetX + i * this.incrX;
                        floatBufferX.put(xbOffset, this.op.op(nbbx.getFloat(xbOffset)));
                    }
                } else {
                    for (int i = 0; i < this.n; ++i) {
                        floatBufferZ.put(byteOffsetZ + i * this.incrZ, this.op.op(floatBufferX.get(byteOffsetX + i * this.incrX)));
                    }
                }
            } else {
                int byteOffsetX = this.offsetX;
                int byteOffsetZ = this.offsetZ;
                DoubleBuffer doubleBufferX = nbbx.asDoubleBuffer();
                DoubleBuffer doubleBufferZ = nbbz.asDoubleBuffer();
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xbOffset = byteOffsetX + i;
                            doubleBufferX.put(xbOffset, this.op.op(doubleBufferX.get(xbOffset)));
                        }
                    } else {
                        for (int i = 0; i < this.n; ++i) {
                            doubleBufferZ.put(byteOffsetZ + i, this.op.op(doubleBufferX.get(byteOffsetX + i)));
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xbOffset = byteOffsetX + i * this.incrX;
                        doubleBufferX.put(xbOffset, this.op.op(doubleBufferX.get(xbOffset)));
                    }
                } else {
                    for (int i = 0; i < this.n; ++i) {
                        doubleBufferZ.put(byteOffsetZ + i * this.incrZ, this.op.op(doubleBufferX.get(byteOffsetX + i * this.incrX)));
                    }
                }
            }
        }
    }
}

