/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks.cpu.scalar;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ops.ScalarOp;
import org.nd4j.linalg.api.parallel.tasks.cpu.scalar.BaseCPUScalarOpAction;

public class CPUScalarOpAction
extends BaseCPUScalarOpAction {
    public CPUScalarOpAction(ScalarOp op, int threshold, int n, int offsetX, int offsetZ, int incrX, int incrZ) {
        super(op, threshold, n, offsetX, offsetZ, incrX, incrZ);
    }

    public CPUScalarOpAction(ScalarOp op, int threshold) {
        super(op, threshold);
    }

    public CPUScalarOpAction(ScalarOp op, int threshold, int tadIdx, int tadDim) {
        super(op, threshold, tadIdx, tadDim);
    }

    @Override
    public Void call() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nSubTasks = 1 + this.n / this.threshold;
            this.subTasks = new ArrayList(nSubTasks);
            int taskSize = this.n / nSubTasks;
            int soFar = 0;
            for (int i = 0; i < nSubTasks; ++i) {
                int nInTask = i == nSubTasks - 1 ? this.n - soFar : taskSize;
                int offsetXNew = this.offsetX + soFar * this.incrX;
                int offsetZNew = this.offsetZ + soFar * this.incrZ;
                CPUScalarOpAction t = new CPUScalarOpAction(this.op, this.threshold, nInTask, offsetXNew, offsetZNew, this.incrX, this.incrZ);
                t.invokeAsync();
                this.subTasks.add(t);
                soFar += nInTask;
            }
        } else {
            this.execute();
        }
        return null;
    }

    @Override
    protected void compute() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        if (this.n > this.threshold) {
            int nFirst = this.n / 2;
            CPUScalarOpAction first = new CPUScalarOpAction(this.op, this.threshold, nFirst, this.offsetX, this.offsetZ, this.incrX, this.incrZ);
            first.fork();
            int nSecond = this.n - nFirst;
            int offsetX2 = this.offsetX + nFirst * this.incrX;
            int offsetZ2 = this.offsetZ + nFirst * this.incrZ;
            CPUScalarOpAction second = new CPUScalarOpAction(this.op, this.threshold, nSecond, offsetX2, offsetZ2, this.incrX, this.incrZ);
            second.fork();
            first.join();
            second.join();
        } else {
            this.execute();
        }
    }

    private void execute() {
        if (this.doTensorFirst) {
            this.doTensorFirst(this.op);
        }
        DataBuffer x = this.op.x().data();
        DataBuffer z = this.op.z().data();
        if (x.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                float[] xf = (float[])x.array();
                if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i;
                            xf[xIdx] = this.op.op(xf[xIdx]);
                        }
                    } else {
                        float[] zf = (float[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zf[this.offsetZ + i] = this.op.op(xf[this.offsetX + i]);
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xIdx = this.offsetX + i * this.incrX;
                        xf[xIdx] = this.op.op(xf[xIdx]);
                    }
                } else {
                    float[] zf = (float[])z.array();
                    for (int i = 0; i < this.n; ++i) {
                        zf[this.offsetZ + i * this.incrZ] = this.op.op(xf[this.offsetX + i * this.incrX]);
                    }
                }
            } else {
                double[] xd = (double[])x.array();
                if (this.incrX == 1 && this.incrZ == 1) {
                    if (x == z) {
                        for (int i = 0; i < this.n; ++i) {
                            int xIdx = this.offsetX + i;
                            xd[xIdx] = this.op.op(xd[xIdx]);
                        }
                    } else {
                        double[] zd = (double[])z.array();
                        for (int i = 0; i < this.n; ++i) {
                            zd[this.offsetZ + i] = this.op.op(xd[this.offsetX + i]);
                        }
                    }
                } else if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xIdx = this.offsetX + i * this.incrX;
                        xd[xIdx] = this.op.op(xd[xIdx]);
                    }
                } else {
                    double[] zd = (double[])z.array();
                    for (int i = 0; i < this.n; ++i) {
                        zd[this.offsetZ + i * this.incrZ] = this.op.op(xd[this.offsetX + i * this.incrX]);
                    }
                }
            }
        } else if (x.dataType() == DataBuffer.Type.FLOAT) {
            FloatBuffer xFloatBuffer = x.asNioFloat();
            FloatBuffer zFloatBuffer = z.asNioFloat();
            int byteOffsetX = 0;
            int byteOffsetZ = 0;
            if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                if (x == z) {
                    for (int i = 0; i < this.n; ++i) {
                        int xbIdx = byteOffsetX + i;
                        xFloatBuffer.put(i, this.op.op(xFloatBuffer.get(xbIdx)));
                    }
                } else {
                    for (int i = 0; i < this.n; ++i) {
                        zFloatBuffer.put(byteOffsetZ + i, this.op.op(xFloatBuffer.get(byteOffsetX + i)));
                    }
                }
            } else if (x == z) {
                for (int i = 0; i < this.n; ++i) {
                    int xbIdx = byteOffsetX + i * this.incrX;
                    xFloatBuffer.put(xbIdx, this.op.op(xFloatBuffer.get(xbIdx)));
                }
            } else {
                for (int i = 0; i < this.n; ++i) {
                    zFloatBuffer.put(byteOffsetZ + i * this.incrZ, this.op.op(xFloatBuffer.get(byteOffsetX + i * this.incrX)));
                }
            }
        } else {
            int byteOffsetX = this.offsetX;
            int byteOffsetZ = this.offsetZ;
            DoubleBuffer xDoubleBuffer = x.asNioDouble();
            DoubleBuffer zDoubleBuffer = z.asNioDouble();
            if (this.incrX == 1 && (x == z || this.incrZ == 1)) {
                if (x == z) {
                    int i = 0;
                    while (i < this.n) {
                        int xbIdx = i++;
                        xDoubleBuffer.put(xbIdx, this.op.op(xDoubleBuffer.get(xbIdx)));
                    }
                } else {
                    for (int i = 0; i < this.n; ++i) {
                        zDoubleBuffer.put(i, this.op.op(xDoubleBuffer.get(i)));
                    }
                }
            } else if (x == z) {
                for (int i = 0; i < this.n; ++i) {
                    int xbIdx = i * this.incrX;
                    xDoubleBuffer.put(xbIdx, this.op.op(xDoubleBuffer.get(xbIdx)));
                }
            } else {
                for (int i = 0; i < this.n; ++i) {
                    zDoubleBuffer.put(i * this.incrZ, this.op.op(xDoubleBuffer.get(i * this.incrX)));
                }
            }
        }
    }
}

