/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import org.nd4j.linalg.api.parallel.tasks.Task;
import org.nd4j.linalg.api.parallel.tasks.TaskExecutor;
import org.nd4j.linalg.executors.ExecutorServiceProvider;

public class DefaultTaskExecutor
implements TaskExecutor {
    private static DefaultTaskExecutor instance = new DefaultTaskExecutor();
    private ExecutorService executorService;
    private ForkJoinPool forkJoinPool;

    public static DefaultTaskExecutor getInstance() {
        return instance;
    }

    @Override
    public <V> Future<V> executeAsync(Task<V> task) {
        if (task instanceof ForkJoinTask) {
            if (this.forkJoinPool == null) {
                this.forkJoinPool = ExecutorServiceProvider.getForkJoinPool();
            }
            this.forkJoinPool.execute((ForkJoinTask)((Object)task));
            return (Future)((Object)task);
        }
        if (this.executorService == null) {
            this.executorService = ExecutorServiceProvider.getExecutorService();
        }
        return this.executorService.submit(task);
    }
}

