/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseAccumulation
extends BaseOp
implements Accumulation {
    protected Number finalResult;
    protected IComplexNumber finalResultComplex;
    protected boolean applyFinalTransform = true;

    public BaseAccumulation() {
    }

    public BaseAccumulation(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
        this.init();
    }

    public BaseAccumulation(INDArray x, INDArray y, int n) {
        this(x, y, x, n);
    }

    public BaseAccumulation(INDArray x) {
        this(x, null, x, x.length());
    }

    public BaseAccumulation(INDArray x, INDArray y) {
        this(x, y, x, x.length());
    }

    private void init() {
        this.init(this.x, this.y, this.x, this.x.length());
    }

    @Override
    public boolean applyFinalTransform() {
        return this.applyFinalTransform;
    }

    @Override
    public void setApplyFinalTransform(boolean applyFinalTransform) {
        this.applyFinalTransform = applyFinalTransform;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public double op(double origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public double zeroDouble() {
        return 0.0;
    }

    @Override
    public float zeroFloat() {
        return 0.0f;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public int numProcessed() {
        return this.numProcessed;
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        this.extraArgs = new Object[]{this.zeroDouble()};
    }

    @Override
    public double combineSubResults(double first, double second) {
        return this.update(first, second);
    }

    @Override
    public float combineSubResults(float first, float second) {
        return this.update(first, second);
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return this.update(first, second);
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        this.finalResult = accum;
        return accum;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        this.finalResult = Float.valueOf(accum);
        return accum;
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = accum;
        return accum;
    }

    @Override
    public double calculateFinalResult(double accum, int n) {
        return accum;
    }

    @Override
    public float calculateFinalResult(float accum, int n) {
        return accum;
    }

    @Override
    public Number currentResult() {
        return this.finalResult;
    }

    @Override
    public void setFinalResult(Number number) {
        this.finalResult = number;
    }

    @Override
    public void setFinalResultComplex(IComplexNumber number) {
        this.finalResultComplex = number;
    }

    @Override
    public Number getFinalResult() {
        return this.finalResult;
    }

    @Override
    public IComplexNumber getFinalResultComplex() {
        return this.finalResultComplex;
    }
}

