/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.io.Serializable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.GradientUpdater;

public class Nesterovs
implements Serializable,
GradientUpdater {
    private double momentum = 0.5;
    private INDArray v;
    private double learningRate = 0.1;

    public Nesterovs(double momentum, double learningRate) {
        this.momentum = momentum;
        this.learningRate = learningRate;
    }

    public Nesterovs(double momentum) {
        this.momentum = momentum;
    }

    @Override
    public void update(Object ... args) {
        if (args.length > 0) {
            this.learningRate = (Double)args[0];
            this.momentum = (Double)args[1];
        }
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        if (this.v == null) {
            this.v = Nd4j.zeros(gradient.shape());
        }
        INDArray vPrev = this.v;
        this.v = vPrev.mul(this.momentum).subi(gradient.mul(this.learningRate));
        INDArray ret = vPrev.muli(this.momentum).addi(this.v.mul(-this.momentum - 1.0));
        return ret;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public INDArray getV() {
        return this.v;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    public void setV(INDArray v) {
        this.v = v;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nesterovs)) {
            return false;
        }
        Nesterovs other = (Nesterovs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
            return false;
        }
        INDArray this$v = this.getV();
        INDArray other$v = other.getV();
        if (this$v == null ? other$v != null : !this$v.equals(other$v)) {
            return false;
        }
        return Double.compare(this.getLearningRate(), other.getLearningRate()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Nesterovs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $momentum = Double.doubleToLongBits(this.getMomentum());
        result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
        INDArray $v = this.getV();
        result = result * 59 + ($v == null ? 0 : $v.hashCode());
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        return result;
    }

    public String toString() {
        return "Nesterovs(momentum=" + this.getMomentum() + ", v=" + this.getV() + ", learningRate=" + this.getLearningRate() + ")";
    }

    public Nesterovs() {
    }
}

