/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape.loop.three;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.StridePermutation;
import org.nd4j.linalg.util.ArrayUtil;

public class RawArrayIterationInformation3
implements Serializable {
    private int nDim;
    private int aOffset = -1;
    private int bOffset = -1;
    private int cOffset = 1;
    private int[] aStrides;
    private int[] bStrides;
    private int[] cStrides;
    private int[] shape;
    private DataBuffer a;
    private DataBuffer b;
    private DataBuffer c;

    public RawArrayIterationInformation3 computeOut() {
        int i;
        int aOffset = this.aOffset;
        int bOffset = this.bOffset;
        int[] aStrides = ArrayUtil.copy(this.aStrides);
        int[] bStrides = ArrayUtil.copy(this.bStrides);
        int[] cStrides = ArrayUtil.combine(new int[][]{this.cStrides});
        int[] shape = ArrayUtil.copy(this.shape);
        int nDim = this.nDim;
        StridePermutation[] perms = Shape.createSortedStrides(aStrides);
        for (i = 0; i < nDim; ++i) {
            int iPerm = perms[nDim - i - 1].getPermutation();
            shape[i] = this.shape[iPerm];
            aStrides[i] = aStrides[iPerm];
            bStrides[i] = bStrides[iPerm];
        }
        for (i = 0; i < nDim; ++i) {
            int outStrideA = aStrides[i];
            int outStrideB = bStrides[i];
            int outStrideC = cStrides[i];
            int shapeI = shape[i];
            if (outStrideA >= 0) continue;
            aOffset += outStrideA * shapeI - 1;
            bOffset += outStrideB * shapeI - 1;
            this.cOffset += outStrideC * shapeI - 1;
            int n = i;
            aStrides[n] = aStrides[n] - outStrideA;
            int n2 = i;
            bStrides[n2] = bStrides[n2] - outStrideB;
            int n3 = i;
            cStrides[n3] = cStrides[n3] - outStrideC;
        }
        i = 0;
        for (int j = 1; j < nDim; ++j) {
            if (shape[i] == 1) {
                shape[i] = shape[j];
                aStrides[i] = aStrides[j];
                bStrides[i] = aStrides[j];
                cStrides[i] = cStrides[j];
                continue;
            }
            if (shape[j] == 1) continue;
            if (aStrides[i] * shape[i] == aStrides[j] && bStrides[i] * shape[i] == bStrides[j] && cStrides[i] * shape[i] == cStrides[j]) {
                int n = i;
                shape[n] = shape[n] * shape[j];
                continue;
            }
            shape[++i] = shape[j];
            aStrides[i] = aStrides[j];
            bStrides[i] = bStrides[j];
            cStrides[i] = cStrides[j];
        }
        nDim = i + 1;
        return RawArrayIterationInformation3.builder().aOffset(aOffset).bOffset(bOffset).aStrides(aStrides).bStrides(bStrides).a(this.a).b(this.b).c(this.c).shape(shape).nDim(nDim).build();
    }

    public static RawArrayIterationInformation3Builder builder() {
        return new RawArrayIterationInformation3Builder();
    }

    public int getNDim() {
        return this.nDim;
    }

    public int getAOffset() {
        return this.aOffset;
    }

    public int getBOffset() {
        return this.bOffset;
    }

    public int getCOffset() {
        return this.cOffset;
    }

    public int[] getAStrides() {
        return this.aStrides;
    }

    public int[] getBStrides() {
        return this.bStrides;
    }

    public int[] getCStrides() {
        return this.cStrides;
    }

    public int[] getShape() {
        return this.shape;
    }

    public DataBuffer getA() {
        return this.a;
    }

    public DataBuffer getB() {
        return this.b;
    }

    public DataBuffer getC() {
        return this.c;
    }

    public void setNDim(int nDim) {
        this.nDim = nDim;
    }

    public void setAOffset(int aOffset) {
        this.aOffset = aOffset;
    }

    public void setBOffset(int bOffset) {
        this.bOffset = bOffset;
    }

    public void setCOffset(int cOffset) {
        this.cOffset = cOffset;
    }

    public void setAStrides(int[] aStrides) {
        this.aStrides = aStrides;
    }

    public void setBStrides(int[] bStrides) {
        this.bStrides = bStrides;
    }

    public void setCStrides(int[] cStrides) {
        this.cStrides = cStrides;
    }

    public void setShape(int[] shape) {
        this.shape = shape;
    }

    public void setA(DataBuffer a) {
        this.a = a;
    }

    public void setB(DataBuffer b) {
        this.b = b;
    }

    public void setC(DataBuffer c) {
        this.c = c;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawArrayIterationInformation3)) {
            return false;
        }
        RawArrayIterationInformation3 other = (RawArrayIterationInformation3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNDim() != other.getNDim()) {
            return false;
        }
        if (this.getAOffset() != other.getAOffset()) {
            return false;
        }
        if (this.getBOffset() != other.getBOffset()) {
            return false;
        }
        if (this.getCOffset() != other.getCOffset()) {
            return false;
        }
        if (!Arrays.equals(this.getAStrides(), other.getAStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getBStrides(), other.getBStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getCStrides(), other.getCStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getShape(), other.getShape())) {
            return false;
        }
        DataBuffer this$a = this.getA();
        DataBuffer other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        DataBuffer this$b = this.getB();
        DataBuffer other$b = other.getB();
        if (this$b == null ? other$b != null : !this$b.equals(other$b)) {
            return false;
        }
        DataBuffer this$c = this.getC();
        DataBuffer other$c = other.getC();
        return !(this$c == null ? other$c != null : !this$c.equals(other$c));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawArrayIterationInformation3;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNDim();
        result = result * 59 + this.getAOffset();
        result = result * 59 + this.getBOffset();
        result = result * 59 + this.getCOffset();
        result = result * 59 + Arrays.hashCode(this.getAStrides());
        result = result * 59 + Arrays.hashCode(this.getBStrides());
        result = result * 59 + Arrays.hashCode(this.getCStrides());
        result = result * 59 + Arrays.hashCode(this.getShape());
        DataBuffer $a = this.getA();
        result = result * 59 + ($a == null ? 0 : $a.hashCode());
        DataBuffer $b = this.getB();
        result = result * 59 + ($b == null ? 0 : $b.hashCode());
        DataBuffer $c = this.getC();
        result = result * 59 + ($c == null ? 0 : $c.hashCode());
        return result;
    }

    public String toString() {
        return "RawArrayIterationInformation3(nDim=" + this.getNDim() + ", aOffset=" + this.getAOffset() + ", bOffset=" + this.getBOffset() + ", cOffset=" + this.getCOffset() + ", aStrides=" + Arrays.toString(this.getAStrides()) + ", bStrides=" + Arrays.toString(this.getBStrides()) + ", cStrides=" + Arrays.toString(this.getCStrides()) + ", shape=" + Arrays.toString(this.getShape()) + ", a=" + this.getA() + ", b=" + this.getB() + ", c=" + this.getC() + ")";
    }

    @ConstructorProperties(value={"nDim", "aOffset", "bOffset", "cOffset", "aStrides", "bStrides", "cStrides", "shape", "a", "b", "c"})
    public RawArrayIterationInformation3(int nDim, int aOffset, int bOffset, int cOffset, int[] aStrides, int[] bStrides, int[] cStrides, int[] shape, DataBuffer a, DataBuffer b, DataBuffer c) {
        this.nDim = nDim;
        this.aOffset = aOffset;
        this.bOffset = bOffset;
        this.cOffset = cOffset;
        this.aStrides = aStrides;
        this.bStrides = bStrides;
        this.cStrides = cStrides;
        this.shape = shape;
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public RawArrayIterationInformation3() {
    }

    public static class RawArrayIterationInformation3Builder {
        private int nDim;
        private int aOffset;
        private int bOffset;
        private int cOffset;
        private int[] aStrides;
        private int[] bStrides;
        private int[] cStrides;
        private int[] shape;
        private DataBuffer a;
        private DataBuffer b;
        private DataBuffer c;

        RawArrayIterationInformation3Builder() {
        }

        public RawArrayIterationInformation3Builder nDim(int nDim) {
            this.nDim = nDim;
            return this;
        }

        public RawArrayIterationInformation3Builder aOffset(int aOffset) {
            this.aOffset = aOffset;
            return this;
        }

        public RawArrayIterationInformation3Builder bOffset(int bOffset) {
            this.bOffset = bOffset;
            return this;
        }

        public RawArrayIterationInformation3Builder cOffset(int cOffset) {
            this.cOffset = cOffset;
            return this;
        }

        public RawArrayIterationInformation3Builder aStrides(int[] aStrides) {
            this.aStrides = aStrides;
            return this;
        }

        public RawArrayIterationInformation3Builder bStrides(int[] bStrides) {
            this.bStrides = bStrides;
            return this;
        }

        public RawArrayIterationInformation3Builder cStrides(int[] cStrides) {
            this.cStrides = cStrides;
            return this;
        }

        public RawArrayIterationInformation3Builder shape(int[] shape) {
            this.shape = shape;
            return this;
        }

        public RawArrayIterationInformation3Builder a(DataBuffer a) {
            this.a = a;
            return this;
        }

        public RawArrayIterationInformation3Builder b(DataBuffer b) {
            this.b = b;
            return this;
        }

        public RawArrayIterationInformation3Builder c(DataBuffer c) {
            this.c = c;
            return this;
        }

        public RawArrayIterationInformation3 build() {
            return new RawArrayIterationInformation3(this.nDim, this.aOffset, this.bOffset, this.cOffset, this.aStrides, this.bStrides, this.cStrides, this.shape, this.a, this.b, this.c);
        }

        public String toString() {
            return "RawArrayIterationInformation3.RawArrayIterationInformation3Builder(nDim=" + this.nDim + ", aOffset=" + this.aOffset + ", bOffset=" + this.bOffset + ", cOffset=" + this.cOffset + ", aStrides=" + Arrays.toString(this.aStrides) + ", bStrides=" + Arrays.toString(this.bStrides) + ", cStrides=" + Arrays.toString(this.cStrides) + ", shape=" + Arrays.toString(this.shape) + ", a=" + this.a + ", b=" + this.b + ", c=" + this.c + ")";
        }
    }
}

