/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Sum;

public class Mean
extends Sum {
    public Mean() {
    }

    public Mean(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Mean(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public Mean(INDArray x) {
        super(x);
    }

    public Mean(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public String name() {
        return "mean";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Mean(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Mean(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Mean(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Mean(this.x.tensorAlongDimension(index, dimension));
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        double d = accum / (double)this.n();
        this.finalResult = d;
        return d;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        float f = accum / (float)this.n();
        this.finalResult = Float.valueOf(f);
        return f;
    }

    @Override
    public double calculateFinalResult(double accum, int n) {
        return accum / (double)n;
    }

    @Override
    public float calculateFinalResult(float accum, int n) {
        return accum / (float)n;
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = accum.div(this.n());
        return this.finalResultComplex;
    }
}

