/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.ops.transforms.Transforms;

public class RmsProp
implements GradientUpdater {
    private INDArray lastGradient;
    private double rmsDecay = 0.95;
    private double learningRate = 0.1;
    private double epsilon = 1.0E-8;

    public RmsProp(double learningRate, double rmsDecay) {
        this.learningRate = learningRate;
        this.rmsDecay = rmsDecay;
    }

    @Override
    public void update(Object ... args) {
        if (args.length > 0) {
            this.learningRate = (Double)args[0];
        }
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        if (this.lastGradient == null) {
            this.lastGradient = Nd4j.zeros(gradient.shape());
        }
        this.lastGradient.muli(this.rmsDecay).addi(gradient.mul(gradient).muli(1.0 - this.rmsDecay));
        INDArray ret = gradient.mul(this.learningRate).divi(Transforms.sqrt(this.lastGradient.add(this.epsilon)));
        return ret;
    }

    public INDArray getLastGradient() {
        return this.lastGradient;
    }

    public double getRmsDecay() {
        return this.rmsDecay;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setLastGradient(INDArray lastGradient) {
        this.lastGradient = lastGradient;
    }

    public void setRmsDecay(double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RmsProp)) {
            return false;
        }
        RmsProp other = (RmsProp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$lastGradient = this.getLastGradient();
        INDArray other$lastGradient = other.getLastGradient();
        if (this$lastGradient == null ? other$lastGradient != null : !this$lastGradient.equals(other$lastGradient)) {
            return false;
        }
        if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        return Double.compare(this.getEpsilon(), other.getEpsilon()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof RmsProp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $lastGradient = this.getLastGradient();
        result = result * 59 + ($lastGradient == null ? 0 : $lastGradient.hashCode());
        long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
        result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        return result;
    }

    public String toString() {
        return "RmsProp(lastGradient=" + this.getLastGradient() + ", rmsDecay=" + this.getRmsDecay() + ", learningRate=" + this.getLearningRate() + ", epsilon=" + this.getEpsilon() + ")";
    }

    public RmsProp() {
    }
}

