/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.ops.transforms.Transforms;

public class Adam
implements Serializable,
GradientUpdater {
    private double learningRate = 0.001;
    private double beta1 = 0.9;
    private double beta2 = 0.999;
    private double epsilon = 1.0E-8;
    private INDArray m;
    private INDArray v;
    private double momentum = 0.5;

    public Adam(double alpha, double beta1, double beta2, double epsilon) {
        this.learningRate = alpha;
        this.beta1 = beta1;
        this.beta2 = beta2;
        this.epsilon = epsilon;
    }

    public Adam(double alpha, double beta1, double beta2) {
        this.learningRate = alpha;
        this.beta1 = beta1;
        this.beta2 = beta2;
    }

    public Adam(double alpha) {
        this.learningRate = alpha;
    }

    @Override
    public void update(Object ... args) {
        if (args.length > 0) {
            this.learningRate = (Double)args[0];
        }
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        if (this.m == null) {
            this.m = Nd4j.zeros(gradient.shape());
        }
        if (this.v == null) {
            this.v = Nd4j.zeros(gradient.shape());
        }
        INDArray oneMinusBeta1Grad = gradient.mul(1.0 - this.beta1);
        this.m.muli(this.beta1).addi(oneMinusBeta1Grad);
        INDArray oneMinusBeta2GradSquared = gradient.mul(gradient).muli(1.0 - this.beta2);
        this.v.muli(this.beta2).addi(oneMinusBeta2GradSquared);
        double beta1t = FastMath.pow((double)this.beta1, (int)iteration);
        double beta2t = FastMath.pow((double)this.beta2, (int)iteration);
        double alphat = this.learningRate * FastMath.sqrt((double)(1.0 - beta2t)) / (1.0 - beta1t);
        if (Double.isNaN(alphat) || alphat == 0.0) {
            alphat = Nd4j.EPS_THRESHOLD;
        }
        INDArray sqrtV = Transforms.sqrt(this.v).addi(this.epsilon);
        INDArray ret = this.m.mul(alphat).divi(sqrtV);
        return ret;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getBeta1() {
        return this.beta1;
    }

    public double getBeta2() {
        return this.beta2;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public INDArray getM() {
        return this.m;
    }

    public INDArray getV() {
        return this.v;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setBeta1(double beta1) {
        this.beta1 = beta1;
    }

    public void setBeta2(double beta2) {
        this.beta2 = beta2;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setM(INDArray m) {
        this.m = m;
    }

    public void setV(INDArray v) {
        this.v = v;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Adam)) {
            return false;
        }
        Adam other = (Adam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta1(), other.getBeta1()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta2(), other.getBeta2()) != 0) {
            return false;
        }
        if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
            return false;
        }
        INDArray this$m = this.getM();
        INDArray other$m = other.getM();
        if (this$m == null ? other$m != null : !this$m.equals(other$m)) {
            return false;
        }
        INDArray this$v = this.getV();
        INDArray other$v = other.getV();
        if (this$v == null ? other$v != null : !this$v.equals(other$v)) {
            return false;
        }
        return Double.compare(this.getMomentum(), other.getMomentum()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Adam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $beta1 = Double.doubleToLongBits(this.getBeta1());
        result = result * 59 + (int)($beta1 >>> 32 ^ $beta1);
        long $beta2 = Double.doubleToLongBits(this.getBeta2());
        result = result * 59 + (int)($beta2 >>> 32 ^ $beta2);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        INDArray $m = this.getM();
        result = result * 59 + ($m == null ? 0 : $m.hashCode());
        INDArray $v = this.getV();
        result = result * 59 + ($v == null ? 0 : $v.hashCode());
        long $momentum = Double.doubleToLongBits(this.getMomentum());
        result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
        return result;
    }

    public String toString() {
        return "Adam(learningRate=" + this.getLearningRate() + ", beta1=" + this.getBeta1() + ", beta2=" + this.getBeta2() + ", epsilon=" + this.getEpsilon() + ", m=" + this.getM() + ", v=" + this.getV() + ", momentum=" + this.getMomentum() + ")";
    }

    public Adam() {
    }
}

