/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.parallel.tasks;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.nd4j.linalg.api.parallel.tasks.Task;
import org.nd4j.linalg.api.parallel.tasks.TaskExecutor;

public class DefaultTaskExecutor
implements TaskExecutor {
    public static final String EXEC_THREADS = "org.nd4j.parallel.cpu.taskexecutorthreads";
    private static DefaultTaskExecutor instance = new DefaultTaskExecutor();
    private final ExecutorService executorService;
    private final ForkJoinPool forkJoinPool;

    public static DefaultTaskExecutor getInstance() {
        return instance;
    }

    public DefaultTaskExecutor() {
        int defaultThreads = Runtime.getRuntime().availableProcessors();
        int nThreads = Integer.parseInt(System.getProperty(EXEC_THREADS, String.valueOf(defaultThreads)));
        this.executorService = new ThreadPoolExecutor(nThreads, nThreads, 60L, TimeUnit.SECONDS, new LinkedTransferQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.forkJoinPool = new ForkJoinPool(nThreads);
    }

    @Override
    public <V> Future<V> executeAsync(Task<V> task) {
        if (task instanceof ForkJoinTask) {
            this.forkJoinPool.execute((ForkJoinTask)((Object)task));
            return (Future)((Object)task);
        }
        return this.executorService.submit(task);
    }
}

