/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.indexaccum;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseIndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class IMax
extends BaseIndexAccumulation {
    public IMax() {
    }

    public IMax(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public IMax(INDArray x) {
        super(x);
    }

    public IMax(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public int update(double accum, int accumIdx, double x, int xIdx) {
        return accum >= x ? accumIdx : xIdx;
    }

    @Override
    public int update(float accum, int accumIdx, float x, int xIdx) {
        return accum >= x ? accumIdx : xIdx;
    }

    @Override
    public int update(double accum, int accumIdx, double x, double y, int idx) {
        return accum >= x ? accumIdx : idx;
    }

    @Override
    public int update(float accum, int accumIdx, float x, float y, int idx) {
        return accum >= x ? accumIdx : idx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, IComplexNumber x, int xIdx) {
        return accum.absoluteValue().doubleValue() >= x.absoluteValue().doubleValue() ? accumIdx : xIdx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, double x, int idx) {
        return accum.absoluteValue().doubleValue() >= x ? accumIdx : idx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, double x, double y, int idx) {
        return accum.absoluteValue().doubleValue() >= x ? accumIdx : idx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, IComplexNumber x, IComplexNumber y, int idx) {
        return accum.absoluteValue().doubleValue() >= x.absoluteValue().doubleValue() ? accumIdx : idx;
    }

    @Override
    public String name() {
        return "imax";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin;
    }

    @Override
    public float op(float origin, float other) {
        return origin;
    }

    @Override
    public double op(double origin, double other) {
        return origin;
    }

    @Override
    public double op(double origin) {
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public float zeroFloat() {
        return -3.4028235E38f;
    }

    @Override
    public double zeroDouble() {
        return -1.7976931348623157E308;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(-1.7976931348623157E308, 0);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new IMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new IMax(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new IMax(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new IMax(this.x.tensorAlongDimension(index, dimension));
    }
}

