/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Bias;
import org.nd4j.linalg.api.ops.impl.accum.Mean;
import org.nd4j.linalg.api.ops.impl.accum.Sum;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.ComplexUtil;

public class Variance
extends BaseAccumulation {
    protected double mean;
    protected double bias;
    protected boolean biasCorrected = true;

    public Variance() {
    }

    public Variance(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
        this.passThrough = true;
    }

    public Variance(INDArray x, INDArray y, int n) {
        this(x, y, x, n);
    }

    public Variance(INDArray x) {
        this(x, null, x, x.length(), true);
    }

    public Variance(INDArray x, INDArray y) {
        super(x, y);
        this.passThrough = true;
    }

    public Variance(INDArray x, INDArray y, INDArray z, int n, boolean biasCorrected) {
        super(x, y, z, n);
        this.biasCorrected = biasCorrected;
        this.init(x, y, z, n);
        this.passThrough = true;
    }

    public Variance(INDArray x, INDArray y, int n, boolean biasCorrected) {
        super(x, y, n);
        this.biasCorrected = biasCorrected;
        this.init(x, y, this.z, n);
        this.passThrough = true;
    }

    public Variance(INDArray x, boolean biasCorrected) {
        super(x);
        this.biasCorrected = biasCorrected;
        this.init(x, this.y, this.z, this.n);
        this.passThrough = true;
    }

    public Variance(INDArray x, INDArray y, boolean biasCorrected) {
        super(x, y);
        this.biasCorrected = biasCorrected;
        this.init(x, y, x, x.length());
        this.passThrough = true;
    }

    @Override
    public double update(double accum, double x) {
        double dev = x - this.mean;
        return accum + dev * dev;
    }

    @Override
    public double update(double accum, double x, double y) {
        double dev = x - this.mean;
        return accum + dev * dev;
    }

    @Override
    public float update(float accum, float x) {
        float dev = x - (float)this.mean;
        return accum + dev * dev;
    }

    @Override
    public float update(float accum, float x, float y) {
        float dev = x - (float)this.mean;
        return accum + dev * dev;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        double dev = x - this.mean;
        return accum.add(dev * dev);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        double dev = x - this.mean;
        return accum.add(dev * dev);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        IComplexNumber dev = x.sub(this.mean);
        return accum.add(dev.mul(dev));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        IComplexNumber dev = x.sub(this.mean);
        return accum.add(dev.mul(dev));
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        IComplexNumber dev = x.sub(this.mean);
        return accum.add(dev.mul(dev));
    }

    @Override
    public String name() {
        return "var";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Variance(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Variance(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Variance(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Variance(this.x.tensorAlongDimension(index, dimension));
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
    }

    @Override
    public void exec() {
        if (this.biasCorrected) {
            this.bias = Nd4j.getExecutioner().execAndReturn(new Bias(this.x)).getFinalResult().doubleValue();
        }
        this.mean = Nd4j.getExecutioner().execAndReturn(new Mean(this.x)).getFinalResult().doubleValue();
        INDArray xSubMean = this.x.sub(this.mean);
        INDArray squared = xSubMean.muli(xSubMean);
        double accum = Nd4j.getExecutioner().execAndReturn(new Sum(squared)).getFinalResult().doubleValue();
        this.getAndSetFinalResult(accum);
    }

    @Override
    public void exec(int ... dimension) {
        int[] retShape = ArrayUtil.removeIndex(this.x.shape(), dimension);
        int nOps = this.x.tensorssAlongDimension(dimension);
        this.z = Nd4j.create(retShape);
        for (int i = 0; i < nOps; ++i) {
            double d = Nd4j.getExecutioner().execAndReturn((Variance)this.opForDimension(i, dimension)).getFinalResult().doubleValue();
            this.z.putScalar(i, d);
        }
    }

    @Override
    public double combineSubResults(double first, double second) {
        return first + second;
    }

    @Override
    public float combineSubResults(float first, float second) {
        return first + second;
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return first.add(second);
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        double result = this.biasCorrected ? (accum - FastMath.pow((double)this.bias, (double)2.0) / (double)this.n()) / ((double)this.n() - 1.0) : accum / (double)this.n;
        this.finalResult = result;
        return result;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        double result = this.biasCorrected ? ((double)accum - FastMath.pow((double)this.bias, (double)2.0) / (double)this.n()) / ((double)this.n() - 1.0) : (double)accum / (double)this.n;
        this.finalResult = result;
        return (float)result;
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = this.biasCorrected ? accum.sub(ComplexUtil.pow(Nd4j.createComplexNumber(this.bias, 0), 2.0).div(Nd4j.createComplexNumber(this.n(), 0))).div(Nd4j.createComplexNumber((double)this.n() - 1.0, 0.0)) : accum.divi(this.n - 1);
        return this.finalResultComplex;
    }

    @Override
    public double calculateFinalResult(double accum, int n) {
        if (this.biasCorrected) {
            throw new UnsupportedOperationException("Not supported for passthrough op");
        }
        return accum / (double)n;
    }

    @Override
    public float calculateFinalResult(float accum, int n) {
        if (this.biasCorrected) {
            throw new UnsupportedOperationException("Not supported for passthrough op");
        }
        return accum / (float)n;
    }
}

