/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class EuclideanDistance
extends BaseAccumulation {
    public EuclideanDistance() {
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public EuclideanDistance(INDArray x, INDArray y, int n) {
        super(x, y, n);
    }

    public EuclideanDistance(INDArray x) {
        super(x);
    }

    public EuclideanDistance(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public void update(Number result) {
        this.currentResult = this.currentResult.doubleValue() + FastMath.pow((double)result.doubleValue(), (double)2.0);
        if (this.numProcessed() == this.n) {
            this.currentResult = FastMath.sqrt((double)this.currentResult.doubleValue());
        }
    }

    @Override
    public void update(IComplexNumber result) {
        this.currentComplexResult.addi(result);
    }

    @Override
    public Number zero() {
        return 0.0;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0.0, 0.0);
    }

    @Override
    public String name() {
        return "euclidean";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        ++this.numProcessed;
        return origin.sub(other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        ++this.numProcessed;
        return origin.sub(Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        ++this.numProcessed;
        return origin.sub(other);
    }

    @Override
    public float op(float origin, float other) {
        ++this.numProcessed;
        return origin - other;
    }

    @Override
    public double op(double origin, double other) {
        ++this.numProcessed;
        return origin - other;
    }

    @Override
    public double op(double origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public float op(float origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        ++this.numProcessed;
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xForDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new EuclideanDistance(xForDimension, this.y.vectorAlongDimension(index, dimension), xForDimension.length());
        }
        return new EuclideanDistance(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xForDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new EuclideanDistance(xForDimension, this.y.tensorAlongDimension(index, dimension), xForDimension.length());
        }
        return new EuclideanDistance(this.x.tensorAlongDimension(index, dimension));
    }
}

