/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.BaseNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.Indices;

@Deprecated
public class LinearViewNDArray
extends BaseNDArray {
    private INDArray wrapped;
    private List<INDArray> vectors;

    public LinearViewNDArray(INDArray wrapped) {
        if (wrapped.getLeadingOnes() > 0 || wrapped.getTrailingOnes() > 0) {
            wrapped = Nd4j.create(wrapped.data(), Shape.squeeze(wrapped.shape()));
        }
        this.wrapped = wrapped;
        this.shape = new int[]{1, wrapped.length()};
        this.data = wrapped.data();
        this.offset = wrapped.offset();
        this.ordering = wrapped.ordering();
        this.length = wrapped.length();
        this.vectors = new ArrayList<INDArray>();
        this.collectRows(wrapped);
    }

    protected void collectRows(INDArray slice) {
        if (slice.isRowVector()) {
            this.vectors.add(slice);
        } else if (this.isMatrix()) {
            for (int i = 0; i < slice.rows(); ++i) {
                this.vectors.add(slice.getRow(i));
            }
        } else if (!slice.isVector() && slice.size(0) == 1) {
            if (Shape.isVector((slice = Nd4j.create(slice.data(), Shape.squeeze(slice.shape()))).shape())) {
                this.vectors.add(slice);
            } else {
                for (int i = 0; i < slice.slices(); ++i) {
                    this.collectRows(slice.slice(i));
                }
            }
        } else {
            for (int i = 0; i < slice.slices(); ++i) {
                this.collectRows(slice.slice(i));
            }
        }
    }

    @Override
    public boolean isCleanedUp() {
        return this.wrapped.isCleanedUp();
    }

    @Override
    public void cleanup() {
        this.wrapped.cleanup();
    }

    @Override
    public void resetLinearView() {
    }

    @Override
    public int secondaryStride() {
        return this.wrapped.secondaryStride();
    }

    @Override
    public int majorStride() {
        return this.wrapped.majorStride();
    }

    @Override
    public INDArray linearView() {
        return this;
    }

    @Override
    public INDArray linearViewColumnOrder() {
        return this;
    }

    @Override
    public int vectorsAlongDimension(int dimension) {
        if (dimension > 1) {
            throw new IllegalArgumentException("Linear view does not have dimensions greater than 1");
        }
        return 1;
    }

    @Override
    public INDArray vectorAlongDimension(int index, int dimension) {
        if (dimension == 0 || dimension == 1 && index == 0) {
            return this;
        }
        throw new IllegalArgumentException("Index must be 0 and dimension must be 0 or 1");
    }

    @Override
    public INDArray putScalar(int i, double value) {
        int vectorSize = this.wrapped.size(-1);
        int vectorIdx = Indices.rowNumber(i, this.wrapped);
        INDArray currVector = this.vectors.get(vectorIdx);
        int offset = vectorSize * vectorIdx;
        int idx = i - offset;
        currVector.putScalar(idx, value);
        return this;
    }

    @Override
    public DataBuffer data() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int length() {
        return this.wrapped.length();
    }

    @Override
    public double getDouble(int i) {
        if (this.wrapped.isVector()) {
            return this.wrapped.getDouble(i);
        }
        int vectorSize = this.wrapped.size(-1);
        int vectorIdx = Indices.rowNumber(i, this.wrapped);
        INDArray currVector = this.vectors.get(vectorIdx);
        int offset = vectorSize * vectorIdx;
        int idx = i - offset;
        return currVector.getDouble(idx);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.wrapped.length(); ++i) {
            sb.append(this.getDouble(i));
            if (i >= this.wrapped.length() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

