/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.ops.transforms.Transforms;

public class Adam
implements Serializable,
GradientUpdater {
    private double alpha = 0.001;
    private double beta1 = 0.9;
    private double beta2 = 0.999;
    private double epsilon = 1.0E-8;
    private INDArray m;
    private INDArray v;

    public Adam(double alpha, double beta1, double beta2, double epsilon) {
        this.alpha = alpha;
        this.beta1 = beta1;
        this.beta2 = beta2;
        this.epsilon = epsilon;
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        if (this.m == null) {
            this.m = Nd4j.zeros(gradient.shape());
        }
        if (this.v == null) {
            this.v = Nd4j.zeros(gradient.shape());
        }
        INDArray oneMinusBeta1Grad = gradient.mul(1.0 - this.beta1);
        this.m.muli(this.beta1).addi(oneMinusBeta1Grad);
        INDArray oneMinusBeta2GradSquared = gradient.mul(gradient).muli(1.0 - this.beta2);
        this.v.muli(this.beta2).addi(oneMinusBeta2GradSquared);
        double beta1t = FastMath.pow((double)this.beta1, (int)iteration);
        double beta2t = FastMath.pow((double)this.beta2, (int)iteration);
        double alphat = this.alpha * FastMath.sqrt((double)(1.0 - beta2t)) / (1.0 - beta1t);
        if (Double.isNaN(alphat) || alphat == 0.0) {
            alphat = Nd4j.EPS_THRESHOLD;
        }
        INDArray sqrtV = Transforms.sqrt(this.v).addi(this.epsilon);
        INDArray ret = this.m.mul(alphat).divi(sqrtV);
        return ret;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getBeta1() {
        return this.beta1;
    }

    public void setBeta1(double beta1) {
        this.beta1 = beta1;
    }

    public double getBeta2() {
        return this.beta2;
    }

    public void setBeta2(double beta2) {
        this.beta2 = beta2;
    }

    public INDArray getM() {
        return this.m;
    }

    public void setM(INDArray m) {
        this.m = m;
    }

    public INDArray getV() {
        return this.v;
    }

    public void setV(INDArray v) {
        this.v = v;
    }

    public Adam() {
    }
}

