/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import com.google.common.base.Function;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.loop.coordinatefunction.CoordinateFunction;
import org.nd4j.linalg.indexing.conditions.Condition;

public class BooleanIndexing {
    public static boolean and(IComplexNDArray n, Condition cond) {
        boolean ret = true;
        IComplexNDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret = ret && cond.apply(linear.getComplex(i)) != false;
        }
        return ret;
    }

    public static boolean or(IComplexNDArray n, Condition cond) {
        boolean ret = false;
        IComplexNDArray linear = n.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            ret = ret || cond.apply(linear.getComplex(i)) != false;
        }
        return ret;
    }

    public static boolean and(final INDArray n, final Condition cond) {
        boolean ret = true;
        final AtomicBoolean a = new AtomicBoolean(ret);
        Shape.iterate(n, new CoordinateFunction(){

            @Override
            public void process(int[] ... coord) {
                a.set(a.get() && cond.apply(Float.valueOf(n.getFloat(coord[0]))) != false);
            }
        });
        return ret;
    }

    public static boolean or(final INDArray n, final Condition cond) {
        boolean ret = false;
        final AtomicBoolean a = new AtomicBoolean(ret);
        Shape.iterate(n, new CoordinateFunction(){

            @Override
            public void process(int[] ... coord) {
                a.set(a.get() || cond.apply(Float.valueOf(n.getFloat(coord[0]))) != false);
            }
        });
        return ret;
    }

    public static void applyWhere(final INDArray to, final Condition condition, final Function<Number, Number> function) {
        Shape.iterate(to, new CoordinateFunction(){

            @Override
            public void process(int[] ... coord) {
                if (condition.apply(to.getDouble(coord[0])).booleanValue()) {
                    to.putScalar(coord[0], ((Number)function.apply((Object)to.getDouble(coord[0]))).floatValue());
                }
            }
        });
    }

    public static void applyWhere(final INDArray to, final Condition condition, final Function<Number, Number> function, final Function<Number, Number> alternativeFunction) {
        Shape.iterate(to, new CoordinateFunction(){

            @Override
            public void process(int[] ... coord) {
                if (condition.apply(Float.valueOf(to.getFloat(coord[0]))).booleanValue()) {
                    to.putScalar(coord[0], ((Number)function.apply((Object)to.getDouble(coord[0]))).floatValue());
                } else {
                    to.putScalar(coord[0], ((Number)alternativeFunction.apply((Object)to.getDouble(coord[0]))).floatValue());
                }
            }
        });
    }

    public static void applyWhere(IComplexNDArray to, Condition condition, Function<IComplexNumber, IComplexNumber> function) {
        IComplexNDArray linear = to.linearView();
        for (int i = 0; i < linear.linearView().length(); ++i) {
            if (!condition.apply(Float.valueOf(linear.getFloat(i))).booleanValue()) continue;
            linear.putScalar(i, (IComplexNumber)function.apply((Object)linear.getComplex(i)));
        }
    }
}

