/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.comparison;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class Max
extends BaseTransformOp {
    public Max() {
    }

    public Max(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public Max(INDArray x) {
        super(x);
    }

    public Max(INDArray ndArray, INDArray dup) {
        super(ndArray, dup);
    }

    public Max(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    @Override
    public String name() {
        return "max";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        double val = origin.absoluteValue().doubleValue();
        return val < other ? origin : Nd4j.createComplexNumber(other, 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        float val = origin.absoluteValue().floatValue();
        return val < other ? origin : Nd4j.createComplexNumber(Float.valueOf(other), 0.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.absoluteValue().doubleValue() < other.absoluteValue().doubleValue() ? origin : other;
    }

    @Override
    public float op(float origin, float other) {
        return FastMath.max((float)origin, (float)other);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.max((double)origin, (double)other);
    }

    @Override
    public double op(double origin) {
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Max(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Max(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Max(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Max(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

