/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class SigmoidDerivative
extends BaseTransformOp {
    public SigmoidDerivative() {
    }

    public SigmoidDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public SigmoidDerivative(INDArray x, INDArray z, int n) {
        super(x, z, n);
    }

    public SigmoidDerivative(INDArray x, INDArray y, INDArray z, int n) {
        super(x, y, z, n);
    }

    public SigmoidDerivative(INDArray x) {
        super(x);
    }

    @Override
    public String name() {
        return "sigmoidderivative";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return SigmoidDerivative.sigmoidDeriv(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return SigmoidDerivative.sigmoidDeriv(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return SigmoidDerivative.sigmoidDeriv(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)SigmoidDerivative.sigmoidDeriv(origin);
    }

    @Override
    public double op(double origin, double other) {
        return SigmoidDerivative.sigmoidDeriv(origin);
    }

    @Override
    public double op(double origin) {
        return SigmoidDerivative.sigmoidDeriv(origin);
    }

    @Override
    public float op(float origin) {
        return (float)SigmoidDerivative.sigmoidDeriv(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return SigmoidDerivative.sigmoidDeriv(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SigmoidDerivative(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SigmoidDerivative(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SigmoidDerivative(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SigmoidDerivative(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }

    private static double sigmoidDeriv(double input) {
        double sigmoid = 1.0 / (1.0 + FastMath.exp((double)(-input)));
        double out = sigmoid * (1.0 - sigmoid);
        if (Nd4j.ENFORCE_NUMERICAL_STABILITY && (Double.isNaN(out) || Double.isInfinite(out))) {
            out = Nd4j.EPS_THRESHOLD;
        }
        return out;
    }

    private static IComplexNumber sigmoidDeriv(IComplexNumber number) {
        double arg = number.complexArgument().doubleValue();
        double sigArg = 1.0 + FastMath.exp((double)(-arg)) - 1.0 + 0.5;
        double ret = Math.exp(sigArg);
        IComplexDouble sigmoid = Nd4j.createDouble(ret, 0.0);
        IComplexNumber oneMinus = Nd4j.createComplexNumber(1, 1).subi(sigmoid);
        return sigmoid.mul(oneMinus);
    }
}

