/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;
import org.nd4j.linalg.api.ops.Op;

public class ScalarMax
extends BaseScalarOp {
    public ScalarMax() {
    }

    public ScalarMax(INDArray x, INDArray y, INDArray z, int n, Number num) {
        super(x, y, z, n, num);
    }

    public ScalarMax(INDArray x, Number num) {
        super(x, num);
    }

    public ScalarMax(INDArray x, INDArray y, INDArray z, int n, IComplexNumber num) {
        super(x, y, z, n, num);
    }

    public ScalarMax(INDArray x, IComplexNumber num) {
        super(x, num);
    }

    @Override
    public String name() {
        return "max_scalar";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        if (origin.absoluteValue().doubleValue() > this.complexNumber.absoluteValue().doubleValue()) {
            return origin;
        }
        return this.complexNumber;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        if (origin.absoluteValue().doubleValue() > this.complexNumber.absoluteValue().doubleValue()) {
            return origin;
        }
        return this.complexNumber;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        if (origin.absoluteValue().doubleValue() > this.complexNumber.absoluteValue().doubleValue()) {
            return origin;
        }
        return this.complexNumber;
    }

    @Override
    public float op(float origin, float other) {
        return FastMath.max((float)origin, (float)this.num.floatValue());
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.max((double)origin, (double)this.num.doubleValue());
    }

    @Override
    public double op(double origin) {
        return FastMath.max((double)origin, (double)this.num.doubleValue());
    }

    @Override
    public float op(float origin) {
        return FastMath.max((float)origin, (float)this.num.floatValue());
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        if (origin.absoluteValue().doubleValue() > this.complexNumber.absoluteValue().doubleValue()) {
            return origin;
        }
        return this.complexNumber;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.num != null) {
            return new ScalarMax(this.x.vectorAlongDimension(index, dimension), this.num);
        }
        return new ScalarMax(this.x.vectorAlongDimension(index, dimension), this.complexNumber);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        if (this.num != null) {
            return new ScalarMax(this.x.tensorAlongDimension(index, dimension), this.num);
        }
        return new ScalarMax(this.x.tensorAlongDimension(index, dimension), this.complexNumber);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, int n) {
        super.init(x, y, z, n);
        this.extraArgs = this.num != null ? new Object[]{this.num} : new Object[]{this.complexNumber};
    }
}

